/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.utils.SyntacticEquivalence;
import org.sonarsource.slang.visitors.TreeContext;
import org.sonarsource.slang.visitors.TreeVisitor;

@Rule(key="S4144")
public class DuplicatedFunctionImplementationCheck
implements SlangCheck {
    private static final String MESSAGE = "Update this function so that its implementation is not identical to \"%s\" on line %s.";
    private static final String MESSAGE_NO_NAME = "Update this function so that its implementation is not identical to the one on line %s.";
    private static final int MINIMUM_STATEMENTS_COUNT = 2;

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            HashMap functionsByParents = new HashMap();
            TreeVisitor<TreeContext> functionVisitor = new TreeVisitor<TreeContext>();
            functionVisitor.register(FunctionDeclarationTree.class, (functionCtx, functionDeclarationTree) -> {
                if (!functionDeclarationTree.isConstructor()) {
                    functionsByParents.computeIfAbsent(functionCtx.ancestors().peek(), key2 -> new ArrayList()).add(functionDeclarationTree);
                }
            });
            functionVisitor.scan(new TreeContext(), (Tree)tree);
            for (Map.Entry entry : functionsByParents.entrySet()) {
                DuplicatedFunctionImplementationCheck.check(ctx, (List)entry.getValue());
            }
        });
    }

    private static void check(CheckContext ctx, List<FunctionDeclarationTree> functionDeclarations) {
        HashSet reportedDuplicates = new HashSet();
        IntStream.range(0, functionDeclarations.size()).forEach(i2 -> {
            FunctionDeclarationTree original = (FunctionDeclarationTree)functionDeclarations.get(i2);
            functionDeclarations.stream().skip((long)i2 + 1L).filter(f -> !reportedDuplicates.contains(f)).filter(DuplicatedFunctionImplementationCheck::hasMinimumSize).filter(f -> DuplicatedFunctionImplementationCheck.areDuplicatedImplementation(original, f)).forEach(duplicate -> {
                DuplicatedFunctionImplementationCheck.reportDuplicate(ctx, original, duplicate);
                reportedDuplicates.add(duplicate);
            });
        });
    }

    private static boolean hasMinimumSize(FunctionDeclarationTree function) {
        BlockTree functionBody = function.body();
        if (functionBody == null) {
            return false;
        }
        return functionBody.statementOrExpressions().size() >= 2;
    }

    private static boolean areDuplicatedImplementation(FunctionDeclarationTree original, FunctionDeclarationTree possibleDuplicate) {
        return SyntacticEquivalence.areEquivalent(original.nativeChildren(), possibleDuplicate.nativeChildren()) && SyntacticEquivalence.areEquivalent(original.formalParameters(), possibleDuplicate.formalParameters()) && SyntacticEquivalence.areEquivalent(original.body(), possibleDuplicate.body());
    }

    private static void reportDuplicate(CheckContext ctx, FunctionDeclarationTree original, FunctionDeclarationTree duplicate) {
        String message2;
        Tree secondaryTree;
        IdentifierTree identifier = original.name();
        int line = original.metaData().textRange().start().line();
        if (identifier != null) {
            secondaryTree = identifier;
            message2 = String.format(MESSAGE, identifier.name(), line);
        } else {
            secondaryTree = original;
            message2 = String.format(MESSAGE_NO_NAME, line);
        }
        SecondaryLocation secondaryLocation = new SecondaryLocation(secondaryTree, "original implementation");
        IdentifierTree duplicateIdentifier = duplicate.name();
        Tree primaryTree = duplicateIdentifier != null ? duplicateIdentifier : duplicate;
        ctx.reportIssue((HasTextRange)primaryTree, message2, secondaryLocation);
    }
}

