/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.MatchTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.utils.SyntacticEquivalence;

public abstract class AbstractBranchDuplicationCheck
implements SlangCheck {
    protected abstract void checkDuplicatedBranches(CheckContext var1, Tree var2, List<Tree> var3);

    protected abstract void onAllIdenticalBranches(CheckContext var1, Tree var2);

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, (ctx, tree) -> {
            Tree parent = ctx.parent();
            if (!(parent instanceof IfTree) || tree == ((IfTree)parent).thenBranch()) {
                this.checkConditionalStructure((CheckContext)ctx, (Tree)tree, new ConditionalStructure((IfTree)tree));
            }
        });
        init.register(MatchTree.class, (ctx, tree) -> this.checkConditionalStructure((CheckContext)ctx, (Tree)tree, new ConditionalStructure((MatchTree)tree)));
    }

    protected void checkConditionalStructure(CheckContext ctx, Tree tree, ConditionalStructure conditional) {
        if (conditional.allBranchesArePresent && conditional.allBranchesAreIdentical()) {
            this.onAllIdenticalBranches(ctx, tree);
        } else {
            this.checkDuplicatedBranches(ctx, tree, conditional.branches);
        }
    }

    public static class ConditionalStructure {
        private boolean allBranchesArePresent = false;
        private final List<Tree> branches = new ArrayList<Tree>();

        private ConditionalStructure(IfTree ifTree) {
            this.branches.add(ifTree.thenBranch());
            Tree elseBranch = ifTree.elseBranch();
            while (elseBranch != null) {
                if (elseBranch instanceof IfTree) {
                    IfTree elseIf = (IfTree)elseBranch;
                    this.branches.add(elseIf.thenBranch());
                    elseBranch = elseIf.elseBranch();
                    continue;
                }
                this.branches.add(elseBranch);
                this.allBranchesArePresent = true;
                elseBranch = null;
            }
        }

        private ConditionalStructure(MatchTree tree) {
            for (MatchCaseTree caseTree : tree.cases()) {
                this.branches.add(caseTree.body());
                if (caseTree.expression() != null) continue;
                this.allBranchesArePresent = true;
            }
        }

        private boolean allBranchesAreIdentical() {
            return this.branches.size() > 1 && this.branches.stream().skip(1L).allMatch(branch -> SyntacticEquivalence.areEquivalent(this.branches.get(0), branch));
        }
    }
}

