/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.plugin;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.WildcardPattern;

public class RubyExclusionsFileFilter
implements InputFileFilter {
    private final WildcardPattern[] excludedPatterns;

    public RubyExclusionsFileFilter(Configuration configuration) {
        this.excludedPatterns = WildcardPattern.create((String[])configuration.getStringArray("sonar.ruby.exclusions"));
    }

    public boolean accept(InputFile inputFile) {
        return RubyExclusionsFileFilter.isNotRubyFile(inputFile) || this.isNotExcluded(inputFile.uri().toString());
    }

    private static boolean isNotRubyFile(InputFile inputFile) {
        return !"ruby".equals(inputFile.language());
    }

    public boolean isNotExcluded(String filePath) {
        return !WildcardPattern.match((WildcardPattern[])this.excludedPatterns, (String)filePath);
    }
}

