/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.externalreport.rubocop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;
import org.sonarsource.ruby.externalreport.rubocop.RuboCopJsonReportReader;
import org.sonarsource.ruby.externalreport.rubocop.RuboCopRulesDefinition;
import org.sonarsource.slang.plugin.AbstractPropertyHandlerSensor;

public class RuboCopSensor
extends AbstractPropertyHandlerSensor {
    private static final Logger LOG = LoggerFactory.getLogger(RuboCopSensor.class);
    static final String LINTER_KEY = "rubocop";
    static final String LINTER_NAME = "RuboCop";
    public static final String REPORT_PROPERTY_KEY = "sonar.ruby.rubocop.reportPaths";
    private final Set<String> unresolvedInputFile = new HashSet<String>();
    private static final int MAX_LOGGED_FILE_NAMES = 20;

    public RuboCopSensor(AnalysisWarnings analysisWarnings) {
        super(analysisWarnings, LINTER_KEY, LINTER_NAME, REPORT_PROPERTY_KEY, "ruby");
    }

    @Override
    public void execute(SensorContext context) {
        this.unresolvedInputFile.clear();
        super.execute(context);
        this.logUnresolvedInputFiles();
    }

    @Override
    public Consumer<File> reportConsumer(SensorContext context) {
        return file2 -> RuboCopSensor.importReport(file2, context, this.unresolvedInputFile);
    }

    private void logUnresolvedInputFiles() {
        if (this.unresolvedInputFile.isEmpty()) {
            return;
        }
        Object fileList = this.unresolvedInputFile.stream().sorted().limit(20L).collect(Collectors.joining(";"));
        if (this.unresolvedInputFile.size() > 20) {
            fileList = (String)fileList + ";...";
        }
        LOG.warn("Fail to resolve {} file(s). No RuboCop issues will be imported on the following file(s): {}", (Object)this.unresolvedInputFile.size(), fileList);
    }

    private static void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFile) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            RuboCopJsonReportReader.read(in, issue -> RuboCopSensor.saveIssue(context, issue, unresolvedInputFile));
        }
        catch (IOException | RuntimeException | ParseException e) {
            LOG.error("No issues information will be saved as the report file '{}' can't be read. " + e.getMessage(), (Object)reportPath, (Object)e);
        }
    }

    private static void saveIssue(SensorContext context, RuboCopJsonReportReader.Issue issue, Set<String> unresolvedInputFile) {
        if (RuboCopSensor.isEmpty(issue.ruleKey) || RuboCopSensor.isEmpty(issue.filePath) || RuboCopSensor.isEmpty(issue.message)) {
            LOG.debug("Missing information or unsupported file type for ruleKey:'{}', filePath:'{}', message:'{}'", new Object[]{issue.ruleKey, issue.filePath, issue.message});
            return;
        }
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.hasPath(issue.filePath));
        if (inputFile == null) {
            unresolvedInputFile.add(issue.filePath);
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        ExternalRuleLoader externalRuleLoader = RuboCopRulesDefinition.RULE_LOADER;
        newExternalIssue.type(externalRuleLoader.ruleType(issue.ruleKey)).severity(externalRuleLoader.ruleSeverity(issue.ruleKey)).remediationEffortMinutes(externalRuleLoader.ruleConstantDebtMinutes(issue.ruleKey));
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile);
        if (issue.startLine != null) {
            try {
                boolean rangeIsProvided;
                boolean bl = rangeIsProvided = issue.startColumn != null && issue.lastLine != null && issue.lastColumn != null;
                if (rangeIsProvided) {
                    primaryLocation.at(inputFile.newRange(issue.startLine.intValue(), issue.startColumn - 1, issue.lastLine.intValue(), issue.lastColumn.intValue()));
                } else {
                    primaryLocation.at(inputFile.selectLine(issue.startLine.intValue()));
                }
            }
            catch (IllegalArgumentException e) {
                primaryLocation.at(inputFile.selectLine(issue.startLine.intValue()));
            }
        }
        newExternalIssue.at(primaryLocation).engineId(LINTER_KEY).ruleId(issue.ruleKey).save();
    }

    private static boolean isEmpty(@Nullable String value2) {
        return value2 == null || value2.trim().isEmpty();
    }
}

