/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.externalreport.rubocop;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class RuboCopJsonReportReader {
    private final JSONParser jsonParser = new JSONParser();
    private final Consumer<Issue> consumer;

    private RuboCopJsonReportReader(Consumer<Issue> consumer) {
        this.consumer = consumer;
    }

    static void read(InputStream in, Consumer<Issue> consumer) throws IOException, ParseException {
        new RuboCopJsonReportReader(consumer).read(in);
    }

    private void read(InputStream in) throws IOException, ParseException {
        JSONObject rootObject = (JSONObject)this.jsonParser.parse(new InputStreamReader(in, StandardCharsets.UTF_8));
        JSONArray files = (JSONArray)rootObject.get("files");
        if (files != null) {
            files.stream().forEach(this::onFile);
        }
    }

    private void onFile(JSONObject file2) {
        String filePath = (String)file2.get("path");
        JSONArray offenses = (JSONArray)file2.get("offenses");
        if (offenses != null) {
            offenses.stream().forEach(offense -> this.onOffense(filePath, (JSONObject)offense));
        }
    }

    private void onOffense(@Nullable String filePath, JSONObject offense) {
        Issue issue = new Issue();
        issue.filePath = filePath;
        issue.ruleKey = (String)offense.get("cop_name");
        issue.message = (String)offense.get("message");
        JSONObject location = (JSONObject)offense.get("location");
        if (location != null) {
            issue.startLine = RuboCopJsonReportReader.toInteger(location.get("start_line"));
            issue.startColumn = RuboCopJsonReportReader.toInteger(location.get("start_column"));
            issue.lastLine = RuboCopJsonReportReader.toInteger(location.get("last_line"));
            issue.lastColumn = RuboCopJsonReportReader.toInteger(location.get("last_column"));
            if (issue.startLine == null) {
                issue.startLine = RuboCopJsonReportReader.toInteger(location.get("line"));
            }
        }
        this.consumer.accept(issue);
    }

    private static Integer toInteger(Object value2) {
        if (value2 instanceof Number) {
            Number number = (Number)value2;
            return number.intValue();
        }
        return null;
    }

    public static class Issue {
        @Nullable
        String filePath;
        @Nullable
        String ruleKey;
        @Nullable
        String message;
        @Nullable
        Integer startLine;
        @Nullable
        Integer startColumn;
        @Nullable
        Integer lastLine;
        @Nullable
        Integer lastColumn;
    }
}

