/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.checks;

import java.util.List;
import java.util.Set;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.UnusedLocalVariableCheck;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.utils.FunctionUtils;
import org.sonarsource.slang.utils.SyntacticEquivalence;

public class UnusedLocalVariableRubyCheck
extends UnusedLocalVariableCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, functionDeclarationTree) -> {
            if (ctx.ancestors().stream().anyMatch(FunctionDeclarationTree.class::isInstance)) {
                return;
            }
            Set<IdentifierTree> variableIdentifiers = this.getVariableIdentifierTrees((FunctionDeclarationTree)functionDeclarationTree);
            Set<Tree> identifierTrees = this.getIdentifierTrees((FunctionDeclarationTree)functionDeclarationTree, variableIdentifiers);
            List<IdentifierTree> unusedVariables = variableIdentifiers.stream().filter(variable -> identifierTrees.stream().noneMatch(identifier -> SyntacticEquivalence.areEquivalent(variable, identifier))).toList();
            if (unusedVariables.isEmpty()) {
                return;
            }
            Set<String> stringLiteralTokens = FunctionUtils.getStringsTokens(functionDeclarationTree, "\\s|#\\{|}|:");
            unusedVariables.stream().filter(variable -> !stringLiteralTokens.contains(variable.name())).forEach(identifier -> ctx.reportIssue((HasTextRange)identifier, "Remove this unused \"" + identifier.name() + "\" local variable."));
        });
    }
}

