/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class SetUtils {
    private SetUtils() {
    }

    @SafeVarargs
    public static <T> Set<T> immutableSetOf(T ... elements) {
        HashSet<T> set2 = new HashSet<T>(Arrays.asList(elements));
        return Collections.unmodifiableSet(set2);
    }

    @SafeVarargs
    public static <T> Set<T> concat(Set<T> ... sets) {
        return Arrays.stream(sets).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static <T> Set<T> difference(Set<T> set1, Set<T> set2) {
        HashSet<T> newSet1 = new HashSet<T>(set1);
        newSet1.removeAll(set2);
        return newSet1;
    }

    public static <T> T getOnlyElement(Set<T> set2) {
        if (set2.size() == 1) {
            return set2.iterator().next();
        }
        throw new IllegalArgumentException(String.format("Expected set of size 1, but was set of size %d.", set2.size()));
    }
}

