/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

public class TokenLocation {
    private final int startLine;
    private final int startLineOffset;
    private final int endLine;
    private final int endLineOffset;

    public TokenLocation(int line, int column, String value2) {
        this.startLine = line;
        this.startLineOffset = column;
        String[] lines2 = value2.split("\r\n|\n|\r", -1);
        if (lines2.length > 1) {
            this.endLine = line + lines2.length - 1;
            this.endLineOffset = lines2[lines2.length - 1].length();
        } else {
            this.endLine = this.startLine;
            this.endLineOffset = this.startLineOffset + value2.length();
        }
    }

    public int startLine() {
        return this.startLine;
    }

    public int startLineOffset() {
        return this.startLineOffset;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endLineOffset() {
        return this.endLineOffset;
    }
}

