/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LengthPrefixSerializer {
    private LengthPrefixSerializer() {
    }

    public static byte[] serializeList(List<byte[]> toSerializeList) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream dos = new DataOutputStream(byteArrayOutputStream);){
                for (byte[] toSerializeElement : toSerializeList) {
                    LengthPrefixSerializer.writeLengthAndBytes(dos, toSerializeElement);
                }
                object = byteArrayOutputStream.toByteArray();
            }
            return object;
        }
    }

    public static List<byte[]> unserializeList(byte[] data) throws IOException {
        return LengthPrefixSerializer.unserializeList(new ByteArrayInputStream(data));
    }

    public static List<byte[]> unserializeList(InputStream data) throws IOException {
        ArrayList<byte[]> result2 = new ArrayList<byte[]>();
        try (DataInputStream dis = new DataInputStream(data);){
            while (dis.available() > 0) {
                result2.add(LengthPrefixSerializer.readBytes(dis));
            }
        }
        return result2;
    }

    public static byte[] serializeMap(Map<String, byte[]> toSerializeMap) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream dos = new DataOutputStream(byteArrayOutputStream);){
                for (Map.Entry<String, byte[]> toSerializeElement : toSerializeMap.entrySet()) {
                    LengthPrefixSerializer.writeLengthAndBytes(dos, toSerializeElement.getKey().getBytes(StandardCharsets.UTF_8));
                    LengthPrefixSerializer.writeLengthAndBytes(dos, toSerializeElement.getValue());
                }
                object = byteArrayOutputStream.toByteArray();
            }
            return object;
        }
    }

    public static Map<String, byte[]> unserializeMap(byte[] data) throws IOException {
        return LengthPrefixSerializer.unserializeMap(new ByteArrayInputStream(data));
    }

    public static Map<String, byte[]> unserializeMap(InputStream data) throws IOException {
        HashMap<String, byte[]> result2 = new HashMap<String, byte[]>();
        try (DataInputStream dis = new DataInputStream(data);){
            while (dis.available() > 0) {
                String key2 = new String(LengthPrefixSerializer.readBytes(dis), StandardCharsets.UTF_8);
                byte[] value2 = LengthPrefixSerializer.readBytes(dis);
                result2.put(key2, value2);
            }
        }
        return result2;
    }

    private static byte[] readBytes(DataInputStream dis) throws IOException {
        int length2 = dis.readInt();
        LengthPrefixSerializer.validateLength(length2);
        byte[] bytes2 = new byte[length2];
        dis.readFully(bytes2);
        return bytes2;
    }

    private static void writeLengthAndBytes(DataOutputStream dos, byte[] bytes2) throws IOException {
        dos.writeInt(bytes2.length);
        dos.write(bytes2);
    }

    private static void validateLength(int length2) throws IOException {
        if (length2 < 0) {
            throw new IOException("Invalid length while unserializing: " + length2);
        }
    }
}

