/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.ConstantDynamic;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.TypeReference;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.analysis.Analyzer;
import org.jruby.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jruby.org.objectweb.asm.tree.analysis.BasicValue;
import org.jruby.org.objectweb.asm.tree.analysis.BasicVerifier;
import org.jruby.org.objectweb.asm.tree.analysis.Interpreter;
import org.jruby.org.objectweb.asm.util.CheckAnnotationAdapter;
import org.jruby.org.objectweb.asm.util.CheckClassAdapter;
import org.jruby.org.objectweb.asm.util.CheckFrameAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMethodAdapter
extends MethodVisitor {
    private static final Method[] OPCODE_METHODS = new Method[]{Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INT_INSN, Method.VISIT_INT_INSN, null, null, null, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_VAR_INSN, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, null, Method.VISIT_TYPE_INSN, Method.VISIT_INT_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_INSN, Method.VISIT_INSN, null, null, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN};
    private static final String INVALID = "Invalid ";
    private static final String INVALID_DESCRIPTOR = "Invalid descriptor: ";
    private static final String INVALID_TYPE_REFERENCE = "Invalid type reference sort 0x";
    private static final String INVALID_LOCAL_VARIABLE_INDEX = "Invalid local variable index";
    private static final String MUST_NOT_BE_NULL_OR_EMPTY = " (must not be null or empty)";
    private static final String START_LABEL = "start label";
    private static final String END_LABEL = "end label";
    public int version;
    private int access;
    private int visibleAnnotableParameterCount;
    private int invisibleAnnotableParameterCount;
    private boolean visitCodeCalled;
    private boolean visitMaxCalled;
    private boolean visitEndCalled;
    private int insnCount;
    private final Map<Label, Integer> labelInsnIndices;
    private Set<Label> referencedLabels;
    private int lastFrameInsnIndex = -1;
    private int numExpandedFrames;
    private int numCompressedFrames;
    private List<Label> handlers;

    public CheckMethodAdapter(MethodVisitor methodvisitor) {
        this(methodvisitor, new HashMap<Label, Integer>());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map<Label, Integer> labelInsnIndices) {
        this(589824, methodVisitor, labelInsnIndices);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int api, MethodVisitor methodVisitor, Map<Label, Integer> labelInsnIndices) {
        super(api, methodVisitor);
        this.labelInsnIndices = labelInsnIndices;
        this.referencedLabels = new HashSet<Label>();
        this.handlers = new ArrayList<Label>();
    }

    public CheckMethodAdapter(int access, String name2, String descriptor, MethodVisitor methodVisitor, Map<Label, Integer> labelInsnIndices) {
        this(589824, access, name2, descriptor, methodVisitor, labelInsnIndices);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int api, int access, String name2, String descriptor, final MethodVisitor methodVisitor, Map<Label, Integer> labelInsnIndices) {
        this(api, new MethodNode(api, access, name2, descriptor, null, null){

            @Override
            public void visitEnd() {
                int originalMaxLocals = this.maxLocals;
                int originalMaxStack = this.maxStack;
                boolean checkMaxStackAndLocals = false;
                boolean checkFrames = false;
                if (methodVisitor instanceof MethodWriterWrapper) {
                    MethodWriterWrapper methodWriter = (MethodWriterWrapper)methodVisitor;
                    checkMaxStackAndLocals = !methodWriter.computesMaxs();
                    checkFrames = methodWriter.requiresFrames() && !methodWriter.computesFrames();
                }
                CheckFrameAnalyzer<BasicValue> analyzer = checkFrames ? new CheckFrameAnalyzer<BasicValue>((Interpreter<BasicValue>)new BasicVerifier()) : new Analyzer((Interpreter)new BasicVerifier());
                try {
                    if (checkMaxStackAndLocals) {
                        analyzer.analyze("dummy", this);
                    } else {
                        analyzer.analyzeAndComputeMaxs("dummy", this);
                    }
                }
                catch (IndexOutOfBoundsException | AnalyzerException e) {
                    this.throwError(analyzer, (Exception)e);
                }
                if (methodVisitor != null) {
                    this.maxLocals = originalMaxLocals;
                    this.maxStack = originalMaxStack;
                    this.accept(methodVisitor);
                }
            }

            private void throwError(Analyzer<BasicValue> analyzer, Exception e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                CheckClassAdapter.printAnalyzerResult(this, analyzer, printWriter);
                printWriter.close();
                throw new IllegalArgumentException(1.stringConcat$0(e.getMessage(), stringWriter.toString()), e);
            }

            private static /* synthetic */ String stringConcat$0(String string2, String string3) {
                return string2 + " " + string3;
            }
        }, labelInsnIndices);
        this.access = access;
    }

    @Override
    public void visitParameter(String name2, int access) {
        if (name2 != null) {
            CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        }
        CheckClassAdapter.checkAccess(access, 36880);
        super.visitParameter(name2, access);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(descriptor, visible));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.checkVisitEndNotCalled();
        int sort2 = new TypeReference(typeRef).getSort();
        if (sort2 != 1 && sort2 != 18 && sort2 != 20 && sort2 != 21 && sort2 != 22 && sort2 != 23) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$0(Integer.toHexString(sort2)));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
    }

    private static /* synthetic */ String stringConcat$0(String string2) {
        return INVALID_TYPE_REFERENCE + string2;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkVisitEndNotCalled();
        return new CheckAnnotationAdapter(super.visitAnnotationDefault(), false);
    }

    @Override
    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.checkVisitEndNotCalled();
        if (visible) {
            this.visibleAnnotableParameterCount = parameterCount;
        } else {
            this.invisibleAnnotableParameterCount = parameterCount;
        }
        super.visitAnnotableParameterCount(parameterCount, visible);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        this.checkVisitEndNotCalled();
        if (visible && this.visibleAnnotableParameterCount > 0 && parameter >= this.visibleAnnotableParameterCount || !visible && this.invisibleAnnotableParameterCount > 0 && parameter >= this.invisibleAnnotableParameterCount) {
            throw new IllegalArgumentException("Invalid parameter index");
        }
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitParameterAnnotation(parameter, descriptor, visible));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkVisitEndNotCalled();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        if ((this.access & 0x400) != 0) {
            throw new UnsupportedOperationException("Abstract methods cannot have code");
        }
        this.visitCodeCalled = true;
        super.visitCode();
    }

    @Override
    public void visitFrame(int type2, int numLocal, Object[] local2, int numStack, Object[] stack) {
        int i2;
        int maxNumStack;
        int maxNumLocal;
        if (this.insnCount == this.lastFrameInsnIndex) {
            throw new IllegalStateException("At most one frame can be visited at a given code location.");
        }
        this.lastFrameInsnIndex = this.insnCount;
        switch (type2) {
            case -1: 
            case 0: {
                maxNumLocal = Integer.MAX_VALUE;
                maxNumStack = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                maxNumLocal = 0;
                maxNumStack = 0;
                break;
            }
            case 4: {
                maxNumLocal = 0;
                maxNumStack = 1;
                break;
            }
            case 1: 
            case 2: {
                maxNumLocal = 3;
                maxNumStack = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$1(type2));
            }
        }
        if (numLocal > maxNumLocal) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$2(numLocal, type2));
        }
        if (numStack > maxNumStack) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$3(numStack, type2));
        }
        if (type2 != 2) {
            if (numLocal > 0 && (local2 == null || local2.length < numLocal)) {
                throw new IllegalArgumentException("Array local[] is shorter than numLocal");
            }
            for (i2 = 0; i2 < numLocal; ++i2) {
                this.checkFrameValue(local2[i2]);
            }
        }
        if (numStack > 0 && (stack == null || stack.length < numStack)) {
            throw new IllegalArgumentException("Array stack[] is shorter than numStack");
        }
        for (i2 = 0; i2 < numStack; ++i2) {
            this.checkFrameValue(stack[i2]);
        }
        if (type2 == -1) {
            ++this.numExpandedFrames;
        } else {
            ++this.numCompressedFrames;
        }
        if (this.numExpandedFrames > 0 && this.numCompressedFrames > 0) {
            throw new IllegalArgumentException("Expanded and compressed frames must not be mixed.");
        }
        super.visitFrame(type2, numLocal, local2, numStack, stack);
    }

    private static /* synthetic */ String stringConcat$1(int n) {
        return "Invalid frame type " + n;
    }

    private static /* synthetic */ String stringConcat$2(int n, int n2) {
        return "Invalid numLocal=" + n + " for frame type " + n2;
    }

    private static /* synthetic */ String stringConcat$3(int n, int n2) {
        return "Invalid numStack=" + n + " for frame type " + n2;
    }

    @Override
    public void visitInsn(int opcode) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(opcode, Method.VISIT_INSN);
        super.visitInsn(opcode);
        ++this.insnCount;
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(opcode, Method.VISIT_INT_INSN);
        switch (opcode) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(operand, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(operand, "Invalid operand");
                break;
            }
            case 188: {
                if (operand >= 4 && operand <= 11) break;
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$4(operand));
            }
            default: {
                throw new AssertionError();
            }
        }
        super.visitIntInsn(opcode, operand);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$4(int n) {
        return "Invalid operand (must be an array type code T_...): " + n;
    }

    @Override
    public void visitVarInsn(int opcode, int varIndex) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(opcode, Method.VISIT_VAR_INSN);
        CheckMethodAdapter.checkUnsignedShort(varIndex, INVALID_LOCAL_VARIABLE_INDEX);
        super.visitVarInsn(opcode, varIndex);
        ++this.insnCount;
    }

    @Override
    public void visitTypeInsn(int opcode, String type2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(opcode, Method.VISIT_TYPE_INSN);
        CheckMethodAdapter.checkInternalName(this.version, type2, "type");
        if (opcode == 187 && type2.charAt(0) == '[') {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$5(type2));
        }
        super.visitTypeInsn(opcode, type2);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$5(String string2) {
        return "NEW cannot be used to create arrays: " + string2;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner2, String name2, String descriptor) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(opcode, Method.VISIT_FIELD_INSN);
        CheckMethodAdapter.checkInternalName(this.version, owner2, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        super.visitFieldInsn(opcode, owner2, name2, descriptor);
        ++this.insnCount;
    }

    @Override
    public void visitMethodInsn(int opcodeAndSource, String owner2, String name2, String descriptor, boolean isInterface) {
        if (this.api < 327680 && (opcodeAndSource & 0x100) == 0) {
            super.visitMethodInsn(opcodeAndSource, owner2, name2, descriptor, isInterface);
            return;
        }
        int opcode = opcodeAndSource & 0xFFFFFEFF;
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(opcode, Method.VISIT_METHOD_INSN);
        if (opcode != 183 || !"<init>".equals(name2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "name");
        }
        CheckMethodAdapter.checkInternalName(this.version, owner2, "owner");
        CheckMethodAdapter.checkMethodDescriptor(this.version, descriptor);
        if (opcode == 182 && isInterface) {
            throw new IllegalArgumentException("INVOKEVIRTUAL can't be used with interfaces");
        }
        if (opcode == 185 && !isInterface) {
            throw new IllegalArgumentException("INVOKEINTERFACE can't be used with classes");
        }
        if (opcode == 183 && isInterface && (this.version & 0xFFFF) < 52) {
            throw new IllegalArgumentException("INVOKESPECIAL can't be used with interfaces prior to Java 8");
        }
        super.visitMethodInsn(opcodeAndSource, owner2, name2, descriptor, isInterface);
        ++this.insnCount;
    }

    @Override
    public void visitInvokeDynamicInsn(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "name");
        CheckMethodAdapter.checkMethodDescriptor(this.version, descriptor);
        if (bootstrapMethodHandle.getTag() != 6 && bootstrapMethodHandle.getTag() != 8) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$6(bootstrapMethodHandle.getTag()));
        }
        for (Object bootstrapMethodArgument : bootstrapMethodArguments) {
            this.checkLdcConstant(bootstrapMethodArgument);
        }
        super.visitInvokeDynamicInsn(name2, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$6(int n) {
        return "invalid handle tag " + n;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(opcode, Method.VISIT_JUMP_INSN);
        this.checkLabel(label2, false, "label");
        super.visitJumpInsn(opcode, label2);
        ++this.insnCount;
    }

    @Override
    public void visitLabel(Label label2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLabel(label2, false, "label");
        if (this.labelInsnIndices.get(label2) != null) {
            throw new IllegalStateException("Already visited label");
        }
        this.labelInsnIndices.put(label2, this.insnCount);
        super.visitLabel(label2);
    }

    @Override
    public void visitLdcInsn(Object value2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLdcConstant(value2);
        super.visitLdcInsn(value2);
        ++this.insnCount;
    }

    @Override
    public void visitIincInsn(int varIndex, int increment) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnsignedShort(varIndex, INVALID_LOCAL_VARIABLE_INDEX);
        CheckMethodAdapter.checkSignedShort(increment, "Invalid increment");
        super.visitIincInsn(varIndex, increment);
        ++this.insnCount;
    }

    @Override
    public void visitTableSwitchInsn(int min2, int max2, Label dflt, Label ... labels) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        if (max2 < min2) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$7(max2, min2));
        }
        this.checkLabel(dflt, false, "default label");
        if (labels == null || labels.length != max2 - min2 + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i2 = 0; i2 < labels.length; ++i2) {
            this.checkLabel(labels[i2], false, CheckMethodAdapter.stringConcat$8(i2));
        }
        super.visitTableSwitchInsn(min2, max2, dflt, labels);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$7(int n, int n2) {
        return "Max = " + n + " must be greater than or equal to min = " + n2;
    }

    private static /* synthetic */ String stringConcat$8(int n) {
        return "label at index " + n;
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        this.checkVisitMaxsNotCalled();
        this.checkVisitCodeCalled();
        this.checkLabel(dflt, false, "default label");
        if (keys2 == null || labels == null || keys2.length != labels.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i2 = 0; i2 < labels.length; ++i2) {
            this.checkLabel(labels[i2], false, CheckMethodAdapter.stringConcat$9(i2));
        }
        super.visitLookupSwitchInsn(dflt, keys2, labels);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$9(int n) {
        return "label at index " + n;
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        if (descriptor.charAt(0) != '[') {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$10(descriptor));
        }
        if (numDimensions < 1) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$11(numDimensions));
        }
        if (numDimensions > descriptor.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$12(numDimensions));
        }
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$10(String string2) {
        return "Invalid descriptor (must be an array type descriptor): " + string2;
    }

    private static /* synthetic */ String stringConcat$11(int n) {
        return "Invalid dimensions (must be greater than 0): " + n;
    }

    private static /* synthetic */ String stringConcat$12(int n) {
        return "Invalid dimensions (must not be greater than numDimensions(descriptor)): " + n;
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int sort2 = new TypeReference(typeRef).getSort();
        if (sort2 != 67 && sort2 != 68 && sort2 != 69 && sort2 != 70 && sort2 != 71 && sort2 != 72 && sort2 != 73 && sort2 != 74 && sort2 != 75) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$13(Integer.toHexString(sort2)));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitInsnAnnotation(typeRef, typePath, descriptor, visible));
    }

    private static /* synthetic */ String stringConcat$13(String string2) {
        return INVALID_TYPE_REFERENCE + string2;
    }

    @Override
    public void visitTryCatchBlock(Label start2, Label end2, Label handler, String type2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLabel(start2, false, START_LABEL);
        this.checkLabel(end2, false, END_LABEL);
        this.checkLabel(handler, false, "handler label");
        if (this.labelInsnIndices.get(start2) != null || this.labelInsnIndices.get(end2) != null || this.labelInsnIndices.get(handler) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (type2 != null) {
            CheckMethodAdapter.checkInternalName(this.version, type2, "type");
        }
        super.visitTryCatchBlock(start2, end2, handler, type2);
        this.handlers.add(start2);
        this.handlers.add(end2);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int sort2 = new TypeReference(typeRef).getSort();
        if (sort2 != 66) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$14(Integer.toHexString(sort2)));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible));
    }

    private static /* synthetic */ String stringConcat$14(String string2) {
        return INVALID_TYPE_REFERENCE + string2;
    }

    @Override
    public void visitLocalVariable(String name2, String descriptor, String signature, Label start2, Label end2, int index2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        if (signature != null) {
            CheckClassAdapter.checkFieldSignature(signature);
        }
        this.checkLabel(start2, true, START_LABEL);
        this.checkLabel(end2, true, END_LABEL);
        CheckMethodAdapter.checkUnsignedShort(index2, INVALID_LOCAL_VARIABLE_INDEX);
        int startInsnIndex = this.labelInsnIndices.get(start2);
        int endInsnIndex = this.labelInsnIndices.get(end2);
        if (endInsnIndex < startInsnIndex) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        super.visitLocalVariable(name2, descriptor, signature, start2, end2, index2);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start2, Label[] end2, int[] index2, String descriptor, boolean visible) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int sort2 = new TypeReference(typeRef).getSort();
        if (sort2 != 64 && sort2 != 65) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$15(Integer.toHexString(sort2)));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        if (start2 == null || end2 == null || index2 == null || end2.length != start2.length || index2.length != start2.length) {
            throw new IllegalArgumentException("Invalid start, end and index arrays (must be non null and of identical length");
        }
        for (int i2 = 0; i2 < start2.length; ++i2) {
            this.checkLabel(start2[i2], true, START_LABEL);
            this.checkLabel(end2[i2], true, END_LABEL);
            CheckMethodAdapter.checkUnsignedShort(index2[i2], INVALID_LOCAL_VARIABLE_INDEX);
            int startInsnIndex = this.labelInsnIndices.get(start2[i2]);
            int endInsnIndex = this.labelInsnIndices.get(end2[i2]);
            if (endInsnIndex >= startInsnIndex) continue;
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        return super.visitLocalVariableAnnotation(typeRef, typePath, start2, end2, index2, descriptor, visible);
    }

    private static /* synthetic */ String stringConcat$15(String string2) {
        return INVALID_TYPE_REFERENCE + string2;
    }

    @Override
    public void visitLineNumber(int line, Label start2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnsignedShort(line, "Invalid line number");
        this.checkLabel(start2, true, START_LABEL);
        super.visitLineNumber(line, start2);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.visitMaxCalled = true;
        for (Label l : this.referencedLabels) {
            if (this.labelInsnIndices.get(l) != null) continue;
            throw new IllegalStateException("Undefined label used");
        }
        for (int i2 = 0; i2 < this.handlers.size(); i2 += 2) {
            Integer startInsnIndex = this.labelInsnIndices.get(this.handlers.get(i2));
            Integer endInsnIndex = this.labelInsnIndices.get(this.handlers.get(i2 + 1));
            if (endInsnIndex > startInsnIndex) continue;
            throw new IllegalStateException("Empty try catch block handler range");
        }
        CheckMethodAdapter.checkUnsignedShort(maxStack, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(maxLocals, "Invalid max locals");
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkVisitCodeCalled() {
        if (!this.visitCodeCalled) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    private void checkVisitMaxsNotCalled() {
        if (this.visitMaxCalled) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    private void checkFrameValue(Object value2) {
        if (value2 == Opcodes.TOP || value2 == Opcodes.INTEGER || value2 == Opcodes.FLOAT || value2 == Opcodes.LONG || value2 == Opcodes.DOUBLE || value2 == Opcodes.NULL || value2 == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (value2 instanceof String) {
            CheckMethodAdapter.checkInternalName(this.version, (String)value2, "Invalid stack frame value");
        } else if (value2 instanceof Label) {
            this.checkLabel((Label)value2, false, "label");
        } else {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$16(value2));
        }
    }

    private static /* synthetic */ String stringConcat$16(Object object) {
        return "Invalid stack frame value: " + object;
    }

    private static void checkOpcodeMethod(int opcode, Method method2) {
        if (opcode < 0 || opcode > 199) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$17(opcode));
        }
        if (OPCODE_METHODS[opcode] != method2) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$18(opcode, method2));
        }
    }

    private static /* synthetic */ String stringConcat$17(int n) {
        return "Invalid opcode: " + n;
    }

    private static /* synthetic */ String stringConcat$18(int n, Method method2) {
        return "Invalid combination of opcode and method: " + n + ", " + (Object)((Object)method2);
    }

    private static void checkSignedByte(int value2, String message2) {
        if (value2 < -128 || value2 > 127) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$19(message2, value2));
        }
    }

    private static /* synthetic */ String stringConcat$19(String string2, int n) {
        return string2 + " (must be a signed byte): " + n;
    }

    private static void checkSignedShort(int value2, String message2) {
        if (value2 < Short.MIN_VALUE || value2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$20(message2, value2));
        }
    }

    private static /* synthetic */ String stringConcat$20(String string2, int n) {
        return string2 + " (must be a signed short): " + n;
    }

    private static void checkUnsignedShort(int value2, String message2) {
        if (value2 < 0 || value2 > 65535) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$21(message2, value2));
        }
    }

    private static /* synthetic */ String stringConcat$21(String string2, int n) {
        return string2 + " (must be an unsigned short): " + n;
    }

    static void checkConstant(Object value2) {
        if (!(value2 instanceof Integer || value2 instanceof Float || value2 instanceof Long || value2 instanceof Double || value2 instanceof String)) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$22(value2));
        }
    }

    private static /* synthetic */ String stringConcat$22(Object object) {
        return "Invalid constant: " + object;
    }

    private void checkLdcConstant(Object value2) {
        if (value2 instanceof Type) {
            int sort2 = ((Type)value2).getSort();
            if (sort2 != 10 && sort2 != 9 && sort2 != 11) {
                throw new IllegalArgumentException("Illegal LDC constant value");
            }
            if (sort2 != 11 && (this.version & 0xFFFF) < 49) {
                throw new IllegalArgumentException("ldc of a constant class requires at least version 1.5");
            }
            if (sort2 == 11 && (this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a method type requires at least version 1.7");
            }
        } else if (value2 instanceof Handle) {
            if ((this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a Handle requires at least version 1.7");
            }
            Handle handle = (Handle)value2;
            int tag2 = handle.getTag();
            if (tag2 < 1 || tag2 > 9) {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$23(tag2));
            }
            CheckMethodAdapter.checkInternalName(this.version, handle.getOwner(), "handle owner");
            if (tag2 <= 4) {
                CheckMethodAdapter.checkDescriptor(this.version, handle.getDesc(), false);
            } else {
                CheckMethodAdapter.checkMethodDescriptor(this.version, handle.getDesc());
            }
            String handleName = handle.getName();
            if (!"<init>".equals(handleName) || tag2 != 8) {
                CheckMethodAdapter.checkMethodIdentifier(this.version, handleName, "handle name");
            }
        } else if (value2 instanceof ConstantDynamic) {
            if ((this.version & 0xFFFF) < 55) {
                throw new IllegalArgumentException("ldc of a ConstantDynamic requires at least version 11");
            }
            ConstantDynamic constantDynamic = (ConstantDynamic)value2;
            CheckMethodAdapter.checkMethodIdentifier(this.version, constantDynamic.getName(), "constant dynamic name");
            CheckMethodAdapter.checkDescriptor(this.version, constantDynamic.getDescriptor(), false);
            this.checkLdcConstant(constantDynamic.getBootstrapMethod());
            int bootstrapMethodArgumentCount = constantDynamic.getBootstrapMethodArgumentCount();
            for (int i2 = 0; i2 < bootstrapMethodArgumentCount; ++i2) {
                this.checkLdcConstant(constantDynamic.getBootstrapMethodArgument(i2));
            }
        } else {
            CheckMethodAdapter.checkConstant(value2);
        }
    }

    private static /* synthetic */ String stringConcat$23(int n) {
        return "invalid handle tag " + n;
    }

    static void checkUnqualifiedName(int version, String name2, String message2) {
        CheckMethodAdapter.checkIdentifier(version, name2, 0, -1, message2);
    }

    static void checkIdentifier(int version, String name2, int startPos, int endPos, String message2) {
        int max2;
        if (name2 == null || (endPos == -1 ? name2.length() <= startPos : endPos <= startPos)) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$24(message2));
        }
        int n = max2 = endPos == -1 ? name2.length() : endPos;
        if ((version & 0xFFFF) >= 49) {
            int i2 = startPos;
            while (i2 < max2) {
                if (".;[/".indexOf(name2.codePointAt(i2)) != -1) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$25(message2, name2));
                }
                i2 = name2.offsetByCodePoints(i2, 1);
            }
            return;
        }
        int i3 = startPos;
        while (i3 < max2) {
            if (i3 == startPos ? !Character.isJavaIdentifierStart(name2.codePointAt(i3)) : !Character.isJavaIdentifierPart(name2.codePointAt(i3))) {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$26(message2, name2));
            }
            i3 = name2.offsetByCodePoints(i3, 1);
        }
    }

    private static /* synthetic */ String stringConcat$24(String string2) {
        return INVALID + string2 + MUST_NOT_BE_NULL_OR_EMPTY;
    }

    private static /* synthetic */ String stringConcat$25(String string2, String string3) {
        return INVALID + string2 + " (must not contain . ; [ or /): " + string3;
    }

    private static /* synthetic */ String stringConcat$26(String string2, String string3) {
        return INVALID + string2 + " (must be a valid Java identifier): " + string3;
    }

    static void checkMethodIdentifier(int version, String name2, String message2) {
        if (name2 == null || name2.length() == 0) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$27(message2));
        }
        if ((version & 0xFFFF) >= 49) {
            int i2 = 0;
            while (i2 < name2.length()) {
                if (".;[/<>".indexOf(name2.codePointAt(i2)) != -1) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$28(message2, name2));
                }
                i2 = name2.offsetByCodePoints(i2, 1);
            }
            return;
        }
        int i3 = 0;
        while (i3 < name2.length()) {
            if (i3 == 0 ? !Character.isJavaIdentifierStart(name2.codePointAt(i3)) : !Character.isJavaIdentifierPart(name2.codePointAt(i3))) {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$29(message2, name2));
            }
            i3 = name2.offsetByCodePoints(i3, 1);
        }
    }

    private static /* synthetic */ String stringConcat$27(String string2) {
        return INVALID + string2 + MUST_NOT_BE_NULL_OR_EMPTY;
    }

    private static /* synthetic */ String stringConcat$28(String string2, String string3) {
        return INVALID + string2 + " (must be a valid unqualified name): " + string3;
    }

    private static /* synthetic */ String stringConcat$29(String string2, String string3) {
        return INVALID + string2 + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string3;
    }

    static void checkInternalName(int version, String name2, String message2) {
        if (name2 == null || name2.length() == 0) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$30(message2));
        }
        if (name2.charAt(0) == '[') {
            CheckMethodAdapter.checkDescriptor(version, name2, false);
        } else {
            CheckMethodAdapter.checkInternalClassName(version, name2, message2);
        }
    }

    private static /* synthetic */ String stringConcat$30(String string2) {
        return INVALID + string2 + MUST_NOT_BE_NULL_OR_EMPTY;
    }

    private static void checkInternalClassName(int version, String name2, String message2) {
        try {
            int slashIndex;
            int startIndex = 0;
            while ((slashIndex = name2.indexOf(47, startIndex + 1)) != -1) {
                CheckMethodAdapter.checkIdentifier(version, name2, startIndex, slashIndex, null);
                startIndex = slashIndex + 1;
            }
            CheckMethodAdapter.checkIdentifier(version, name2, startIndex, name2.length(), null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$31(message2, name2), e);
        }
    }

    private static /* synthetic */ String stringConcat$31(String string2, String string3) {
        return INVALID + string2 + " (must be an internal class name): " + string3;
    }

    static void checkDescriptor(int version, String descriptor, boolean canBeVoid) {
        int endPos = CheckMethodAdapter.checkDescriptor(version, descriptor, 0, canBeVoid);
        if (endPos != descriptor.length()) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$32(descriptor));
        }
    }

    private static /* synthetic */ String stringConcat$32(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private static int checkDescriptor(int version, String descriptor, int startPos, boolean canBeVoid) {
        if (descriptor == null || startPos >= descriptor.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (descriptor.charAt(startPos)) {
            case 'V': {
                if (canBeVoid) {
                    return startPos + 1;
                }
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$33(descriptor));
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return startPos + 1;
            }
            case '[': {
                int pos2;
                for (pos2 = startPos + 1; pos2 < descriptor.length() && descriptor.charAt(pos2) == '['; ++pos2) {
                }
                if (pos2 < descriptor.length()) {
                    return CheckMethodAdapter.checkDescriptor(version, descriptor, pos2, false);
                }
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$34(descriptor));
            }
            case 'L': {
                int endPos = descriptor.indexOf(59, startPos);
                if (startPos == -1 || endPos - startPos < 2) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$35(descriptor));
                }
                try {
                    CheckMethodAdapter.checkInternalClassName(version, descriptor.substring(startPos + 1, endPos), null);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$36(descriptor), e);
                }
                return endPos + 1;
            }
        }
        throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$37(descriptor));
    }

    private static /* synthetic */ String stringConcat$33(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private static /* synthetic */ String stringConcat$34(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private static /* synthetic */ String stringConcat$35(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private static /* synthetic */ String stringConcat$36(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private static /* synthetic */ String stringConcat$37(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    static void checkMethodDescriptor(int version, String descriptor) {
        if (descriptor == null || descriptor.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (descriptor.charAt(0) != '(' || descriptor.length() < 3) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$38(descriptor));
        }
        int pos2 = 1;
        if (descriptor.charAt(pos2) != ')') {
            do {
                if (descriptor.charAt(pos2) != 'V') continue;
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$39(descriptor));
            } while ((pos2 = CheckMethodAdapter.checkDescriptor(version, descriptor, pos2, false)) < descriptor.length() && descriptor.charAt(pos2) != ')');
        }
        if ((pos2 = CheckMethodAdapter.checkDescriptor(version, descriptor, pos2 + 1, true)) != descriptor.length()) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$40(descriptor));
        }
    }

    private static /* synthetic */ String stringConcat$38(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private static /* synthetic */ String stringConcat$39(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private static /* synthetic */ String stringConcat$40(String string2) {
        return INVALID_DESCRIPTOR + string2;
    }

    private void checkLabel(Label label2, boolean checkVisited, String message2) {
        if (label2 == null) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$41(message2));
        }
        if (checkVisited && this.labelInsnIndices.get(label2) == null) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$42(message2));
        }
        this.referencedLabels.add(label2);
    }

    private static /* synthetic */ String stringConcat$41(String string2) {
        return INVALID + string2 + " (must not be null)";
    }

    private static /* synthetic */ String stringConcat$42(String string2) {
        return INVALID + string2 + " (must be visited first)";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        VISIT_INSN,
        VISIT_INT_INSN,
        VISIT_VAR_INSN,
        VISIT_TYPE_INSN,
        VISIT_FIELD_INSN,
        VISIT_METHOD_INSN,
        VISIT_JUMP_INSN;

    }

    static class MethodWriterWrapper
    extends MethodVisitor {
        private final int version;
        private final ClassWriter owner;

        MethodWriterWrapper(int api, int version, ClassWriter owner2, MethodVisitor methodWriter) {
            super(api, methodWriter);
            this.version = version;
            this.owner = owner2;
        }

        boolean computesMaxs() {
            return this.owner.hasFlags(1) || this.owner.hasFlags(2);
        }

        boolean computesFrames() {
            return this.owner.hasFlags(2);
        }

        boolean requiresFrames() {
            return (this.version & 0xFFFF) >= 51;
        }
    }
}

