/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.util.Collections;
import java.util.List;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.tree.AbstractInsnNode;
import org.jruby.org.objectweb.asm.tree.FrameNode;
import org.jruby.org.objectweb.asm.tree.InsnList;
import org.jruby.org.objectweb.asm.tree.InsnNode;
import org.jruby.org.objectweb.asm.tree.JumpInsnNode;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jruby.org.objectweb.asm.tree.TypeInsnNode;
import org.jruby.org.objectweb.asm.tree.analysis.Analyzer;
import org.jruby.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jruby.org.objectweb.asm.tree.analysis.Frame;
import org.jruby.org.objectweb.asm.tree.analysis.Interpreter;
import org.jruby.org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckFrameAnalyzer<V extends Value>
extends Analyzer<V> {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int currentLocals;

    CheckFrameAnalyzer(Interpreter<V> interpreter) {
        super(interpreter);
        this.interpreter = interpreter;
    }

    protected void init(String owner2, MethodNode method2) throws AnalyzerException {
        this.insnList = method2.instructions;
        this.currentLocals = Type.getArgumentsAndReturnSizes(method2.desc) >> 2;
        if ((method2.access & 8) != 0) {
            --this.currentLocals;
        }
        Frame[] frames = this.getFrames();
        Frame currentFrame = this.newFrame(frames[0]);
        this.expandFrames(owner2, method2, currentFrame);
        for (int insnIndex = 0; insnIndex < this.insnList.size(); ++insnIndex) {
            Frame oldFrame = frames[insnIndex];
            AbstractInsnNode insnNode = null;
            try {
                insnNode = method2.instructions.get(insnIndex);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.checkFrame(insnIndex + 1, oldFrame, false);
                } else {
                    LabelNode label2;
                    int i2;
                    currentFrame.init(oldFrame).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        if (insnOpcode == 168) {
                            throw new AnalyzerException(insnNode, "JSR instructions are unsupported");
                        }
                        JumpInsnNode jumpInsn = (JumpInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(jumpInsn.label);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        if (insnOpcode == 167) {
                            this.endControlFlow(insnIndex);
                        } else {
                            this.checkFrame(insnIndex + 1, currentFrame, false);
                        }
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(lookupSwitchInsn.dflt);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        for (i2 = 0; i2 < lookupSwitchInsn.labels.size(); ++i2) {
                            label2 = lookupSwitchInsn.labels.get(i2);
                            targetInsnIndex = this.insnList.indexOf(label2);
                            currentFrame.initJumpTarget(insnOpcode, label2);
                            this.checkFrame(targetInsnIndex, currentFrame, true);
                        }
                        this.endControlFlow(insnIndex);
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(tableSwitchInsn.dflt);
                        currentFrame.initJumpTarget(insnOpcode, tableSwitchInsn.dflt);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        for (i2 = 0; i2 < tableSwitchInsn.labels.size(); ++i2) {
                            label2 = tableSwitchInsn.labels.get(i2);
                            currentFrame.initJumpTarget(insnOpcode, label2);
                            targetInsnIndex = this.insnList.indexOf(label2);
                            this.checkFrame(targetInsnIndex, currentFrame, true);
                        }
                        this.endControlFlow(insnIndex);
                    } else {
                        if (insnOpcode == 169) {
                            throw new AnalyzerException(insnNode, "RET instructions are unsupported");
                        }
                        if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                            this.checkFrame(insnIndex + 1, currentFrame, false);
                        } else {
                            this.endControlFlow(insnIndex);
                        }
                    }
                }
                List insnHandlers = this.getHandlers(insnIndex);
                if (insnHandlers != null) {
                    for (TryCatchBlockNode tryCatchBlock : insnHandlers) {
                        Type catchType = tryCatchBlock.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlock.type);
                        Frame handler = this.newFrame(oldFrame);
                        handler.clearStack();
                        handler.push(this.interpreter.newExceptionValue(tryCatchBlock, handler, catchType));
                        this.checkFrame(this.insnList.indexOf(tryCatchBlock.handler), handler, true);
                    }
                }
                if (this.hasNextJvmInsnOrFrame(insnIndex)) continue;
                break;
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, CheckFrameAnalyzer.stringConcat$0(insnIndex, e.getMessage()), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new AnalyzerException(insnNode, CheckFrameAnalyzer.stringConcat$1(insnIndex, e.getMessage()), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ String stringConcat$0(int n, String string2) {
        return "Error at instruction " + n + ": " + string2;
    }

    private static /* synthetic */ String stringConcat$1(int n, String string2) {
        return "Error at instruction " + n + ": " + string2;
    }

    private void expandFrames(String owner2, MethodNode method2, Frame<V> initialFrame) throws AnalyzerException {
        int lastJvmOrFrameInsnIndex = -1;
        Frame<V> currentFrame = initialFrame;
        int currentInsnIndex = 0;
        for (AbstractInsnNode insnNode : method2.instructions) {
            if (insnNode instanceof FrameNode) {
                try {
                    currentFrame = this.expandFrame(owner2, currentFrame, (FrameNode)insnNode);
                }
                catch (AnalyzerException e) {
                    throw new AnalyzerException(e.node, CheckFrameAnalyzer.stringConcat$2(currentInsnIndex, e.getMessage()), (Throwable)e);
                }
                for (int index2 = lastJvmOrFrameInsnIndex + 1; index2 <= currentInsnIndex; ++index2) {
                    this.getFrames()[index2] = currentFrame;
                }
            }
            if (CheckFrameAnalyzer.isJvmInsnNode(insnNode) || insnNode instanceof FrameNode) {
                lastJvmOrFrameInsnIndex = currentInsnIndex;
            }
            ++currentInsnIndex;
        }
    }

    private static /* synthetic */ String stringConcat$2(int n, String string2) {
        return "Error at instruction " + n + ": " + string2;
    }

    private Frame<V> expandFrame(String owner2, Frame<V> previousFrame, FrameNode frameNode) throws AnalyzerException {
        Frame frame = this.newFrame(previousFrame);
        List<Object> locals = frameNode.local == null ? Collections.emptyList() : frameNode.local;
        int currentLocal = this.currentLocals;
        switch (frameNode.type) {
            case -1: 
            case 0: {
                currentLocal = 0;
            }
            case 1: {
                for (Object type2 : locals) {
                    V value2 = this.newFrameValue(owner2, frameNode, type2);
                    if (currentLocal + value2.getSize() > frame.getLocals()) {
                        throw new AnalyzerException((AbstractInsnNode)frameNode, "Cannot append more locals than maxLocals");
                    }
                    frame.setLocal(currentLocal++, value2);
                    if (value2.getSize() != 2) continue;
                    frame.setLocal(currentLocal++, this.interpreter.newValue(null));
                }
                break;
            }
            case 2: {
                for (Object unusedType : locals) {
                    if (currentLocal <= 0) {
                        throw new AnalyzerException((AbstractInsnNode)frameNode, "Cannot chop more locals than defined");
                    }
                    if (currentLocal > 1 && frame.getLocal(currentLocal - 2).getSize() == 2) {
                        currentLocal -= 2;
                        continue;
                    }
                    --currentLocal;
                }
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new AnalyzerException((AbstractInsnNode)frameNode, CheckFrameAnalyzer.stringConcat$3(frameNode.type));
            }
        }
        this.currentLocals = currentLocal;
        while (currentLocal < frame.getLocals()) {
            frame.setLocal(currentLocal++, this.interpreter.newValue(null));
        }
        List<Object> stack = frameNode.stack == null ? Collections.emptyList() : frameNode.stack;
        frame.clearStack();
        for (Object type3 : stack) {
            frame.push(this.newFrameValue(owner2, frameNode, type3));
        }
        return frame;
    }

    private static /* synthetic */ String stringConcat$3(int n) {
        return "Illegal frame type " + n;
    }

    private V newFrameValue(String owner2, FrameNode frameNode, Object type2) throws AnalyzerException {
        if (type2 == Opcodes.TOP) {
            return (V)this.interpreter.newValue(null);
        }
        if (type2 == Opcodes.INTEGER) {
            return (V)this.interpreter.newValue(Type.INT_TYPE);
        }
        if (type2 == Opcodes.FLOAT) {
            return (V)this.interpreter.newValue(Type.FLOAT_TYPE);
        }
        if (type2 == Opcodes.LONG) {
            return (V)this.interpreter.newValue(Type.LONG_TYPE);
        }
        if (type2 == Opcodes.DOUBLE) {
            return (V)this.interpreter.newValue(Type.DOUBLE_TYPE);
        }
        if (type2 == Opcodes.NULL) {
            return (V)this.interpreter.newOperation((AbstractInsnNode)new InsnNode(1));
        }
        if (type2 == Opcodes.UNINITIALIZED_THIS) {
            return (V)this.interpreter.newValue(Type.getObjectType(owner2));
        }
        if (type2 instanceof String) {
            return (V)this.interpreter.newValue(Type.getObjectType((String)type2));
        }
        if (type2 instanceof LabelNode) {
            AbstractInsnNode referencedNode;
            for (referencedNode = (LabelNode)type2; referencedNode != null && !CheckFrameAnalyzer.isJvmInsnNode(referencedNode); referencedNode = referencedNode.getNext()) {
            }
            if (referencedNode == null || referencedNode.getOpcode() != 187) {
                throw new AnalyzerException((AbstractInsnNode)frameNode, "LabelNode does not designate a NEW instruction");
            }
            return (V)this.interpreter.newValue(Type.getObjectType(((TypeInsnNode)referencedNode).desc));
        }
        throw new AnalyzerException((AbstractInsnNode)frameNode, CheckFrameAnalyzer.stringConcat$4(type2));
    }

    private static /* synthetic */ String stringConcat$4(Object object) {
        return "Illegal stack map frame value " + object;
    }

    private void checkFrame(int insnIndex, Frame<V> frame, boolean requireFrame) throws AnalyzerException {
        Frame oldFrame = this.getFrames()[insnIndex];
        if (oldFrame == null) {
            if (requireFrame) {
                throw new AnalyzerException(null, CheckFrameAnalyzer.stringConcat$5(insnIndex));
            }
            this.getFrames()[insnIndex] = this.newFrame(frame);
        } else {
            String error2 = this.checkMerge(frame, oldFrame);
            if (error2 != null) {
                throw new AnalyzerException(null, CheckFrameAnalyzer.stringConcat$6(insnIndex, error2));
            }
        }
    }

    private static /* synthetic */ String stringConcat$5(int n) {
        return "Expected stack map frame at instruction " + n;
    }

    private static /* synthetic */ String stringConcat$6(int n, String string2) {
        return "Stack map frame incompatible with frame at instruction " + n + " (" + string2 + ")";
    }

    private String checkMerge(Frame<V> srcFrame, Frame<V> dstFrame) {
        int numLocals = srcFrame.getLocals();
        if (numLocals != dstFrame.getLocals()) {
            throw new AssertionError();
        }
        for (int i2 = 0; i2 < numLocals; ++i2) {
            Value v = this.interpreter.merge(srcFrame.getLocal(i2), dstFrame.getLocal(i2));
            if (v.equals(dstFrame.getLocal(i2))) continue;
            return CheckFrameAnalyzer.stringConcat$7(i2, srcFrame.getLocal(i2), dstFrame.getLocal(i2));
        }
        int numStack = srcFrame.getStackSize();
        if (numStack != dstFrame.getStackSize()) {
            return "incompatible stack heights";
        }
        for (int i3 = 0; i3 < numStack; ++i3) {
            Value v = this.interpreter.merge(srcFrame.getStack(i3), dstFrame.getStack(i3));
            if (v.equals(dstFrame.getStack(i3))) continue;
            return CheckFrameAnalyzer.stringConcat$8(i3, srcFrame.getStack(i3), dstFrame.getStack(i3));
        }
        return null;
    }

    private static /* synthetic */ String stringConcat$7(int n, Value value2, Value value3) {
        return "incompatible types at local " + n + ": " + value2 + " and " + value3;
    }

    private static /* synthetic */ String stringConcat$8(int n, Value value2, Value value3) {
        return "incompatible types at stack item " + n + ": " + value2 + " and " + value3;
    }

    private void endControlFlow(int insnIndex) throws AnalyzerException {
        if (this.hasNextJvmInsnOrFrame(insnIndex) && this.getFrames()[insnIndex + 1] == null) {
            throw new AnalyzerException(null, CheckFrameAnalyzer.stringConcat$9(insnIndex + 1));
        }
    }

    private static /* synthetic */ String stringConcat$9(int n) {
        return "Expected stack map frame at instruction " + n;
    }

    private boolean hasNextJvmInsnOrFrame(int insnIndex) {
        for (AbstractInsnNode insn = this.insnList.get(insnIndex).getNext(); insn != null; insn = insn.getNext()) {
            if (!CheckFrameAnalyzer.isJvmInsnNode(insn) && !(insn instanceof FrameNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJvmInsnNode(AbstractInsnNode insnNode) {
        return insnNode.getOpcode() >= 0;
    }
}

