/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.RecordComponentVisitor;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.TypeReference;
import org.jruby.org.objectweb.asm.tree.ClassNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jruby.org.objectweb.asm.tree.analysis.Analyzer;
import org.jruby.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jruby.org.objectweb.asm.tree.analysis.BasicValue;
import org.jruby.org.objectweb.asm.tree.analysis.Frame;
import org.jruby.org.objectweb.asm.tree.analysis.Interpreter;
import org.jruby.org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.jruby.org.objectweb.asm.util.CheckAnnotationAdapter;
import org.jruby.org.objectweb.asm.util.CheckFieldAdapter;
import org.jruby.org.objectweb.asm.util.CheckMethodAdapter;
import org.jruby.org.objectweb.asm.util.CheckModuleAdapter;
import org.jruby.org.objectweb.asm.util.CheckRecordComponentAdapter;
import org.jruby.org.objectweb.asm.util.Textifier;
import org.jruby.org.objectweb.asm.util.TraceMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckClassAdapter
extends ClassVisitor {
    private static final String USAGE = "Verifies the given class.\nUsage: CheckClassAdapter <fully qualified class name or class file name>";
    private static final String ERROR_AT = ": error at index ";
    private boolean checkDataFlow;
    private int version;
    private boolean visitCalled;
    private boolean visitModuleCalled;
    private boolean visitSourceCalled;
    private boolean visitOuterClassCalled;
    private boolean visitNestHostCalled;
    private String nestMemberPackageName;
    private boolean visitEndCalled;
    private Map<Label, Integer> labelInsnIndices = new HashMap<Label, Integer>();

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, true);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean checkDataFlow) {
        this(589824, classVisitor, checkDataFlow);
        if (this.getClass() != CheckClassAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckClassAdapter(int api, ClassVisitor classVisitor, boolean checkDataFlow) {
        super(api, classVisitor);
        this.checkDataFlow = checkDataFlow;
    }

    @Override
    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        if (this.visitCalled) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.visitCalled = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 259633);
        if (name2 == null) {
            throw new IllegalArgumentException("Illegal class name (null)");
        }
        if (!name2.endsWith("package-info") && !name2.endsWith("module-info")) {
            CheckMethodAdapter.checkInternalName(version, name2, "class name");
        }
        if ("java/lang/Object".equals(name2)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else if (name2.endsWith("module-info")) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of a module-info class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(version, superName, "super class name");
        }
        if (signature != null) {
            CheckClassAdapter.checkClassSignature(signature);
        }
        if ((access & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces2 != null) {
            for (int i2 = 0; i2 < interfaces2.length; ++i2) {
                CheckMethodAdapter.checkInternalName(version, interfaces2[i2], CheckClassAdapter.stringConcat$0(i2));
            }
        }
        this.version = version;
        super.visit(version, access, name2, signature, superName, interfaces2);
    }

    private static /* synthetic */ String stringConcat$0(int n) {
        return "interface name at index " + n;
    }

    @Override
    public void visitSource(String file2, String debug) {
        this.checkState();
        if (this.visitSourceCalled) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.visitSourceCalled = true;
        super.visitSource(file2, debug);
    }

    @Override
    public ModuleVisitor visitModule(String name2, int access, String version) {
        this.checkState();
        if (this.visitModuleCalled) {
            throw new IllegalStateException("visitModule can be called only once.");
        }
        this.visitModuleCalled = true;
        CheckClassAdapter.checkFullyQualifiedName(this.version, name2, "module name");
        CheckClassAdapter.checkAccess(access, 36896);
        CheckModuleAdapter checkModuleAdapter = new CheckModuleAdapter(this.api, super.visitModule(name2, access, version), (access & 0x20) != 0);
        checkModuleAdapter.classVersion = this.version;
        return checkModuleAdapter;
    }

    @Override
    public void visitNestHost(String nestHost) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, nestHost, "nestHost");
        if (this.visitNestHostCalled) {
            throw new IllegalStateException("visitNestHost can be called only once.");
        }
        if (this.nestMemberPackageName != null) {
            throw new IllegalStateException("visitNestHost and visitNestMember are mutually exclusive.");
        }
        this.visitNestHostCalled = true;
        super.visitNestHost(nestHost);
    }

    @Override
    public void visitNestMember(String nestMember) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, nestMember, "nestMember");
        if (this.visitNestHostCalled) {
            throw new IllegalStateException("visitMemberOfNest and visitNestHost are mutually exclusive.");
        }
        String packageName = CheckClassAdapter.packageName(nestMember);
        if (this.nestMemberPackageName == null) {
            this.nestMemberPackageName = packageName;
        } else if (!this.nestMemberPackageName.equals(packageName)) {
            throw new IllegalStateException(CheckClassAdapter.stringConcat$1(nestMember, this.nestMemberPackageName));
        }
        super.visitNestMember(nestMember);
    }

    private static /* synthetic */ String stringConcat$1(String string2, String string3) {
        return "nest member " + string2 + " should be in the package " + string3;
    }

    @Override
    public void visitPermittedSubclass(String permittedSubclass) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, permittedSubclass, "permittedSubclass");
        super.visitPermittedSubclass(permittedSubclass);
    }

    @Override
    public void visitOuterClass(String owner2, String name2, String descriptor) {
        this.checkState();
        if (this.visitOuterClassCalled) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.visitOuterClassCalled = true;
        if (owner2 == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (descriptor != null) {
            CheckMethodAdapter.checkMethodDescriptor(this.version, descriptor);
        }
        super.visitOuterClass(owner2, name2, descriptor);
    }

    @Override
    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, name2, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(this.version, outerName, "outer class name");
        }
        if (innerName != null) {
            int startIndex;
            for (startIndex = 0; startIndex < innerName.length() && Character.isDigit(innerName.charAt(startIndex)); ++startIndex) {
            }
            if (startIndex == 0 || startIndex < innerName.length()) {
                CheckMethodAdapter.checkIdentifier(this.version, innerName, startIndex, -1, "inner class name");
            }
        }
        CheckClassAdapter.checkAccess(access, 30239);
        super.visitInnerClass(name2, outerName, innerName, access);
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(String name2, String descriptor, String signature) {
        this.checkState();
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "record component name");
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        if (signature != null) {
            CheckClassAdapter.checkFieldSignature(signature);
        }
        return new CheckRecordComponentAdapter(this.api, super.visitRecordComponent(name2, descriptor, signature));
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 184543);
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "field name");
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        if (signature != null) {
            CheckClassAdapter.checkFieldSignature(signature);
        }
        if (value2 != null) {
            CheckMethodAdapter.checkConstant(value2);
        }
        return new CheckFieldAdapter(this.api, super.visitField(access, name2, descriptor, signature, value2));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        CheckMethodAdapter checkMethodAdapter;
        this.checkState();
        CheckClassAdapter.checkMethodAccess(this.version, access, 171519);
        if (!"<init>".equals(name2) && !"<clinit>".equals(name2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "method name");
        }
        CheckMethodAdapter.checkMethodDescriptor(this.version, descriptor);
        if (signature != null) {
            CheckClassAdapter.checkMethodSignature(signature);
        }
        if (exceptions != null) {
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                CheckMethodAdapter.checkInternalName(this.version, exceptions[i2], CheckClassAdapter.stringConcat$2(i2));
            }
        }
        MethodVisitor methodVisitor = super.visitMethod(access, name2, descriptor, signature, exceptions);
        if (this.checkDataFlow) {
            if (this.cv instanceof ClassWriter) {
                methodVisitor = new CheckMethodAdapter.MethodWriterWrapper(this.api, this.version, (ClassWriter)this.cv, methodVisitor);
            }
            checkMethodAdapter = new CheckMethodAdapter(this.api, access, name2, descriptor, methodVisitor, this.labelInsnIndices);
        } else {
            checkMethodAdapter = new CheckMethodAdapter(this.api, methodVisitor, this.labelInsnIndices);
        }
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    private static /* synthetic */ String stringConcat$2(int n) {
        return "exception name at index " + n;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.checkState();
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(descriptor, visible));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.checkState();
        int sort2 = new TypeReference(typeRef).getSort();
        if (sort2 != 0 && sort2 != 17 && sort2 != 16) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$3(Integer.toHexString(sort2)));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
    }

    private static /* synthetic */ String stringConcat$3(String string2) {
        return "Invalid type reference sort 0x" + string2;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.visitCalled) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$4(access));
        }
        int publicProtectedPrivate = 7;
        if (Integer.bitCount(access & publicProtectedPrivate) > 1) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$5(access));
        }
        if (Integer.bitCount(access & 0x410) > 1) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$6(access));
        }
    }

    private static /* synthetic */ String stringConcat$4(int n) {
        return "Invalid access flags: " + n;
    }

    private static /* synthetic */ String stringConcat$5(int n) {
        return "public, protected and private are mutually exclusive: " + n;
    }

    private static /* synthetic */ String stringConcat$6(int n) {
        return "final and abstract are mutually exclusive: " + n;
    }

    private static void checkMethodAccess(int version, int access, int possibleAccess) {
        CheckClassAdapter.checkAccess(access, possibleAccess);
        if ((version & 0xFFFF) < 61 && Integer.bitCount(access & 0xC00) > 1) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$7(access));
        }
    }

    private static /* synthetic */ String stringConcat$7(int n) {
        return "strictfp and abstract are mutually exclusive: " + n;
    }

    static void checkFullyQualifiedName(int version, String name2, String source2) {
        try {
            int dotIndex;
            int startIndex = 0;
            while ((dotIndex = name2.indexOf(46, startIndex + 1)) != -1) {
                CheckMethodAdapter.checkIdentifier(version, name2, startIndex, dotIndex, null);
                startIndex = dotIndex + 1;
            }
            CheckMethodAdapter.checkIdentifier(version, name2, startIndex, name2.length(), null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$8(source2, name2), e);
        }
    }

    private static /* synthetic */ String stringConcat$8(String string2, String string3) {
        return "Invalid " + string2 + " (must be a fully qualified name): " + string3;
    }

    public static void checkClassSignature(String signature) {
        int pos2 = 0;
        if (CheckClassAdapter.getChar(signature, 0) == '<') {
            pos2 = CheckClassAdapter.checkTypeParameters(signature, pos2);
        }
        pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == 'L') {
            pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
        }
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$9(signature, pos2));
        }
    }

    private static /* synthetic */ String stringConcat$9(String string2, int n) {
        return string2 + ERROR_AT + n;
    }

    public static void checkMethodSignature(String signature) {
        int pos2 = 0;
        if (CheckClassAdapter.getChar(signature, 0) == '<') {
            pos2 = CheckClassAdapter.checkTypeParameters(signature, pos2);
        }
        pos2 = CheckClassAdapter.checkChar('(', signature, pos2);
        while ("ZCBSIFJDL[T".indexOf(CheckClassAdapter.getChar(signature, pos2)) != -1) {
            pos2 = CheckClassAdapter.checkJavaTypeSignature(signature, pos2);
        }
        pos2 = CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkChar(')', signature, pos2)) == 'V' ? ++pos2 : CheckClassAdapter.checkJavaTypeSignature(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == '^') {
            if (CheckClassAdapter.getChar(signature, ++pos2) == 'L') {
                pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
                continue;
            }
            pos2 = CheckClassAdapter.checkTypeVariableSignature(signature, pos2);
        }
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$10(signature, pos2));
        }
    }

    private static /* synthetic */ String stringConcat$10(String string2, int n) {
        return string2 + ERROR_AT + n;
    }

    public static void checkFieldSignature(String signature) {
        int pos2 = CheckClassAdapter.checkReferenceTypeSignature(signature, 0);
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$11(signature, pos2));
        }
    }

    private static /* synthetic */ String stringConcat$11(String string2, int n) {
        return string2 + ERROR_AT + n;
    }

    private static int checkTypeParameters(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('<', signature, pos2);
        pos2 = CheckClassAdapter.checkTypeParameter(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) != '>') {
            pos2 = CheckClassAdapter.checkTypeParameter(signature, pos2);
        }
        return pos2 + 1;
    }

    private static int checkTypeParameter(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2);
        if ("L[T".indexOf(CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkChar(':', signature, pos2))) != -1) {
            pos2 = CheckClassAdapter.checkReferenceTypeSignature(signature, pos2);
        }
        while (CheckClassAdapter.getChar(signature, pos2) == ':') {
            pos2 = CheckClassAdapter.checkReferenceTypeSignature(signature, pos2 + 1);
        }
        return pos2;
    }

    private static int checkReferenceTypeSignature(String signature, int pos2) {
        switch (CheckClassAdapter.getChar(signature, pos2)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(signature, pos2);
            }
            case '[': {
                return CheckClassAdapter.checkJavaTypeSignature(signature, pos2 + 1);
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(signature, pos2);
    }

    private static int checkClassTypeSignature(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('L', signature, pos2);
        pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == '/') {
            pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2 + 1);
        }
        if (CheckClassAdapter.getChar(signature, pos2) == '<') {
            pos2 = CheckClassAdapter.checkTypeArguments(signature, pos2);
        }
        while (CheckClassAdapter.getChar(signature, pos2) == '.') {
            if (CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2 + 1)) != '<') continue;
            pos2 = CheckClassAdapter.checkTypeArguments(signature, pos2);
        }
        return CheckClassAdapter.checkChar(';', signature, pos2);
    }

    private static int checkTypeArguments(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('<', signature, pos2);
        pos2 = CheckClassAdapter.checkTypeArgument(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) != '>') {
            pos2 = CheckClassAdapter.checkTypeArgument(signature, pos2);
        }
        return pos2 + 1;
    }

    private static int checkTypeArgument(String signature, int startPos) {
        int pos2 = startPos;
        char c = CheckClassAdapter.getChar(signature, pos2);
        if (c == '*') {
            return pos2 + 1;
        }
        if (c == '+' || c == '-') {
            ++pos2;
        }
        return CheckClassAdapter.checkReferenceTypeSignature(signature, pos2);
    }

    private static int checkTypeVariableSignature(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('T', signature, pos2);
        pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2);
        return CheckClassAdapter.checkChar(';', signature, pos2);
    }

    private static int checkJavaTypeSignature(String signature, int startPos) {
        int pos2 = startPos;
        switch (CheckClassAdapter.getChar(signature, pos2)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return pos2 + 1;
            }
        }
        return CheckClassAdapter.checkReferenceTypeSignature(signature, pos2);
    }

    private static int checkSignatureIdentifier(String signature, int startPos) {
        int pos2 = startPos;
        while (pos2 < signature.length() && ".;[/<>:".indexOf(signature.codePointAt(pos2)) == -1) {
            pos2 = signature.offsetByCodePoints(pos2, 1);
        }
        if (pos2 == startPos) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$12(signature, startPos));
        }
        return pos2;
    }

    private static /* synthetic */ String stringConcat$12(String string2, int n) {
        return string2 + ": identifier expected at index " + n;
    }

    private static int checkChar(char c, String signature, int pos2) {
        if (CheckClassAdapter.getChar(signature, pos2) == c) {
            return pos2 + 1;
        }
        throw new IllegalArgumentException(CheckClassAdapter.stringConcat$13(signature, c, pos2));
    }

    private static /* synthetic */ String stringConcat$13(String string2, char c, int n) {
        return string2 + ": '" + c + "' expected at index " + n;
    }

    private static char getChar(String string2, int pos2) {
        return pos2 < string2.length() ? string2.charAt(pos2) : (char)'\u0000';
    }

    static void checkTypeRef(int typeRef) {
        int mask = 0;
        switch (typeRef >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                mask = -65536;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                mask = -16777216;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                mask = -256;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                mask = -16776961;
                break;
            }
        }
        if (mask == 0 || (typeRef & ~mask) != 0) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$14(Integer.toHexString(typeRef)));
        }
    }

    private static /* synthetic */ String stringConcat$14(String string2) {
        return "Invalid type reference 0x" + string2;
    }

    private static String packageName(String name2) {
        int index2 = name2.lastIndexOf(47);
        if (index2 == -1) {
            return "";
        }
        return name2.substring(0, index2);
    }

    public static void main(String[] args2) throws IOException {
        CheckClassAdapter.main(args2, new PrintWriter(System.err, true));
    }

    static void main(String[] args2, PrintWriter logger) throws IOException {
        ClassReader classReader;
        block6: {
            block5: {
                if (args2.length != 1) {
                    logger.println(USAGE);
                    return;
                }
                if (!args2[0].endsWith(".class")) break block5;
                FileInputStream inputStream = new FileInputStream(args2[0]);
                try {
                    classReader = new ClassReader(inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                ((InputStream)inputStream).close();
                break block6;
            }
            classReader = new ClassReader(args2[0]);
        }
        CheckClassAdapter.verify(classReader, false, logger);
    }

    public static void verify(ClassReader classReader, boolean printResults, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, printResults, printWriter);
    }

    public static void verify(ClassReader classReader, ClassLoader loader, boolean printResults, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(589824, classNode, false){}, 2);
        Type syperType = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List<MethodNode> methods2 = classNode.methods;
        ArrayList<Type> interfaces2 = new ArrayList<Type>();
        for (String interfaceName : classNode.interfaces) {
            interfaces2.add(Type.getObjectType(interfaceName));
        }
        for (MethodNode method2 : methods2) {
            SimpleVerifier verifier = new SimpleVerifier(Type.getObjectType(classNode.name), syperType, interfaces2, (classNode.access & 0x200) != 0);
            Analyzer analyzer = new Analyzer((Interpreter)verifier);
            if (loader != null) {
                verifier.setClassLoader(loader);
            }
            try {
                analyzer.analyze(classNode.name, method2);
            }
            catch (AnalyzerException e) {
                e.printStackTrace(printWriter);
            }
            if (!printResults) continue;
            CheckClassAdapter.printAnalyzerResult(method2, (Analyzer<BasicValue>)analyzer, printWriter);
        }
        printWriter.flush();
    }

    static void printAnalyzerResult(MethodNode method2, Analyzer<BasicValue> analyzer, PrintWriter printWriter) {
        Textifier textifier = new Textifier();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(textifier);
        printWriter.println(CheckClassAdapter.stringConcat$15(method2.name, method2.desc));
        for (int i2 = 0; i2 < method2.instructions.size(); ++i2) {
            method2.instructions.get(i2).accept(traceMethodVisitor);
            StringBuilder stringBuilder = new StringBuilder();
            Frame frame = analyzer.getFrames()[i2];
            if (frame == null) {
                stringBuilder.append('?');
            } else {
                int j;
                for (j = 0; j < frame.getLocals(); ++j) {
                    stringBuilder.append(CheckClassAdapter.getUnqualifiedName(((BasicValue)frame.getLocal(j)).toString())).append(' ');
                }
                stringBuilder.append(" : ");
                for (j = 0; j < frame.getStackSize(); ++j) {
                    stringBuilder.append(CheckClassAdapter.getUnqualifiedName(((BasicValue)frame.getStack(j)).toString())).append(' ');
                }
            }
            while (stringBuilder.length() < method2.maxStack + method2.maxLocals + 1) {
                stringBuilder.append(' ');
            }
            printWriter.print(Integer.toString(i2 + 100000).substring(1));
            printWriter.print(CheckClassAdapter.stringConcat$16(stringBuilder, textifier.text.get(textifier.text.size() - 1)));
        }
        for (TryCatchBlockNode tryCatchBlock : method2.tryCatchBlocks) {
            tryCatchBlock.accept(traceMethodVisitor);
            printWriter.print(CheckClassAdapter.stringConcat$17(textifier.text.get(textifier.text.size() - 1)));
        }
        printWriter.println();
    }

    private static /* synthetic */ String stringConcat$15(String string2, String string3) {
        return string2 + string3;
    }

    private static /* synthetic */ String stringConcat$16(StringBuilder stringBuilder, Object object) {
        return " " + stringBuilder + " : " + object;
    }

    private static /* synthetic */ String stringConcat$17(Object object) {
        return " " + object;
    }

    private static String getUnqualifiedName(String name2) {
        int lastBracketIndex;
        int lastSlashIndex = name2.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            return name2;
        }
        int endIndex = name2.length();
        if (name2.charAt(endIndex - 1) == ';') {
            --endIndex;
        }
        if ((lastBracketIndex = name2.lastIndexOf(91)) == -1) {
            return name2.substring(lastSlashIndex + 1, endIndex);
        }
        return CheckClassAdapter.stringConcat$18(name2.substring(0, lastBracketIndex + 1), name2.substring(lastSlashIndex + 1, endIndex));
    }

    private static /* synthetic */ String stringConcat$18(String string2, String string3) {
        return string2 + string3;
    }
}

