/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.jruby.CoreExt;
import org.jruby.ext.jruby.JRubyExecutionContextLocal;
import org.jruby.ext.jruby.JRubyFiberLocal;
import org.jruby.ext.jruby.JRubyThreadLocal;
import org.jruby.ext.jruby.JRubyUtilLibrary;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.ParserType;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;

@JRubyModule(name={"JRuby"})
public class JRubyLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        runtime2.getLoadService().loadFromClassLoader(runtime2.getJRubyClassLoader(), "jruby/jruby.rb", false);
        RubyModule JRuby = runtime2.getOrCreateModule("JRuby");
        JRuby.defineAnnotatedMethods(JRubyLibrary.class);
        JRuby.defineAnnotatedMethods(JRubyUtilLibrary.class);
        JRuby.defineClassUnder("ThreadLocal", runtime2.getObject(), JRubyThreadLocal::new).defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        JRuby.defineClassUnder("FiberLocal", runtime2.getObject(), JRubyFiberLocal::new).defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        RubyModule CONFIG = JRuby.defineModuleUnder("CONFIG");
        CONFIG.getSingletonClass().defineAnnotatedMethods(JRubyConfig.class);
    }

    @JRubyMethod(module=true, name={"reference", "ref"})
    public static IRubyObject reference(ThreadContext context, IRubyObject recv, IRubyObject obj) {
        return Java.getInstance(context.runtime, obj, false);
    }

    @JRubyMethod(module=true)
    public static IRubyObject reference0(ThreadContext context, IRubyObject recv, IRubyObject obj) {
        return Java.wrapJavaObject(context.runtime, obj);
    }

    @JRubyMethod(module=true)
    public static IRubyObject runtime(ThreadContext context, IRubyObject recv) {
        return Java.wrapJavaObject(context.runtime, context.runtime);
    }

    @JRubyMethod(module=true, name={"dereference", "deref"})
    public static IRubyObject dereference(ThreadContext context, IRubyObject recv, IRubyObject obj) {
        Object unwrapped = JavaUtil.unwrapIfJavaObject(obj);
        if (unwrapped == obj) {
            throw context.runtime.newTypeError("got " + obj.inspect() + ", expected wrapped Java object");
        }
        if (!(unwrapped instanceof IRubyObject)) {
            throw context.runtime.newTypeError("got " + obj.inspect() + ", expected Java-wrapped Ruby object");
        }
        return (IRubyObject)unwrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static IRubyObject with_current_runtime_as_global(ThreadContext context, IRubyObject recv, Block block) {
        Ruby current2 = context.runtime;
        Ruby global = Ruby.getGlobalRuntime();
        try {
            if (current2 != global) {
                current2.useAsGlobalRuntime();
            }
            IRubyObject iRubyObject = block.yield(context, JRubyLibrary.runtime(context, recv));
            return iRubyObject;
        }
        finally {
            if (Ruby.getGlobalRuntime() != global) {
                global.useAsGlobalRuntime();
            }
        }
    }

    @JRubyMethod(module=true, rest=true)
    public static IRubyObject set_context_class_loader(ThreadContext context, IRubyObject recv, IRubyObject[] args2) {
        ClassLoader loader = args2.length == 0 || args2[0] == context.nil ? context.runtime.getJRubyClassLoader() : (ClassLoader)JavaUtil.unwrapJavaObject(args2[0]);
        Thread.currentThread().setContextClassLoader(loader);
        return Java.wrapJavaObject(context.runtime, loader);
    }

    @JRubyMethod(name={"security_restricted?"}, module=true)
    public static RubyBoolean is_security_restricted(IRubyObject recv) {
        Ruby runtime2 = recv.getRuntime();
        return RubyBoolean.newBoolean(runtime2, Ruby.isSecurityRestricted());
    }

    @JRubyMethod(name={"security_restricted="}, module=true)
    public static IRubyObject set_security_restricted(IRubyObject recv, IRubyObject arg2) {
        Ruby.setSecurityRestricted(arg2.isTrue());
        return JRubyLibrary.is_security_restricted(recv);
    }

    @JRubyMethod(module=true)
    public static IRubyObject identity_hash(ThreadContext context, IRubyObject recv, IRubyObject obj) {
        return context.runtime.newFixnum(System.identityHashCode(obj));
    }

    @JRubyMethod(module=true, name={"parse"}, alias={"ast_for"}, required=1, optional=3, checkArity=false)
    public static IRubyObject parse(ThreadContext context, IRubyObject recv, IRubyObject[] args2, Block block) {
        return Java.wrapJavaObject(context.runtime, JRubyLibrary.parseImpl(context, args2, block).getAST());
    }

    @JRubyMethod(module=true, name={"parse_result"}, required=1, optional=3, checkArity=false)
    public static IRubyObject parse_result(ThreadContext context, IRubyObject recv, IRubyObject[] args2, Block block) {
        return Java.wrapJavaObject(context.runtime, JRubyLibrary.parseImpl(context, args2, block));
    }

    private static ParseResult parseImpl(ThreadContext context, IRubyObject[] args2, Block block) {
        Encoding encoding2;
        String filename2;
        if (block.isGiven()) {
            throw context.runtime.newNotImplementedError("JRuby.parse with block returning AST no longer supported");
        }
        RubyString content = args2[0].convertToString();
        boolean inlineSource = false;
        int lineno2 = 0;
        switch (args2.length) {
            case 1: {
                filename2 = "";
                break;
            }
            case 2: {
                filename2 = args2[1].convertToString().toString();
                break;
            }
            case 3: {
                filename2 = args2[1].convertToString().toString();
                inlineSource = args2[2].isTrue();
                break;
            }
            case 4: {
                filename2 = args2[1].convertToString().toString();
                inlineSource = args2[2].isTrue();
                lineno2 = args2[3].convertToInteger().getIntValue();
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected arguments: " + Arrays.toString(args2)));
            }
        }
        ByteList bytes2 = content.getByteList();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
        Encoding encoding3 = encoding2 = content.getEncoding() == ASCIIEncoding.INSTANCE ? context.runtime.setupSourceEncoding(UTF8Encoding.INSTANCE) : bytes2.getEncoding();
        if (inlineSource) {
            return context.runtime.getParserManager().parseMainFile(filename2, lineno2, stream, encoding2, context.getCurrentScope(), ParserType.INLINE);
        }
        return context.runtime.getParserManager().parseFile(filename2, lineno2, stream, encoding2);
    }

    @JRubyMethod(module=true, name={"compile_ir"}, required=1, optional=3, checkArity=false)
    public static IRubyObject compile_ir(ThreadContext context, IRubyObject recv, IRubyObject[] args2, Block block) {
        return Java.wrapJavaObject(context.runtime, JRubyLibrary.compileIR(context, args2, block));
    }

    private static IRScriptBody compileIR(ThreadContext context, IRubyObject[] args2, Block block) {
        ParseResult result2 = JRubyLibrary.parseImpl(context, args2, block);
        IRManager manager = new IRManager(context.runtime, context.runtime.getInstanceConfig());
        manager.setBuilderFactory(context.runtime.getIRManager().getBuilderFactory());
        IRScriptBody scope = (IRScriptBody)IRBuilder.buildRoot(manager, result2).getScope();
        scope.setScriptDynamicScope(result2.getDynamicScope());
        scope.getStaticScope().setIRScope(scope);
        return scope;
    }

    @JRubyMethod(module=true, name={"compile"}, required=1, optional=3, checkArity=false)
    public static IRubyObject compile(ThreadContext context, IRubyObject recv, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 4);
        Ruby runtime2 = context.runtime;
        RubyString content = args2[0].convertToString();
        args2[0] = content;
        RubyString filename2 = argc > 1 ? args2[1].convertToString() : RubyString.newEmptyString(runtime2);
        IRScriptBody scope = JRubyLibrary.compileIR(context, args2, block);
        JVMVisitor visitor = JVMVisitor.newForJIT(runtime2);
        JVMVisitorMethodContext methodContext = new JVMVisitorMethodContext();
        byte[] bytes2 = visitor.compileToBytecode(scope, methodContext);
        scope.getStaticScope().setModule(runtime2.getTopSelf().getMetaClass());
        RubyClass CompiledScript = (RubyClass)runtime2.getModule("JRuby").getConstantAt("CompiledScript");
        return CompiledScript.newInstance(context, new IRubyObject[]{filename2, runtime2.newSymbol(scope.getId()), content, Java.getInstance(runtime2, bytes2)}, Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject load_string_ext(ThreadContext context, IRubyObject recv) {
        CoreExt.loadStringExtensions(context.runtime);
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject subclasses(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        return JRubyLibrary.subclasses(context, recv, arg2 instanceof RubyClass ? (RubyClass)arg2 : arg2.getMetaClass(), false);
    }

    @JRubyMethod(module=true)
    public static IRubyObject subclasses(ThreadContext context, IRubyObject recv, IRubyObject arg2, IRubyObject opts) {
        IRubyObject all;
        boolean recurseAll = false;
        if ((opts = ArgsUtil.getOptionsArg(context.runtime, opts)) != context.nil && (all = ((RubyHash)opts).fastARef(context.runtime.newSymbol("all"))) != null) {
            recurseAll = all.isTrue();
        }
        return JRubyLibrary.subclasses(context, recv, arg2 instanceof RubyClass ? (RubyClass)arg2 : arg2.getMetaClass(), recurseAll);
    }

    private static RubyArray subclasses(ThreadContext context, IRubyObject recv, final RubyClass klass, final boolean recurseAll) {
        final RubyArray subclasses2 = RubyArray.newArray(context.runtime);
        RubyClass singletonClass = klass.getSingletonClass();
        RubyObjectSpace.each_objectInternal(context, recv, new IRubyObject[]{singletonClass}, new Block(new JavaInternalBlockBody(context.runtime, Signature.ONE_ARGUMENT){

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                return this.doYield(context, null, args2[0]);
            }

            @Override
            protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
                if (klass != value2) {
                    if (recurseAll) {
                        return subclasses2.append(value2);
                    }
                    if (((RubyClass)value2).superclass(context) == klass) {
                        return subclasses2.append(value2);
                    }
                }
                return context.nil;
            }
        }));
        return subclasses2;
    }

    public static class JRubyConfig {
        @JRubyMethod(name={"rubygems_disabled?"})
        public static IRubyObject rubygems_disabled_p(ThreadContext context, IRubyObject self2) {
            return RubyBoolean.newBoolean(context, context.runtime.getInstanceConfig().isDisableGems());
        }

        @JRubyMethod(name={"did_you_mean_disabled?"})
        public static IRubyObject did_you_mean_disabled_p(ThreadContext context, IRubyObject self2) {
            return RubyBoolean.newBoolean(context, context.runtime.getInstanceConfig().isDisableDidYouMean());
        }
    }
}

