/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.ThreadFiber;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FiberQueue {
    protected BlockingQueue<ThreadFiber.FiberRequest> queue;
    protected final Ruby runtime;
    private static final RubyThread.Task<FiberQueue, ThreadFiber.FiberRequest> TAKE_TASK = new RubyThread.Task<FiberQueue, ThreadFiber.FiberRequest>(){

        @Override
        public ThreadFiber.FiberRequest run(ThreadContext context, FiberQueue queue) throws InterruptedException {
            return queue.getQueueSafe().take();
        }

        @Override
        public void wakeup(RubyThread thread2, FiberQueue data) {
            thread2.getNativeThread().interrupt();
        }
    };

    public FiberQueue(Ruby runtime2) {
        this.runtime = runtime2;
        this.queue = new ArrayBlockingQueue<ThreadFiber.FiberRequest>(1, false);
    }

    public IRubyObject shutdown(ThreadContext context) {
        this.queue = null;
        return context.nil;
    }

    public synchronized void shutdown() {
        this.queue = null;
    }

    public boolean isShutdown() {
        return this.queue == null;
    }

    public BlockingQueue<ThreadFiber.FiberRequest> getQueueSafe() {
        BlockingQueue<ThreadFiber.FiberRequest> queue = this.queue;
        this.checkShutdown();
        return queue;
    }

    public synchronized void checkShutdown() {
        if (this.queue == null) {
            throw RaiseException.from(this.runtime, this.runtime.getThreadError(), "queue shut down");
        }
    }

    public ThreadFiber.FiberRequest pop(ThreadContext context) {
        try {
            return context.getThread().executeTaskBlocking(context, this, TAKE_TASK);
        }
        catch (InterruptedException ie) {
            throw context.runtime.newThreadError("interrupted in FiberQueue.pop");
        }
    }

    public void push(ThreadContext context, ThreadFiber.FiberRequest arg2) {
        this.checkShutdown();
        try {
            this.queue.put(arg2);
        }
        catch (InterruptedException ie) {
            throw context.runtime.newThreadError("interrupted in FiberQueue.push");
        }
    }
}

