/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.bigdecimal;

import java.math.BigInteger;

class Multiplication {
    static final BigInteger FIVE = BigInteger.valueOf(5L);
    static final BigInteger[] bigTenPows = new BigInteger[32];

    private Multiplication() {
    }

    static BigInteger powerOf10(long exp2) {
        BigInteger res;
        int intExp = (int)exp2;
        if (exp2 < (long)bigTenPows.length) {
            return bigTenPows[intExp];
        }
        if (exp2 <= 50L) {
            return BigInteger.TEN.pow(intExp);
        }
        try {
            if (exp2 <= Integer.MAX_VALUE) {
                res = FIVE.pow(intExp).shiftLeft(intExp);
            } else {
                long longExp;
                BigInteger powerOfFive;
                res = powerOfFive = FIVE.pow(Integer.MAX_VALUE);
                intExp = (int)(exp2 % Integer.MAX_VALUE);
                for (longExp = exp2 - Integer.MAX_VALUE; longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
                    res = res.multiply(powerOfFive);
                }
                res = res.multiply(FIVE.pow(intExp));
                res = res.shiftLeft(Integer.MAX_VALUE);
                for (longExp = exp2 - Integer.MAX_VALUE; longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
                    res = res.shiftLeft(Integer.MAX_VALUE);
                }
                res = res.shiftLeft(intExp);
            }
        }
        catch (OutOfMemoryError error) {
            throw new ArithmeticException(error.getMessage());
        }
        return res;
    }

    static {
        Multiplication.bigTenPows[0] = BigInteger.ONE;
        Multiplication.bigTenPows[1] = BigInteger.TEN;
        Multiplication.bigTenPows[2] = BigInteger.valueOf(100L);
        Multiplication.bigTenPows[3] = BigInteger.valueOf(1000L);
        Multiplication.bigTenPows[4] = BigInteger.valueOf(10000L);
        Multiplication.bigTenPows[5] = BigInteger.valueOf(100000L);
        Multiplication.bigTenPows[6] = BigInteger.valueOf(1000000L);
        Multiplication.bigTenPows[7] = BigInteger.valueOf(10000000L);
        Multiplication.bigTenPows[8] = BigInteger.valueOf(100000000L);
        Multiplication.bigTenPows[9] = BigInteger.valueOf(1000000000L);
        Multiplication.bigTenPows[10] = BigInteger.valueOf(10000000000L);
        Multiplication.bigTenPows[11] = BigInteger.valueOf(100000000000L);
        Multiplication.bigTenPows[12] = BigInteger.valueOf(1000000000000L);
        Multiplication.bigTenPows[13] = BigInteger.valueOf(10000000000000L);
        Multiplication.bigTenPows[14] = BigInteger.valueOf(100000000000000L);
        Multiplication.bigTenPows[15] = BigInteger.valueOf(1000000000000000L);
        Multiplication.bigTenPows[16] = BigInteger.valueOf(10000000000000000L);
        Multiplication.bigTenPows[17] = BigInteger.valueOf(100000000000000000L);
        Multiplication.bigTenPows[18] = BigInteger.valueOf(1000000000000000000L);
        for (int i2 = 19; i2 < bigTenPows.length; ++i2) {
            Multiplication.bigTenPows[i2] = bigTenPows[i2 - 1].multiply(BigInteger.TEN);
        }
    }
}

