/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.NoFunctionalitySignalFacade;
import org.jruby.util.SignalFacade;
import org.jruby.util.SunSignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNAL_FACADE;
    private static final String SIGNAME_PREFIX = "SIG";
    private static final Map<String, Integer> SIGNAME_MAP;
    private static final Map<Integer, String> SIGNUM_MAP;

    private static final SignalFacade initSignalFacade() {
        try {
            return (SignalFacade)SunSignalFacade.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby runtime2) {
        if (!Platform.IS_WINDOWS) {
            try {
                Class.forName("java.lang.Process");
                Class.forName("java.lang.UNIXProcess");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        RubyModule mSignal = runtime2.defineModule("Signal");
        mSignal.defineAnnotatedMethods(RubySignal.class);
    }

    public static Map<String, Integer> list() {
        return SIGNAME_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv) {
        RubyHash names2;
        Ruby runtime2 = recv.getRuntime();
        IRubyObject iRubyObject = recv;
        synchronized (iRubyObject) {
            names2 = (RubyHash)recv.getInternalVariables().getInternalVariable("signal_list");
            if (names2 == null) {
                names2 = RubyHash.newHash(runtime2);
                for (Map.Entry<String, Integer> sig : RubySignal.list().entrySet()) {
                    names2.op_aset(context, runtime2.newDeduplicatedString(sig.getKey()), runtime2.newFixnum(sig.getValue()));
                }
                names2.op_aset(context, runtime2.newDeduplicatedString("EXIT"), runtime2.newFixnum(0));
                recv.getInternalVariables().setInternalVariable("signal_list", names2);
            } else {
                names2.dup(context);
            }
        }
        return names2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __jtrap_kernel(IRubyObject recv, IRubyObject block, IRubyObject sig) {
        return SIGNAL_FACADE.trap(recv, block, sig);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __jtrap_platform_kernel(IRubyObject recv, IRubyObject sig) {
        return SIGNAL_FACADE.restorePlatformDefault(recv, sig);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __jtrap_osdefault_kernel(IRubyObject recv, IRubyObject sig) {
        return SIGNAL_FACADE.restoreOSDefault(recv, sig);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __jtrap_restore_kernel(IRubyObject recv, IRubyObject sig) {
        return SIGNAL_FACADE.ignore(recv, sig);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject signame(ThreadContext context, IRubyObject recv, IRubyObject rubySig) {
        long sig = rubySig.convertToInteger().getLongValue();
        String signame2 = RubySignal.signo2signm(sig);
        if (signame2 == null) {
            if (sig == 0L) {
                return RubyString.newString(context.runtime, "EXIT");
            }
            throw context.runtime.newArgumentError("invalid signal number: " + rubySig);
        }
        return context.runtime.newString(signame2);
    }

    public static String signo2signm(long no) {
        return SIGNUM_MAP.get((int)no);
    }

    public static long signm2signo(String nm) {
        Integer signo2 = SIGNAME_MAP.get(nm);
        if (signo2 == null) {
            return 0L;
        }
        return signo2.intValue();
    }

    public static String signmWithPrefix(String nm) {
        return nm.startsWith(SIGNAME_PREFIX) ? nm : SIGNAME_PREFIX + nm;
    }

    public static String signmWithoutPrefix(String nm) {
        return nm.startsWith(SIGNAME_PREFIX) ? nm.substring(SIGNAME_PREFIX.length()) : nm;
    }

    private static boolean SIGNAME(String name2) {
        switch (name2) {
            case "EXIT": 
            case "HUP": 
            case "INT": 
            case "QUIT": 
            case "ILL": 
            case "TRAP": 
            case "IOT": 
            case "ABRT": 
            case "EMT": 
            case "FPE": 
            case "KILL": 
            case "BUS": 
            case "SEGV": 
            case "SYS": 
            case "PIPE": 
            case "ALRM": 
            case "TERM": 
            case "URG": 
            case "STOP": 
            case "TSTP": 
            case "CONT": 
            case "CHLD": 
            case "CLD": 
            case "TTIN": 
            case "TTOU": 
            case "IO": 
            case "XCPU": 
            case "XFSZ": 
            case "PROF": 
            case "VTALRM": 
            case "WINCH": 
            case "USR1": 
            case "USR2": 
            case "LOST": 
            case "MSG": 
            case "PWR": 
            case "POLL": 
            case "DANGER": 
            case "MIGRATE": 
            case "PRE": 
            case "GRANT": 
            case "RETRACT": 
            case "SOUND": 
            case "INFO": {
                return true;
            }
        }
        return false;
    }

    static {
        int CHLD;
        Signal[] values2;
        SIGNAL_FACADE = RubySignal.initSignalFacade();
        HashMap<String, Integer> signals = new HashMap<String, Integer>();
        HashMap<Integer, String> signums = new HashMap<Integer, String>();
        for (Signal s2 : values2 = Signal.values()) {
            String desc;
            if (!s2.defined() || !(desc = s2.description()).startsWith(SIGNAME_PREFIX) || !RubySignal.SIGNAME(desc = RubySignal.signmWithoutPrefix(desc))) continue;
            int signo2 = s2.intValue();
            if (s2 == Signal.SIGCHLD || s2 == Signal.SIGCLD || signo2 >= 20000) continue;
            signals.put(desc, signo2);
            signums.put(signo2, desc);
        }
        if (Platform.IS_WINDOWS) {
            signals.put("KILL", 9);
        }
        if ((CHLD = Signal.SIGCLD.defined() ? Signal.SIGCLD.intValue() : (Signal.SIGCHLD.defined() ? Signal.SIGCHLD.intValue() : 0)) != 0) {
            signals.put("CLD", CHLD);
            signals.put("CHLD", CHLD);
            signums.put(CHLD, "CHLD");
        }
        SIGNAME_MAP = Collections.unmodifiableMap(signals);
        SIGNUM_MAP = Collections.unmodifiableMap(signums);
    }
}

