/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRandomBase;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Random;

@JRubyClass(name={"Random"})
public class RubyRandom
extends RubyRandomBase {
    private static final int DEFAULT_SEED_CNT = 4;

    public static BigInteger randomSeedBigInteger(java.util.Random random) {
        byte[] seed2 = new byte[16];
        random.nextBytes(seed2);
        return new BigInteger(seed2).abs();
    }

    public static RubyBignum randomSeed(Ruby runtime2) {
        return RubyBignum.newBignum(runtime2, RubyRandom.randomSeedBigInteger(runtime2.random));
    }

    public static RubyClass createRandomClass(Ruby runtime2) {
        RubyClass baseClass = RubyClass.newClass(runtime2, runtime2.getObject());
        baseClass.setBaseName("Base");
        baseClass.setAllocator(ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        baseClass.defineAnnotatedMethods(RubyRandomBase.class);
        RubyClass randomClass = runtime2.defineClass("Random", baseClass, RubyRandom::new);
        randomClass.defineConstant("Base", baseClass);
        randomClass.defineAnnotatedMethods(RubyRandom.class);
        randomClass.defineConstant("DEFAULT", randomClass);
        randomClass.deprecateConstant(runtime2, "DEFAULT");
        runtime2.setDefaultRandom(RubyRandom.newRandom(runtime2, randomClass, RubyRandom.randomSeed(runtime2)));
        RubyModule formatterModule = randomClass.defineModuleUnder("Formatter");
        baseClass.includeModule(formatterModule);
        formatterModule.extend_object(baseClass);
        formatterModule.defineAnnotatedMethods(RandomFormatter.class);
        return randomClass;
    }

    public static RubyRandom newRandom(Ruby runtime2, RubyClass randomClass, IRubyObject seed2) {
        RubyRandom random = new RubyRandom(runtime2, randomClass, new RandomType(seed2));
        return random;
    }

    public RandomType getRandomType() {
        return this.random;
    }

    RubyRandom(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    RubyRandom(Ruby runtime2, RubyClass rubyClass, RandomType randomType) {
        super(runtime2, rubyClass);
        this.random = randomType;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject seed(ThreadContext context, IRubyObject self2) {
        return RubyRandom.getDefaultRand(context).getSeed();
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject orig) {
        if (!(orig instanceof RubyRandom)) {
            throw this.getRuntime().newTypeError(String.format("wrong argument type %s (expected %s)", orig.getMetaClass().getName(), this.getMetaClass().getName()));
        }
        this.checkFrozen();
        this.random = new RandomType(((RubyRandom)orig).random);
        return this;
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv) {
        RandomType random = RubyRandom.getDefaultRand(context);
        return RubyRandom.randFloat(context, random);
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        IRubyObject v = RubyRandom.randRandom(context, recv, random, arg2);
        RubyRandom.checkRandomNumber(context, v, arg2);
        return v;
    }

    static IRubyObject randKernel(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (arg2 == context.nil) {
            return RubyRandom.randFloat(context, random);
        }
        if (arg2 instanceof RubyRange) {
            IRubyObject v = RubyRandom.randRandom(context, self2, random, arg2);
            return v;
        }
        RubyInteger max2 = arg2.convertToInteger();
        if (max2.isZero()) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject r = RubyRandom.randInt(context, self2, random, max2, false);
        return r == context.nil ? RubyRandom.randFloat(context, random) : r;
    }

    @JRubyMethod(name={"default"}, meta=true)
    public static IRubyObject rbDefault(ThreadContext context, IRubyObject self2) {
        return context.runtime.getDefaultRandom();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv) {
        return RubyRandom.srandCommon(context, recv);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv, IRubyObject seed2) {
        return RubyRandom.srandCommon(context, recv, seed2);
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv) {
        return RubyRandom.srandCommon(context, recv, RubyRandom.randomSeed(context.runtime));
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv, IRubyObject newSeed2) {
        Ruby runtime2 = context.runtime;
        RubyRandom defaultRandom = RubyRandom.getDefaultRandom(runtime2);
        RubyInteger previousSeed = defaultRandom.getRandomType().getSeed();
        defaultRandom = RubyRandom.newRandom(runtime2, runtime2.getRandomClass(), newSeed2);
        context.runtime.setDefaultRandom(defaultRandom);
        return previousSeed;
    }

    @Override
    @Deprecated
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        return this.op_equal(context, obj);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (!this.getType().equals(obj.getType())) {
            return context.fals;
        }
        return RubyBoolean.newBoolean(context, this.random.equals(((RubyRandom)obj).random));
    }

    @JRubyMethod(name={"state"}, visibility=Visibility.PRIVATE)
    public IRubyObject stateObj(ThreadContext context) {
        return this.random.getState();
    }

    @JRubyMethod(name={"left"}, visibility=Visibility.PRIVATE)
    public IRubyObject leftObj(ThreadContext context) {
        return RubyNumeric.int2fix(context.runtime, this.random.getLeft());
    }

    @JRubyMethod(name={"state"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject state(ThreadContext context, IRubyObject recv) {
        return RubyRandom.getDefaultRand(context).getState();
    }

    @JRubyMethod(name={"left"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject left(ThreadContext context, IRubyObject recv) {
        return RubyNumeric.int2fix(context.runtime, RubyRandom.getDefaultRand(context).getLeft());
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyBignum state2 = this.random.getState();
        RubyFixnum left2 = RubyFixnum.newFixnum(context.runtime, (long)this.random.getLeft());
        RubyArray dump2 = RubyArray.newArray(context.runtime, state2, left2, this.random.getSeed());
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        if (load2.size() != 3) {
            throw context.runtime.newArgumentError("wrong dump data");
        }
        if (!(load2.eltInternal(0) instanceof RubyBignum)) {
            throw context.runtime.newTypeError((IRubyObject)load2.eltInternal(0), context.runtime.getBignum());
        }
        RubyBignum state2 = (RubyBignum)load2.eltInternal(0);
        int left2 = RubyNumeric.num2int(load2.eltInternal(1));
        Object seed2 = load2.eltInternal(2);
        this.checkFrozen();
        this.random = new RandomType((IRubyObject)seed2, state2, left2);
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        this.setFrozen(true);
        return this;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject bytes(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        return RubyRandom.bytesCommon(context, RubyRandom.getDefaultRand(context), arg2);
    }

    @JRubyMethod(name={"new_seed"}, meta=true)
    public static IRubyObject newSeed(ThreadContext context, IRubyObject recv) {
        return RubyRandom.randomSeed(context.runtime);
    }

    @JRubyMethod(name={"urandom"}, meta=true)
    public static IRubyObject urandom(ThreadContext context, IRubyObject recv, IRubyObject num) {
        Ruby runtime2 = context.runtime;
        int n = num.convertToInteger().getIntValue();
        if (n < 0) {
            throw runtime2.newArgumentError("negative string size (or size too big)");
        }
        if (n == 0) {
            return runtime2.newString();
        }
        byte[] seed2 = new byte[n];
        runtime2.random.nextBytes(seed2);
        return RubyString.newString(runtime2, seed2);
    }

    @Deprecated
    public static IRubyObject randCommon19(ThreadContext context, IRubyObject recv, IRubyObject[] args2) {
        return RubyRandom.randKernel(context, args2);
    }

    @Deprecated
    static IRubyObject randKernel(ThreadContext context, IRubyObject[] args2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (args2.length == 0) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject arg2 = args2[0];
        return RubyRandom.randKernel(context, context.runtime.getRandomClass(), arg2);
    }

    @Deprecated
    public static IRubyObject rand(ThreadContext context, IRubyObject recv, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyRandom.randDefault(context, recv);
            }
            case 1: {
                return RubyRandom.randDefault(context, recv, args2[0]);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0, 1);
    }

    @Deprecated
    public IRubyObject randObj(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.rand(context) : this.rand(context, args2[0]);
    }

    public static class RandomFormatter {
        @JRubyMethod(name={"rand", "random_number"})
        public static IRubyObject randomNumber(ThreadContext context, IRubyObject self2) {
            RandomType rnd = RandomFormatter.tryGetRnd(context, self2);
            IRubyObject v = RubyRandomBase.randRandom(context, self2, rnd);
            return v;
        }

        @JRubyMethod(name={"rand", "random_number"})
        public static IRubyObject randomNumber(ThreadContext context, IRubyObject self2, IRubyObject arg0) {
            RandomType rnd = RubyRandomBase.tryGetRandomType(context, self2);
            IRubyObject v = RubyRandomBase.randRandom(context, self2, rnd, arg0);
            if (v.isNil()) {
                v = RubyRandomBase.randRandom(context, self2, rnd);
            } else if (v == context.fals) {
                RubyRandomBase.invalidArgument(context, arg0);
            }
            return v;
        }

        static RandomType tryGetRnd(ThreadContext context, IRubyObject obj) {
            if (obj == context.runtime.getRandomClass()) {
                return RubyRandomBase.getDefaultRand(context);
            }
            if (!(obj instanceof RubyRandom)) {
                return null;
            }
            return ((RubyRandom)obj).getRandomType();
        }
    }

    static final class RandomType {
        final RubyInteger seed;
        final Random impl;

        RandomType(IRubyObject seed2) {
            this.seed = seed2.convertToInteger();
            if (this.seed instanceof RubyFixnum) {
                this.impl = RandomType.randomFromFixnum((RubyFixnum)this.seed);
            } else if (this.seed instanceof RubyBignum) {
                this.impl = RandomType.randomFromBignum((RubyBignum)this.seed);
            } else {
                throw seed2.getRuntime().newTypeError(String.format("failed to convert %s into Integer", seed2.getMetaClass().getName()));
            }
        }

        public static Random randomFromFixnum(RubyFixnum seed2) {
            return RandomType.randomFromLong(RubyNumeric.num2long(seed2));
        }

        public static Random randomFromLong(long seed2) {
            long v = Math.abs(seed2);
            if (v == (v & 0xFFFFFFFFL)) {
                return new Random((int)v);
            }
            int[] ints = new int[]{(int)v, (int)(v >> 32)};
            return new Random(ints);
        }

        public static Random randomFromBignum(RubyBignum seed2) {
            BigInteger big = seed2.getBigIntegerValue();
            return RandomType.randomFromBigInteger(big);
        }

        public static Random randomFromBigInteger(BigInteger big) {
            if (big.signum() < 0) {
                big = big.abs();
            }
            byte[] buf = big.toByteArray();
            int buflen = buf.length;
            if (buf[0] == 0) {
                --buflen;
            }
            int len = Math.min((buflen + 3) / 4, 624);
            int[] ints = RandomType.bigEndianToInts(buf, len);
            if (len <= 1) {
                return new Random(ints[0]);
            }
            return new Random(ints);
        }

        RandomType(IRubyObject vseed, RubyBignum state2, int left2) {
            this.seed = vseed.convertToInteger();
            byte[] bytes2 = state2.getBigIntegerValue().toByteArray();
            int[] ints = new int[bytes2.length / 4];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                ints[i2] = RubyRandomBase.getIntBigIntegerBuffer(bytes2, i2);
            }
            this.impl = new Random(ints, left2);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RandomType)) {
                return false;
            }
            RandomType rhs = (RandomType)obj;
            return this.seed.op_equal(this.seed.getRuntime().getCurrentContext(), rhs.seed).isTrue() && this.impl.equals(rhs.impl);
        }

        public int hashCode() {
            return (629 + this.seed.hashCode()) * 37 + this.impl.hashCode();
        }

        RandomType(RandomType orig) {
            this.seed = orig.seed;
            this.impl = new Random(orig.impl);
        }

        int genrandInt32() {
            return this.impl.genrandInt32();
        }

        double genrandReal() {
            return this.impl.genrandReal();
        }

        double genrandReal(boolean excl) {
            if (excl) {
                return this.impl.genrandReal();
            }
            return this.impl.genrandReal2();
        }

        double genrandReal2() {
            return this.impl.genrandReal2();
        }

        RubyInteger getSeed() {
            return this.seed;
        }

        RubyBignum getState() {
            int[] ints = this.impl.getState();
            byte[] bytes2 = new byte[ints.length * 4];
            for (int idx = 0; idx < ints.length; ++idx) {
                RubyRandomBase.setIntBigIntegerBuffer(bytes2, idx, ints[idx]);
            }
            return RubyBignum.newBignum(this.seed.getRuntime(), new BigInteger(bytes2));
        }

        int getLeft() {
            return this.impl.getLeft();
        }

        private static int[] bigEndianToInts(byte[] buf, int initKeyLen) {
            int[] initKey = new int[initKeyLen];
            for (int idx = 0; idx < initKey.length; ++idx) {
                initKey[idx] = RubyRandomBase.getIntBigIntegerBuffer(buf, idx);
            }
            return initKey;
        }
    }
}

