/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"GC"})
public class RubyGC {
    private static volatile boolean gcDisabled = false;
    private static volatile boolean stress = false;
    private static volatile boolean autoCompact = false;
    private static volatile boolean measureTotalTime = false;

    public static RubyModule createGCModule(Ruby runtime2) {
        RubyModule result2 = runtime2.defineModule("GC");
        result2.defineAnnotatedMethods(RubyGC.class);
        return result2;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, optional=1, checkArity=false)
    public static IRubyObject start(ThreadContext context, IRubyObject recv, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return context.nil;
    }

    @JRubyMethod(optional=1, checkArity=false)
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return context.nil;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject measure_total_time(ThreadContext context, IRubyObject self2) {
        return context.runtime.newBoolean(measureTotalTime);
    }

    @JRubyMethod(module=true, name={"measure_total_time="}, visibility=Visibility.PRIVATE)
    public static IRubyObject measure_total_time_set(ThreadContext context, IRubyObject self2, IRubyObject value2) {
        measureTotalTime = value2.isTrue();
        return context.nil;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject total_time(ThreadContext context, IRubyObject self2) {
        return context.runtime.newFixnum(RubyGC.getCollectionTime());
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject enable(ThreadContext context, IRubyObject recv) {
        Ruby runtime2 = context.runtime;
        RubyGC.emptyImplementationWarning(runtime2, IRubyWarnings.ID.GC_ENABLE_UNIMPLEMENTED, "GC.enable");
        boolean old = gcDisabled;
        gcDisabled = false;
        return runtime2.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject disable(ThreadContext context, IRubyObject recv) {
        Ruby runtime2 = context.runtime;
        RubyGC.emptyImplementationWarning(runtime2, IRubyWarnings.ID.GC_DISABLE_UNIMPLEMENTED, "GC.disable");
        boolean old = gcDisabled;
        gcDisabled = true;
        return runtime2.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress(ThreadContext context, IRubyObject recv) {
        return RubyBoolean.newBoolean(context, stress);
    }

    @JRubyMethod(name={"stress="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress_set(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        RubyGC.emptyImplementationWarning(runtime2, IRubyWarnings.ID.GC_STRESS_UNIMPLEMENTED, "GC.stress=");
        stress = arg2.isTrue();
        return runtime2.newBoolean(stress);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject count(ThreadContext context, IRubyObject recv) {
        try {
            int count2 = RubyGC.getCollectionCount();
            return context.runtime.newFixnum(count2);
        }
        catch (Throwable t) {
            return RubyFixnum.minus_one(context.runtime);
        }
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject auto_compact(ThreadContext context, IRubyObject recv) {
        RubyGC.emptyImplementationWarning(context.runtime, IRubyWarnings.ID.GC_ENABLE_UNIMPLEMENTED, "GC.auto_compact");
        return RubyBoolean.newBoolean(context, autoCompact);
    }

    @JRubyMethod(name={"auto_compact="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject auto_compact_set(ThreadContext context, IRubyObject recv, IRubyObject autoCompact) {
        RubyGC.emptyImplementationWarning(context.runtime, IRubyWarnings.ID.GC_ENABLE_UNIMPLEMENTED, "GC.auto_compact=");
        RubyGC.autoCompact = autoCompact.isTrue();
        return autoCompact;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject compact(ThreadContext context, IRubyObject recv) {
        RubyGC.emptyImplementationWarning(context.runtime, IRubyWarnings.ID.GC_ENABLE_UNIMPLEMENTED, "GC.compact");
        return context.nil;
    }

    private static void emptyImplementationWarning(Ruby runtime2, IRubyWarnings.ID id2, String name2) {
        runtime2.getWarnings().warnOnce(id2, name2 + " does nothing on JRuby");
    }

    public static int getCollectionCount() {
        int count2 = 0;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            count2 = (int)((long)count2 + bean.getCollectionCount());
        }
        return count2;
    }

    public static long getCollectionTime() {
        long time = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            time += bean.getCollectionTime();
        }
        return time;
    }
}

