/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.cli.Options;

public class RubyFixnum
extends RubyInteger
implements Constantizable {
    final long value;
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;
    public static final boolean USE_CACHE = Options.USE_FIXNUM_CACHE.load();
    public static final int CACHE_OFFSET;

    public static RubyClass createFixnumClass(Ruby runtime2) {
        RubyClass fixnum = runtime2.getInteger();
        runtime2.getObject().setConstant("Fixnum", fixnum);
        runtime2.getObject().deprecateConstant(runtime2, "Fixnum");
        for (int i2 = 0; i2 < runtime2.fixnumCache.length; ++i2) {
            runtime2.fixnumCache[i2] = new RubyFixnum(fixnum, (long)(i2 - CACHE_OFFSET));
        }
        return fixnum;
    }

    private static IRubyObject fixCoerce(IRubyObject x) {
        while (!((x = x.convertToInteger()) instanceof RubyFixnum) && !(x instanceof RubyBignum)) {
        }
        return x;
    }

    public RubyFixnum(Ruby runtime2) {
        this(runtime2, 0L);
    }

    public RubyFixnum(Ruby runtime2, long value2) {
        super(runtime2.getFixnum());
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    private RubyFixnum(RubyClass klazz, long value2) {
        super(klazz);
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.FIXNUM;
    }

    @Override
    public Object constant() {
        Object[] fixnumConstants;
        Object constant = null;
        long value2 = this.value;
        if (value2 < (long)CACHE_OFFSET && value2 >= (long)(-CACHE_OFFSET) && (constant = (fixnumConstants = this.metaClass.runtime.fixnumConstants)[(int)value2 + CACHE_OFFSET]) == null) {
            fixnumConstants[(int)value2 + RubyFixnum.CACHE_OFFSET] = constant = OptoFactory.newConstantWrapper(IRubyObject.class, this);
        }
        return constant;
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other instanceof RubyFixnum && this.value == ((RubyFixnum)other).value;
    }

    @Override
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        long value2 = this.value;
        if (RubyFixnum.fixnumable(value2)) {
            return RubyBoolean.newBoolean(context, this == obj || this.eql(obj));
        }
        return super.equal_p(context, obj);
    }

    private static boolean fixnumable(long value2) {
        return value2 <= 0x3FFFFFFFFFFFFFFFL && value2 >= -4611686018427387904L;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public int signum() {
        return Long.signum(this.value);
    }

    @Override
    public RubyInteger negate() {
        return RubyFixnum.negate(this.metaClass.runtime, this.value);
    }

    public static RubyFixnum newFixnum(Ruby runtime2, long value2) {
        if (USE_CACHE && RubyFixnum.isInCacheRange(value2)) {
            return RubyFixnum.cachedFixnum(runtime2, value2);
        }
        return new RubyFixnum(runtime2, value2);
    }

    public static RubyFixnum newFixnum(Ruby runtime2, int value2) {
        return RubyFixnum.newFixnum(runtime2, (long)value2);
    }

    private static boolean isInCacheRange(long value2) {
        return value2 <= (long)(CACHE_OFFSET - 1) && value2 >= (long)(-CACHE_OFFSET);
    }

    private static RubyFixnum cachedFixnum(Ruby runtime2, long value2) {
        return runtime2.fixnumCache[(int)(value2 + (long)CACHE_OFFSET)];
    }

    @Deprecated
    public final RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getRuntime(), newValue);
    }

    public static RubyFixnum zero(Ruby runtime2) {
        return CACHE_OFFSET > 0 ? runtime2.fixnumCache[CACHE_OFFSET] : new RubyFixnum(runtime2, 0L);
    }

    public static RubyFixnum one(Ruby runtime2) {
        return CACHE_OFFSET > 1 ? runtime2.fixnumCache[CACHE_OFFSET + 1] : new RubyFixnum(runtime2, 1L);
    }

    public static RubyFixnum two(Ruby runtime2) {
        return CACHE_OFFSET > 2 ? runtime2.fixnumCache[CACHE_OFFSET + 2] : new RubyFixnum(runtime2, 2L);
    }

    public static RubyFixnum three(Ruby runtime2) {
        return CACHE_OFFSET > 3 ? runtime2.fixnumCache[CACHE_OFFSET + 3] : new RubyFixnum(runtime2, 3L);
    }

    public static RubyFixnum four(Ruby runtime2) {
        return CACHE_OFFSET > 4 ? runtime2.fixnumCache[CACHE_OFFSET + 4] : new RubyFixnum(runtime2, 4L);
    }

    public static RubyFixnum five(Ruby runtime2) {
        return CACHE_OFFSET > 5 ? runtime2.fixnumCache[CACHE_OFFSET + 5] : new RubyFixnum(runtime2, 5L);
    }

    public static RubyFixnum minus_one(Ruby runtime2) {
        return -CACHE_OFFSET <= -1 ? runtime2.fixnumCache[CACHE_OFFSET - 1] : new RubyFixnum(runtime2, -1L);
    }

    @Override
    public RubyFixnum hash() {
        Ruby runtime2 = this.metaClass.runtime;
        return RubyFixnum.newFixnum(runtime2, RubyFixnum.fixHash(runtime2, this.value));
    }

    @Override
    public final int hashCode() {
        return (int)RubyFixnum.fixHash(this.getRuntime(), this.value);
    }

    private static long fixHash(Ruby runtime2, long value2) {
        return Helpers.multAndMix(runtime2.getHashSeedK0(), value2);
    }

    @Override
    public IRubyObject times(ThreadContext context, Block block) {
        if (block.isGiven()) {
            long value2 = this.value;
            boolean checkArity = block.type.checkArity;
            if (block.getSignature() == Signature.NO_ARGUMENTS) {
                if (checkArity) {
                    IRubyObject nil = context.nil;
                    for (long i2 = 0L; i2 < value2; ++i2) {
                        block.yieldSpecific(context, nil);
                    }
                } else {
                    for (long i3 = 0L; i3 < value2; ++i3) {
                        block.yieldSpecific(context);
                    }
                }
            } else {
                Ruby runtime2 = context.runtime;
                for (long i4 = 0L; i4 < value2; ++i4) {
                    block.yield(context, RubyFixnum.newFixnum(runtime2, i4));
                }
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "times", RubyInteger::timesSize);
    }

    @Override
    public IRubyObject ceil(ThreadContext context, IRubyObject arg2) {
        long ndigits = arg2.convertToInteger().getLongValue();
        if (ndigits >= 0L) {
            return this;
        }
        long self2 = this.value;
        long posdigits = Math.abs(ndigits);
        long exp2 = (long)Math.pow(10.0, posdigits);
        long mod = (self2 % exp2 + exp2) % exp2;
        long res = self2;
        if (mod != 0L) {
            res = self2 + (exp2 - mod);
        }
        return RubyFixnum.newFixnum(context.runtime, res);
    }

    @Override
    public IRubyObject floor(ThreadContext context, IRubyObject arg2) {
        long ndigits = arg2.convertToInteger().getLongValue();
        if (ndigits >= 0L) {
            return this;
        }
        long self2 = this.value;
        long posdigits = Math.abs(ndigits);
        long exp2 = (long)Math.pow(10.0, posdigits);
        long mod = (self2 % exp2 + exp2) % exp2;
        long res = self2 - mod;
        return RubyFixnum.newFixnum(context.runtime, res);
    }

    @Override
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        long self2 = this.value;
        if (self2 > 0L) {
            return this.floor(context, arg2);
        }
        if (self2 < 0L) {
            return this.ceil(context, arg2);
        }
        return this;
    }

    @Override
    public RubyArray digits(ThreadContext context, IRubyObject base) {
        long value2 = this.getLongValue();
        if (value2 < 0L) {
            throw context.runtime.newMathDomainError("out of domain");
        }
        if ((base = base.convertToInteger()) instanceof RubyBignum) {
            return RubyArray.newArray(context.runtime, RubyFixnum.newFixnum(context.runtime, value2));
        }
        long longBase = ((RubyFixnum)base).value;
        if (longBase < 0L) {
            throw context.runtime.newArgumentError("negative radix");
        }
        if (longBase < 2L) {
            throw context.runtime.newArgumentError("invalid radix: " + longBase);
        }
        if (value2 == 0L) {
            return RubyArray.newArray(context.runtime, RubyFixnum.zero(context.runtime));
        }
        RubyArray res = RubyArray.newArray(context.runtime, 0);
        while (value2 > 0L) {
            res.append(RubyFixnum.newFixnum(context.runtime, value2 % longBase));
            value2 /= longBase;
        }
        return res;
    }

    public RubyString to_s(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.to_s();
            }
            case 1: {
                return this.to_s(args2[0]);
            }
        }
        throw this.metaClass.runtime.newArgumentError(args2.length, 1);
    }

    @Override
    public RubyString to_s() {
        ByteList bytes2 = ConvertBytes.longToByteList(this.value, 10);
        return RubyString.newString(this.metaClass.runtime, bytes2, (Encoding)USASCIIEncoding.INSTANCE);
    }

    @Override
    public RubyString to_s(IRubyObject arg0) {
        int base = RubyFixnum.num2int(arg0);
        if (base < 2 || base > 36) {
            throw this.metaClass.runtime.newArgumentError("illegal radix " + base);
        }
        ByteList bytes2 = ConvertBytes.longToByteList(this.value, base);
        return RubyString.newString(this.metaClass.runtime, bytes2, (Encoding)USASCIIEncoding.INSTANCE);
    }

    @Deprecated
    public IRubyObject to_sym() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        return symbol != null ? symbol : this.getRuntime().getNil();
    }

    @Override
    public IRubyObject op_uminus(ThreadContext context) {
        return RubyFixnum.negate(context.runtime, this.value);
    }

    private static RubyInteger negate(Ruby runtime2, long value2) {
        if (value2 == Long.MIN_VALUE) {
            return RubyBignum.newBignum(runtime2, BigInteger.valueOf(value2).negate());
        }
        return RubyFixnum.newFixnum(runtime2, -value2);
    }

    @Override
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.addFixnum(context, (RubyFixnum)other);
        }
        return this.addOther(context, other);
    }

    @Override
    public IRubyObject op_plus(ThreadContext context, long other) {
        try {
            return RubyFixnum.newFixnum(context.runtime, Math.addExact(this.value, other));
        }
        catch (ArithmeticException ae) {
            return this.addAsBignum(context, other);
        }
    }

    public IRubyObject op_plus(ThreadContext context, double other) {
        return context.runtime.newFloat((double)this.value + other);
    }

    public IRubyObject op_plus_one(ThreadContext context) {
        try {
            return RubyFixnum.newFixnum(context.runtime, Math.addExact(this.value, 1L));
        }
        catch (ArithmeticException ae) {
            return this.addAsBignum(context, 1L);
        }
    }

    public IRubyObject op_plus_two(ThreadContext context) {
        long result2 = this.value + 2L;
        if (result2 < this.value) {
            return this.addAsBignum(context, 2L);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    private RubyInteger addFixnum(ThreadContext context, RubyFixnum other) {
        try {
            return RubyFixnum.newFixnum(context.runtime, Math.addExact(this.value, other.value));
        }
        catch (ArithmeticException ae) {
            return this.addAsBignum(context, other.value);
        }
    }

    private RubyInteger addAsBignum(ThreadContext context, long other) {
        return (RubyInteger)RubyBignum.newBignum(context.runtime, this.value).op_plus(context, other);
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_plus(context, this.value);
        }
        if (other instanceof RubyFloat) {
            return this.op_plus(context, ((RubyFloat)other).value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_plus, other);
    }

    @Override
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_minus(context, ((RubyFixnum)other).value);
        }
        return this.subtractOther(context, other);
    }

    @Override
    public IRubyObject op_minus(ThreadContext context, long other) {
        try {
            return RubyFixnum.newFixnum(context.runtime, Math.subtractExact(this.value, other));
        }
        catch (ArithmeticException ae) {
            return this.subtractAsBignum(context, other);
        }
    }

    public IRubyObject op_minus(ThreadContext context, double other) {
        return context.runtime.newFloat((double)this.value - other);
    }

    public IRubyObject op_minus_one(ThreadContext context) {
        try {
            return RubyFixnum.newFixnum(context.runtime, Math.subtractExact(this.value, 1L));
        }
        catch (ArithmeticException ae) {
            return this.subtractAsBignum(context, 1L);
        }
    }

    public IRubyObject op_minus_two(ThreadContext context) {
        try {
            return RubyFixnum.newFixnum(context.runtime, Math.subtractExact(this.value, 2L));
        }
        catch (ArithmeticException ae) {
            return this.subtractAsBignum(context, 2L);
        }
    }

    private RubyInteger subtractAsBignum(ThreadContext context, long other) {
        return (RubyInteger)RubyBignum.newBignum(context.runtime, this.value).op_minus(context, other);
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(context.runtime, this.value).op_minus(context, ((RubyBignum)other).value);
        }
        if (other instanceof RubyFloat) {
            return this.op_minus(context, ((RubyFloat)other).value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_minus, other);
    }

    @Override
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_mul(context, ((RubyFixnum)other).value);
        }
        return this.multiplyOther(context, other);
    }

    private IRubyObject multiplyOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_mul(context, this.value);
        }
        if (other instanceof RubyFloat) {
            return this.op_mul(context, ((RubyFloat)other).value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_times, other);
    }

    @Override
    public IRubyObject op_mul(ThreadContext context, long other) {
        Ruby runtime2 = context.runtime;
        long value2 = this.value;
        long result2 = value2 * other;
        if (other == 0L || (Math.abs(value2) | Math.abs(other)) >>> 31 == 0L || result2 / other == value2 && (value2 != Long.MIN_VALUE || other != -1L)) {
            return RubyFixnum.newFixnum(runtime2, result2);
        }
        BigInteger valueBig = BigInteger.valueOf(value2);
        BigInteger otherBig = BigInteger.valueOf(other);
        return RubyBignum.newBignum(runtime2, valueBig.multiply(otherBig));
    }

    public IRubyObject op_mul(ThreadContext context, double other) {
        return context.runtime.newFloat((double)this.value * other);
    }

    @Override
    public IRubyObject idiv(ThreadContext context, IRubyObject other) {
        this.checkZeroDivisionError(context, other);
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.value, ((RubyFixnum)other).value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).div, other);
    }

    @Override
    public IRubyObject idiv(ThreadContext context, long other) {
        return this.idivLong(context, this.value, other);
    }

    @Override
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.value, ((RubyFixnum)other).value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_quo, other);
    }

    public IRubyObject op_div(ThreadContext context, long other) {
        return this.idivLong(context, this.value, other);
    }

    @Override
    public RubyBoolean odd_p(ThreadContext context) {
        return (this.value & 1L) != 0L ? context.tru : context.fals;
    }

    @Override
    public RubyBoolean even_p(ThreadContext context) {
        return (this.value & 1L) == 0L ? context.tru : context.fals;
    }

    @Override
    public IRubyObject pred(ThreadContext context) {
        return this.op_minus_one(context);
    }

    @Deprecated
    public IRubyObject idiv(ThreadContext context, IRubyObject other, String method2) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.value, ((RubyFixnum)other).value);
        }
        return this.coerceBin(context, method2, other);
    }

    public IRubyObject idiv(ThreadContext context, IRubyObject other, CallSite site) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.value, ((RubyFixnum)other).value);
        }
        return this.coerceBin(context, site, other);
    }

    @Deprecated
    public IRubyObject idiv(ThreadContext context, long y, String method2) {
        long x = this.value;
        return this.idivLong(context, x, y);
    }

    private RubyInteger idivLong(ThreadContext context, long x, long y) {
        long result2;
        Ruby runtime2 = context.runtime;
        if (y == 0L) {
            throw runtime2.newZeroDivisionError();
        }
        if (y > 0L) {
            result2 = x >= 0L ? x / y : (x + 1L) / y - 1L;
        } else if (x > 0L) {
            result2 = (x - 1L) / y - 1L;
        } else if (y == -1L) {
            if (x == Long.MIN_VALUE) {
                return RubyBignum.newBignum(runtime2, BigInteger.valueOf(x).negate());
            }
            result2 = -x;
        } else {
            result2 = x / y;
        }
        return runtime2.newFixnum(result2);
    }

    @Override
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.moduloFixnum(context, (RubyFixnum)other);
        }
        this.checkZeroDivisionError(context, other);
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_mod, other);
    }

    @Override
    public IRubyObject op_mod(ThreadContext context, long other) {
        return this.moduloFixnum(context, other);
    }

    @Override
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        return this.op_mod(context, other);
    }

    @Override
    IRubyObject modulo(ThreadContext context, long other) {
        return this.op_mod(context, other);
    }

    private IRubyObject moduloFixnum(ThreadContext context, RubyFixnum other) {
        return this.moduloFixnum(context, other.value);
    }

    private IRubyObject moduloFixnum(ThreadContext context, long other) {
        long x = this.value;
        long y = other;
        if (y == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        long mod = x % y;
        if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
            mod += y;
        }
        return context.runtime.newFixnum(mod);
    }

    @Override
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.divmodFixnum(context, (RubyFixnum)other);
        }
        this.checkZeroDivisionError(context, other);
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).divmod, other);
    }

    private IRubyObject divmodFixnum(ThreadContext context, RubyFixnum other) {
        long mod;
        RubyInteger integerDiv;
        Ruby runtime2 = context.runtime;
        long x = this.value;
        long y = other.value;
        if (y == 0L) {
            throw runtime2.newZeroDivisionError();
        }
        if (y == -1L) {
            integerDiv = x == Long.MIN_VALUE ? RubyBignum.newBignum(runtime2, BigInteger.valueOf(x).negate()) : RubyFixnum.newFixnum(runtime2, -x);
            mod = 0L;
        } else {
            long div2 = x / y;
            mod = x - y * div2;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div2;
                mod += y;
            }
            integerDiv = RubyFixnum.newFixnum(runtime2, div2);
        }
        RubyFixnum fixMod = RubyFixnum.newFixnum(runtime2, mod);
        return RubyArray.newArray(runtime2, integerDiv, fixMod);
    }

    @Override
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.powerFixnum(context, (RubyFixnum)other);
        }
        if (other instanceof RubyBignum) {
            return this.powerOther(context, other);
        }
        if (other instanceof RubyFloat) {
            double d_other = ((RubyNumeric)other).getDoubleValue();
            if (this.value < 0L && d_other != (double)Math.round(d_other)) {
                RubyComplex complex = RubyComplex.newComplexRaw(context.runtime, this);
                return RubyFixnum.numFuncall(context, complex, RubyFixnum.sites((ThreadContext)context).op_exp_complex, other);
            }
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_exp, other);
    }

    public IRubyObject op_pow(ThreadContext context, long other) {
        return this.powerFixnum(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @Deprecated
    public IRubyObject op_pow_19(ThreadContext context, IRubyObject other) {
        return this.op_pow(context, other);
    }

    private IRubyObject powerOther(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        long a = this.value;
        if (other instanceof RubyBignum) {
            if (a == 1L) {
                return RubyFixnum.one(runtime2);
            }
            if (a == -1L) {
                return ((RubyBignum)other).even_p(context).isTrue() ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
            }
            if (RubyFixnum.sites((ThreadContext)context).op_lt_bignum.call(context, other, other, (IRubyObject)RubyFixnum.zero(runtime2)).isTrue()) {
                RubyRational rational = RubyRational.newRationalRaw(runtime2, this);
                return RubyFixnum.numFuncall(context, rational, RubyFixnum.sites((ThreadContext)context).op_exp_rational, other);
            }
            if (a == 0L) {
                return RubyFixnum.zero(runtime2);
            }
            return RubyBignum.newBignum(runtime2, RubyBignum.long2big(a)).op_pow(context, other);
        }
        if (other instanceof RubyFloat) {
            double b2 = ((RubyFloat)other).value;
            if (b2 == 0.0 || a == 1L) {
                return runtime2.newFloat(1.0);
            }
            if (a == 0L) {
                return runtime2.newFloat(b2 < 0.0 ? Double.POSITIVE_INFINITY : 0.0);
            }
            return RubyFloat.newFloat(runtime2, Math.pow(a, b2));
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_exp, other);
    }

    private RubyNumeric powerFixnum(ThreadContext context, RubyFixnum other) {
        Ruby runtime2 = context.runtime;
        long a = this.value;
        long b2 = other.value;
        if (b2 < 0L) {
            RubyRational rational = RubyRational.newRationalRaw(runtime2, this);
            return (RubyNumeric)RubyFixnum.numFuncall(context, rational, RubyFixnum.sites((ThreadContext)context).op_exp_rational, other);
        }
        if (b2 == 0L) {
            return RubyFixnum.one(runtime2);
        }
        if (b2 == 1L) {
            return this;
        }
        if (a == 0L) {
            return b2 > 0L ? RubyFixnum.zero(runtime2) : RubyNumeric.dbl2ival(runtime2, Double.POSITIVE_INFINITY);
        }
        if (a == 1L) {
            return RubyFixnum.one(runtime2);
        }
        if (a == -1L) {
            return b2 % 2L == 0L ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
        }
        return Numeric.int_pow(context, a, b2);
    }

    protected IRubyObject intPowTmp1(ThreadContext context, RubyInteger y, long mm, boolean negaFlg) {
        Ruby runtime2 = context.runtime;
        long xx = this.value;
        long tmp = 1L;
        while (!(y instanceof RubyFixnum)) {
            if (Numeric.f_odd_p(context, y)) {
                tmp = tmp * xx % mm;
            }
            xx = xx * xx % mm;
            y = (RubyInteger)RubyFixnum.sites((ThreadContext)context).op_rshift.call(context, (IRubyObject)y, (IRubyObject)y, (IRubyObject)RubyFixnum.one(runtime2));
        }
        for (long yy = y.convertToInteger().getLongValue(); yy != 0L; yy >>= 1) {
            if ((yy & 1L) != 0L) {
                tmp = tmp * xx % mm;
            }
            xx = xx * xx % mm;
        }
        if (negaFlg && tmp != 0L) {
            tmp -= mm;
        }
        return runtime2.newFixnum(tmp);
    }

    @Deprecated
    protected IRubyObject intPowTmp2(ThreadContext context, IRubyObject y, long mm, boolean negaFlg) {
        return this.intPowTmp2(context, (RubyInteger)y, mm, negaFlg);
    }

    IRubyObject intPowTmp2(ThreadContext context, RubyInteger y, long mm, boolean negaFlg) {
        Ruby runtime2 = context.runtime;
        long tmp = 1L;
        RubyFixnum tmp2 = runtime2.newFixnum(tmp);
        RubyFixnum xx = this;
        while (!(y instanceof RubyFixnum)) {
            if (Numeric.f_odd_p(context, y)) {
                tmp2 = RubyFixnum.mulModulo(context, tmp2, xx, mm);
            }
            xx = RubyFixnum.mulModulo(context, xx, xx, mm);
            y = (RubyInteger)RubyFixnum.sites((ThreadContext)context).op_rshift.call(context, (IRubyObject)y, (IRubyObject)y, (IRubyObject)RubyFixnum.one(runtime2));
        }
        for (long yy = ((RubyFixnum)y).value; yy != 0L; yy >>= 1) {
            if ((yy & 1L) != 0L) {
                tmp2 = RubyFixnum.mulModulo(context, tmp2, xx, mm);
            }
            xx = RubyFixnum.mulModulo(context, xx, xx, mm);
        }
        tmp = tmp2.value;
        if (negaFlg && tmp != 0L) {
            tmp -= mm;
        }
        return runtime2.newFixnum(tmp);
    }

    private static RubyFixnum mulModulo(ThreadContext context, RubyFixnum a, RubyFixnum b2, long c) {
        return (RubyFixnum)((RubyInteger)a.op_mul(context, b2.value)).modulo(context, c);
    }

    @Override
    public IRubyObject abs(ThreadContext context) {
        if (this.value < 0L) {
            if (this.value == Long.MIN_VALUE) {
                return RubyBignum.newBignum(context.runtime, BigInteger.valueOf(this.value).negate());
            }
            return RubyFixnum.newFixnum(context.runtime, -this.value);
        }
        return this;
    }

    @Override
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return other instanceof RubyFixnum ? this.op_equal(context, ((RubyFixnum)other).value) : this.op_equalOther(context, other);
    }

    public IRubyObject op_equal(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context, this.value == other);
    }

    public IRubyObject op_equal(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context, (double)this.value == other);
    }

    @Override
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return other instanceof RubyFixnum ? this.op_not_equal(context, ((RubyFixnum)other).value) : super.op_not_equal(context, other);
    }

    public IRubyObject op_not_equal(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context, this.value != other);
    }

    public IRubyObject op_not_equal(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context, (double)this.value != other);
    }

    public boolean op_equal_boolean(ThreadContext context, long other) {
        return this.value == other;
    }

    public final boolean fastEqual(RubyFixnum other) {
        return this.value == other.value;
    }

    private IRubyObject op_equalOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).value) == 0);
        }
        if (other instanceof RubyFloat) {
            return this.op_equal(context, ((RubyFloat)other).value);
        }
        return super.op_num_equal(context, other);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            return this.value == ((RubyFixnum)other).value;
        }
        return false;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            return this.value == otherValue ? 0 : (this.value > otherValue ? 1 : -1);
        }
        return this.compareToOther(other);
    }

    private int compareToOther(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).value);
        }
        if (other instanceof RubyFloat) {
            return Double.compare(this.value, ((RubyFloat)other).value);
        }
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return (int)this.coerceCmp(context, RubyFixnum.sites((ThreadContext)context).op_cmp, other).convertToInteger().getLongValue();
    }

    @Override
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        return other instanceof RubyFixnum ? this.op_cmp(context, ((RubyFixnum)other).value) : this.compareOther(context, other);
    }

    public IRubyObject op_cmp(ThreadContext context, long other) {
        Ruby runtime2 = context.runtime;
        return this.value == other ? RubyFixnum.zero(runtime2) : (this.value > other ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2));
    }

    public IRubyObject op_cmp(ThreadContext context, double other) {
        return RubyFixnum.dbl_cmp(context.runtime, this.value, other);
    }

    private IRubyObject compareOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyFixnum.newFixnum(context.runtime, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).value));
        }
        if (other instanceof RubyFloat) {
            return RubyFixnum.dbl_cmp(context.runtime, this.value, ((RubyFloat)other).value);
        }
        return this.coerceCmp(context, RubyFixnum.sites((ThreadContext)context).op_cmp, other);
    }

    @Override
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context, this.value > ((RubyFixnum)other).value);
        }
        return this.op_gtOther(context, other);
    }

    public IRubyObject op_gt(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context, this.value > other);
    }

    public boolean op_gt_boolean(ThreadContext context, long other) {
        return this.value > other;
    }

    private IRubyObject op_gtOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).value) > 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context, (double)this.value > ((RubyFloat)other).value);
        }
        return this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_gt, other);
    }

    @Override
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context, this.value >= ((RubyFixnum)other).value);
        }
        return this.op_geOther(context, other);
    }

    public IRubyObject op_ge(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context, this.value >= other);
    }

    public boolean op_ge_boolean(ThreadContext context, long other) {
        return this.value >= other;
    }

    private IRubyObject op_geOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).value) >= 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context, (double)this.value >= ((RubyFloat)other).value);
        }
        return this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_ge, other);
    }

    @Override
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_lt(context, ((RubyFixnum)other).value);
        }
        return this.op_ltOther(context, other);
    }

    public IRubyObject op_lt(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context, this.value < other);
    }

    public boolean op_lt_boolean(ThreadContext context, long other) {
        return this.value < other;
    }

    private IRubyObject op_ltOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).value) < 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context, (double)this.value < ((RubyFloat)other).value);
        }
        return this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_lt, other);
    }

    @Override
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context, this.value <= ((RubyFixnum)other).value);
        }
        return this.op_leOther(context, other);
    }

    public IRubyObject op_le(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context, this.value <= other);
    }

    public boolean op_le_boolean(ThreadContext context, long other) {
        return this.value <= other;
    }

    private IRubyObject op_leOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).value) <= 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context, (double)this.value <= ((RubyFloat)other).value);
        }
        return this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_le, other);
    }

    @Override
    public IRubyObject op_neg(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return context.runtime.newFixnum(this.value & ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_and(context, this);
        }
        return this.coerceBit(context, RubyFixnum.sites((ThreadContext)context).checked_op_and, other);
    }

    public IRubyObject op_and(ThreadContext context, long other) {
        return RubyFixnum.newFixnum(context.runtime, this.value & other);
    }

    @Override
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return context.runtime.newFixnum(this.value | ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_or(context, this);
        }
        return this.coerceBit(context, RubyFixnum.sites((ThreadContext)context).checked_op_or, other);
    }

    public IRubyObject op_or(ThreadContext context, long other) {
        return RubyFixnum.newFixnum(context.runtime, this.value | other);
    }

    @Override
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return context.runtime.newFixnum(this.value ^ ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_xor(context, this);
        }
        return this.coerceBit(context, RubyFixnum.sites((ThreadContext)context).checked_op_xor, other);
    }

    public IRubyObject op_xor(ThreadContext context, long other) {
        return RubyFixnum.newFixnum(context.runtime, this.value ^ other);
    }

    @Override
    protected IRubyObject op_aref_subclass(ThreadContext context, IRubyObject other) {
        BigInteger big;
        if (!(other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum || (other = RubyBignum.bignorm(context.runtime, big = ((RubyBignum)other).value)) instanceof RubyFixnum)) {
            return big.signum() == 0 || this.value >= 0L ? RubyFixnum.zero(context.runtime) : RubyFixnum.one(context.runtime);
        }
        long otherValue = RubyFixnum.fix2long(other);
        if (otherValue < 0L) {
            return RubyFixnum.zero(context.runtime);
        }
        if (63L < otherValue) {
            return this.value < 0L ? RubyFixnum.one(context.runtime) : RubyFixnum.zero(context.runtime);
        }
        return (this.value & 1L << (int)otherValue) == 0L ? RubyFixnum.zero(context.runtime) : RubyFixnum.one(context.runtime);
    }

    @Override
    public IRubyObject op_lshift(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(context.runtime, this.value).op_lshift(context, other);
        }
        return this.op_lshift(context, ((RubyFixnum)other).value);
    }

    @Override
    public RubyInteger op_lshift(ThreadContext context, long width) {
        return width < 0L ? this.rshift(context, -width) : this.lshift(context, width);
    }

    private RubyInteger lshift(ThreadContext context, long width) {
        if (width > 63L || (-1L << (int)(64L - width - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(context.runtime, this.value).op_lshift(context, width);
        }
        return RubyFixnum.newFixnum(context.runtime, this.value << (int)width);
    }

    @Deprecated
    public IRubyObject op_lshift(long width) {
        return this.op_lshift(this.getRuntime().getCurrentContext(), width);
    }

    @Override
    public IRubyObject op_rshift(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(context.runtime, this.value).op_rshift(context, other);
        }
        return this.op_rshift(context, ((RubyFixnum)other).value);
    }

    @Override
    public RubyInteger op_rshift(ThreadContext context, long width) {
        if (width == 0L) {
            return this;
        }
        return width < 0L ? this.lshift(context, -width) : this.rshift(context, width);
    }

    private RubyFixnum rshift(ThreadContext context, long width) {
        if (width >= 63L) {
            return this.value < 0L ? RubyFixnum.minus_one(context.runtime) : RubyFixnum.zero(context.runtime);
        }
        return RubyFixnum.newFixnum(context.runtime, this.value >> (int)width);
    }

    @Deprecated
    public IRubyObject op_rshift(long width) {
        return this.op_rshift(this.getRuntime().getCurrentContext(), width);
    }

    @Override
    public IRubyObject to_f(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.value);
    }

    @Override
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.metaClass.runtime, this.value);
    }

    @Override
    public IRubyObject size(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, 8L);
    }

    @Deprecated
    public IRubyObject zero_p() {
        return this.zero_p(this.getRuntime().getCurrentContext());
    }

    @Override
    public IRubyObject zero_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.value == 0L);
    }

    @Override
    public final boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero() ? context.nil : this;
    }

    @Override
    final boolean isOne() {
        return this.value == 1L;
    }

    @Override
    public IRubyObject succ(ThreadContext context) {
        return this.op_plus_one(context);
    }

    @Override
    public IRubyObject bit_length(ThreadContext context) {
        long tmpValue = this.value;
        if (this.value < 0L) {
            tmpValue = this.value ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return context.runtime.newFixnum(64 - Long.numberOfLeadingZeros(tmpValue));
    }

    @Override
    public IRubyObject id() {
        long value2 = this.value;
        if (RubyFixnum.fixnumable(value2)) {
            return RubyFixnum.newFixnum(this.metaClass.runtime, 2L * value2 + 1L);
        }
        return super.id();
    }

    @Override
    public String asJavaString() {
        throw this.metaClass.runtime.newTypeError(this.inspect().toString() + " is not a symbol");
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }

    private void checkZeroDivisionError(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
    }

    @Override
    public RubyInteger convertToInteger(String method2) {
        return this;
    }

    @Override
    public IRubyObject fdivDouble(ThreadContext context, IRubyObject y) {
        if (y instanceof RubyFixnum) {
            return context.runtime.newFloat((double)this.value / (double)RubyFixnum.fix2long(y));
        }
        if (y instanceof RubyBignum) {
            return RubyBignum.newBignum(context.runtime, this.value).fdivDouble(context, (RubyBignum)y);
        }
        if (y instanceof RubyFloat) {
            return context.runtime.newFloat((double)this.value / ((RubyFloat)y).value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).fdiv, y);
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        CachingCallSite op_lt_site = RubyFixnum.sites((ThreadContext)context).basic_op_lt;
        if (op_lt_site.isBuiltin(this.metaClass)) {
            return RubyBoolean.newBoolean(context, this.value < 0L);
        }
        return op_lt_site.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        CachingCallSite op_gt_site = RubyFixnum.sites((ThreadContext)context).basic_op_gt;
        if (op_gt_site.isBuiltin(this.metaClass)) {
            return RubyBoolean.newBoolean(context, this.value > 0L);
        }
        return op_gt_site.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @Override
    protected boolean int_round_zero_p(ThreadContext context, int ndigits) {
        long bytes2 = 8L;
        return -0.415241 * (double)ndigits - 0.125 > (double)bytes2;
    }

    @Override
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @Override
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.runtime);
    }

    @Override
    public RubyRational convertToRational() {
        Ruby runtime2 = this.metaClass.runtime;
        return RubyRational.newRationalRaw(runtime2, this, RubyFixnum.one(runtime2));
    }

    @Override
    public IRubyObject remainder(ThreadContext context, IRubyObject y) {
        return this.numRemainder(context, y);
    }

    @Override
    public IRubyObject sqrt(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (this.isNegative()) {
            throw runtime2.newMathDomainError("Numerical argument is out of domain - isqrt");
        }
        long sq = RubyFixnum.floorSqrt(this.value);
        return RubyFixnum.newFixnum(runtime2, sq);
    }

    private static JavaSites.FixnumSites sites(ThreadContext context) {
        return context.sites.Fixnum;
    }

    @Deprecated
    public static IRubyObject induced_from(IRubyObject recv, IRubyObject other) {
        return RubyNumeric.num2fix(other);
    }

    @Override
    @Deprecated
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    static {
        int cacheRange = 0;
        if (USE_CACHE && (cacheRange = Options.FIXNUM_CACHE_RANGE.load().intValue()) < 0) {
            cacheRange = 0;
        }
        CACHE_OFFSET = cacheRange;
    }
}

