/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStringBuilder;

@JRubyModule(name={"Comparable"})
public class RubyComparable {
    public static RubyModule createComparable(Ruby runtime2) {
        RubyModule comparableModule = runtime2.defineModule("Comparable");
        comparableModule.defineAnnotatedMethods(RubyComparable.class);
        return comparableModule;
    }

    public static int cmpint(ThreadContext context, CallSite op_gt2, CallSite op_lt2, IRubyObject val, IRubyObject a, IRubyObject b2) {
        if (val == context.nil) {
            RubyComparable.cmperr(a, b2);
        }
        if (val instanceof RubyFixnum) {
            int asInt = RubyNumeric.fix2int((RubyFixnum)val);
            if (asInt > 0) {
                return 1;
            }
            if (asInt < 0) {
                return -1;
            }
            return 0;
        }
        if (val instanceof RubyBignum) {
            return ((RubyBignum)val).signum() == -1 ? -1 : 1;
        }
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        if (op_gt2.call(context, val, val, (IRubyObject)zero).isTrue()) {
            return 1;
        }
        if (op_lt2.call(context, val, val, (IRubyObject)zero).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static int cmpint(ThreadContext context, IRubyObject val, IRubyObject a, IRubyObject b2) {
        JavaSites.ComparableSites sites = RubyComparable.sites(context);
        return RubyComparable.cmpint(context, sites.op_gt, sites.op_lt, val, a, b2);
    }

    public static int cmpAndCmpint(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject cmpResult = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, a, a, b2);
        return RubyComparable.cmpint(context, cmpResult, a, b2);
    }

    public static int cmpAndCmpint(ThreadContext context, CallSite op_cmp2, CallSite op_gt2, CallSite op_lt2, IRubyObject a, IRubyObject b2) {
        IRubyObject cmpResult = op_cmp2.call(context, a, a, b2);
        return RubyComparable.cmpint(context, op_gt2, op_lt2, cmpResult, a, b2);
    }

    public static IRubyObject cmperr(IRubyObject recv, IRubyObject other) {
        IRubyObject target2 = other.isImmediate() || !other.isNil() && !other.isTrue() && other != recv.getRuntime().getFalse() ? other.inspect() : other.getType();
        throw recv.getRuntime().newArgumentError("comparison of " + recv.getType() + " with " + target2 + " failed");
    }

    public static IRubyObject invcmp(ThreadContext context, IRubyObject recv, IRubyObject other) {
        return RubyComparable.invcmp(context, RubyComparable::invcmpRecursive, recv, other);
    }

    private static IRubyObject invcmpRecursive(ThreadContext context, IRubyObject recv, IRubyObject other, boolean recur) {
        if (recur || !RubyComparable.sites((ThreadContext)context).respond_to_op_cmp.respondsTo(context, other, other)) {
            return context.nil;
        }
        return RubyComparable.sites((ThreadContext)context).op_cmp.call(context, other, other, recv);
    }

    public static IRubyObject invcmp(ThreadContext context, ThreadContext.RecursiveFunctionEx<IRubyObject> func, IRubyObject recv, IRubyObject other) {
        IRubyObject result2 = context.safeRecurse(func, recv, other, "<=>", true);
        if (result2.isNil()) {
            return result2;
        }
        return RubyFixnum.newFixnum(context.runtime, -RubyComparable.cmpint(context, result2, recv, other));
    }

    @JRubyMethod(name={"=="})
    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv, IRubyObject other) {
        return RubyComparable.callCmpMethod(context, recv, other, context.fals);
    }

    @Deprecated
    public static IRubyObject op_equal19(ThreadContext context, IRubyObject recv, IRubyObject other) {
        return RubyComparable.op_equal(context, recv, other);
    }

    private static IRubyObject callCmpMethod(ThreadContext context, IRubyObject recv, IRubyObject other, IRubyObject returnValueOnError) {
        Ruby runtime2 = context.runtime;
        if (recv == other) {
            return context.tru;
        }
        IRubyObject result2 = context.safeRecurse((ctx, obj, self2, recur) -> recur ? ctx.nil : RubyComparable.sites((ThreadContext)ctx).op_cmp.call(ctx, self2, self2, (IRubyObject)obj), other, recv, "<=>", true);
        if (result2.isNil()) {
            return returnValueOnError;
        }
        return RubyBoolean.newBoolean(runtime2, RubyComparable.cmpint(context, result2, recv, other) == 0);
    }

    @JRubyMethod(name={">"})
    public static RubyBoolean op_gt(ThreadContext context, IRubyObject recv, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv, recv, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(context, RubyComparable.cmpint(context, result2, recv, other) > 0);
    }

    @JRubyMethod(name={">="})
    public static RubyBoolean op_ge(ThreadContext context, IRubyObject recv, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv, recv, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(context, RubyComparable.cmpint(context, result2, recv, other) >= 0);
    }

    @JRubyMethod(name={"<"})
    public static RubyBoolean op_lt(ThreadContext context, IRubyObject recv, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv, recv, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(context, RubyComparable.cmpint(context, result2, recv, other) < 0);
    }

    public static RubyBoolean op_lt(ThreadContext context, CallSite cmp2, IRubyObject recv, IRubyObject other) {
        IRubyObject result2 = cmp2.call(context, recv, recv, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(context, RubyComparable.cmpint(context, result2, recv, other) < 0);
    }

    @JRubyMethod(name={"<="})
    public static RubyBoolean op_le(ThreadContext context, IRubyObject recv, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv, recv, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(context, RubyComparable.cmpint(context, result2, recv, other) <= 0);
    }

    @JRubyMethod(name={"between?"})
    public static RubyBoolean between_p(ThreadContext context, IRubyObject recv, IRubyObject first2, IRubyObject second) {
        return RubyBoolean.newBoolean(context, RubyComparable.op_lt(context, recv, first2).isFalse() && RubyComparable.op_gt(context, recv, second).isFalse());
    }

    @JRubyMethod(name={"clamp"})
    public static IRubyObject clamp(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        if (!(arg2 instanceof RubyRange)) {
            throw runtime2.newArgumentError(RubyStringBuilder.str(runtime2, "wrong argument type ", arg2.getMetaClass(), "(expected Range)"));
        }
        RubyRange range = (RubyRange)arg2;
        IRubyObject min2 = range.begin(context);
        IRubyObject max2 = range.end(context);
        if (!max2.isNil() && range.isExcludeEnd()) {
            throw runtime2.newArgumentError("cannot clamp with an exclusive range");
        }
        return RubyComparable.clamp(context, recv, min2, max2);
    }

    @JRubyMethod(name={"clamp"})
    public static IRubyObject clamp(ThreadContext context, IRubyObject recv, IRubyObject min2, IRubyObject max2) {
        int c;
        JavaSites.ComparableSites sites = RubyComparable.sites(context);
        CallSite op_gt2 = sites.op_gt;
        CallSite op_lt2 = sites.op_lt;
        CallSite op_cmp2 = sites.op_cmp;
        if (!min2.isNil() && !max2.isNil() && RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, min2, max2) > 0) {
            throw context.runtime.newArgumentError("min argument must be smaller than max argument");
        }
        if (!min2.isNil()) {
            c = RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, recv, min2);
            if (c == 0) {
                return recv;
            }
            if (c < 0) {
                return min2;
            }
        }
        if (!max2.isNil() && (c = RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, recv, max2)) > 0) {
            return max2;
        }
        return recv;
    }

    private static JavaSites.ComparableSites sites(ThreadContext context) {
        return context.sites.Comparable;
    }
}

