/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.util.Hash;

public final class IntArrayHash<V>
extends Hash<V> {
    public IntArrayHash() {
    }

    public IntArrayHash(int size2) {
        super(size2);
    }

    @Override
    protected void init() {
        this.head = new IntArrayHashEntry();
    }

    private int hashCode(int[] key2) {
        switch (key2.length) {
            case 1: {
                return key2[0];
            }
            case 2: {
                return key2[0] + key2[1];
            }
            case 3: {
                return key2[0] + key2[1] + key2[2];
            }
            case 4: {
                return key2[0] + key2[1] + key2[2] + key2[3];
            }
        }
        int h = 0;
        for (int i2 = 0; i2 < key2.length; ++i2) {
            h += key2[i2];
        }
        return h;
    }

    public V put(int[] key2, V value2) {
        this.checkResize();
        int hash2 = IntArrayHash.hashValue(this.hashCode(key2));
        int i2 = IntArrayHash.bucketIndex(hash2, this.table.length);
        IntArrayHashEntry entry = (IntArrayHashEntry)this.table[i2];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(key2)) {
                entry.value = value2;
                return value2;
            }
            entry = (IntArrayHashEntry)entry.next;
        }
        this.table[i2] = new IntArrayHashEntry<V>(hash2, this.table[i2], value2, key2, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(int[] key2, V value2) {
        this.checkResize();
        int hash2 = IntArrayHash.hashValue(this.hashCode(key2));
        int i2 = IntArrayHash.bucketIndex(hash2, this.table.length);
        this.table[i2] = new IntArrayHashEntry<V>(hash2, this.table[i2], value2, key2, this.head);
        ++this.size;
    }

    public V get(int ... key2) {
        int hash2 = IntArrayHash.hashValue(this.hashCode(key2));
        IntArrayHashEntry entry = (IntArrayHashEntry)this.table[IntArrayHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(key2)) {
                return (V)entry.value;
            }
            entry = (IntArrayHashEntry)entry.next;
        }
        return null;
    }

    public V delete(int ... key2) {
        int hash2 = IntArrayHash.hashValue(this.hashCode(key2));
        int i2 = IntArrayHash.bucketIndex(hash2, this.table.length);
        IntArrayHashEntry entry = (IntArrayHashEntry)this.table[i2];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash2 && entry.equals(key2)) {
            this.table[i2] = entry.next;
            --this.size;
            entry.remove();
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.HashEntry tmp = entry.next;
            if (tmp.hash == hash2 && entry.equals(key2)) {
                entry.next = entry.next.next;
                --this.size;
                tmp.remove();
                return tmp.value;
            }
            entry = (IntArrayHashEntry)entry.next;
        }
        return null;
    }

    public static final class IntArrayHashEntry<V>
    extends Hash.HashEntry<V> {
        public final int[] key;

        public IntArrayHashEntry(int hash2, Hash.HashEntry<V> next, V value2, int[] key2, Hash.HashEntry<V> head) {
            super(hash2, next, value2, head);
            this.key = key2;
        }

        public IntArrayHashEntry() {
            this.key = null;
        }

        public boolean equals(int[] key2) {
            if (this.key == key2) {
                return true;
            }
            if (this.key.length != key2.length) {
                return false;
            }
            switch (key2.length) {
                case 1: {
                    return this.key[0] == key2[0];
                }
                case 2: {
                    return this.key[0] == key2[0] && this.key[1] == key2[1];
                }
                case 3: {
                    return this.key[0] == key2[0] && this.key[1] == key2[1] && this.key[2] == key2[2];
                }
                case 4: {
                    return this.key[0] == key2[0] && this.key[1] == key2[1] && this.key[2] == key2[2] && this.key[3] == key2[3];
                }
            }
            for (int i2 = 0; i2 < key2.length; ++i2) {
                if (this.key[i2] == key2[i2]) continue;
                return false;
            }
            return true;
        }
    }
}

