/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.binary.StringUtils;

public final class MurmurHash3 {
    @Deprecated
    public static final long NULL_HASHCODE = 2862933555777941757L;
    public static final int DEFAULT_SEED = 104729;
    private static final int C1_32 = -862048943;
    private static final int C2_32 = 461845907;
    private static final int R1_32 = 15;
    private static final int R2_32 = 13;
    private static final int M_32 = 5;
    private static final int N_32 = -430675100;
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final int R1 = 31;
    private static final int R2 = 27;
    private static final int R3 = 33;
    private static final int M = 5;
    private static final int N1 = 1390208809;
    private static final int N2 = 944331445;

    private static int fmix32(int hash2) {
        hash2 ^= hash2 >>> 16;
        hash2 *= -2048144789;
        hash2 ^= hash2 >>> 13;
        hash2 *= -1028477387;
        hash2 ^= hash2 >>> 16;
        return hash2;
    }

    private static long fmix64(long hash2) {
        hash2 ^= hash2 >>> 33;
        hash2 *= -49064778989728563L;
        hash2 ^= hash2 >>> 33;
        hash2 *= -4265267296055464877L;
        hash2 ^= hash2 >>> 33;
        return hash2;
    }

    private static int getLittleEndianInt(byte[] data2, int index2) {
        return data2[index2] & 0xFF | (data2[index2 + 1] & 0xFF) << 8 | (data2[index2 + 2] & 0xFF) << 16 | (data2[index2 + 3] & 0xFF) << 24;
    }

    private static long getLittleEndianLong(byte[] data2, int index2) {
        return (long)data2[index2] & 0xFFL | ((long)data2[index2 + 1] & 0xFFL) << 8 | ((long)data2[index2 + 2] & 0xFFL) << 16 | ((long)data2[index2 + 3] & 0xFFL) << 24 | ((long)data2[index2 + 4] & 0xFFL) << 32 | ((long)data2[index2 + 5] & 0xFFL) << 40 | ((long)data2[index2 + 6] & 0xFFL) << 48 | ((long)data2[index2 + 7] & 0xFFL) << 56;
    }

    public static long[] hash128(byte[] data2) {
        return MurmurHash3.hash128(data2, 0, data2.length, 104729);
    }

    @Deprecated
    public static long[] hash128(byte[] data2, int offset2, int length2, int seed2) {
        return MurmurHash3.hash128x64Internal(data2, offset2, length2, seed2);
    }

    @Deprecated
    public static long[] hash128(String data2) {
        byte[] bytes2 = StringUtils.getBytesUtf8(data2);
        return MurmurHash3.hash128(bytes2, 0, bytes2.length, 104729);
    }

    public static long[] hash128x64(byte[] data2) {
        return MurmurHash3.hash128x64(data2, 0, data2.length, 0);
    }

    public static long[] hash128x64(byte[] data2, int offset2, int length2, int seed2) {
        return MurmurHash3.hash128x64Internal(data2, offset2, length2, (long)seed2 & 0xFFFFFFFFL);
    }

    private static long[] hash128x64Internal(byte[] data2, int offset2, int length2, long seed2) {
        long h1 = seed2;
        long h2 = seed2;
        int nblocks = length2 >> 4;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            int index2 = offset2 + (i2 << 4);
            long k1 = MurmurHash3.getLittleEndianLong(data2, index2);
            long k2 = MurmurHash3.getLittleEndianLong(data2, index2 + 8);
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        int index3 = offset2 + (nblocks << 4);
        switch (offset2 + length2 - index3) {
            case 15: {
                k2 ^= ((long)data2[index3 + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)data2[index3 + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)data2[index3 + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)data2[index3 + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)data2[index3 + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)data2[index3 + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= (long)(data2[index3 + 8] & 0xFF);
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= ((long)data2[index3 + 7] & 0xFFL) << 56;
            }
            case 7: {
                k1 ^= ((long)data2[index3 + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)data2[index3 + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)data2[index3 + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)data2[index3 + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)data2[index3 + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)data2[index3 + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)(data2[index3] & 0xFF);
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)length2;
        h1 += (h2 ^= (long)length2);
        h2 += h1;
        h1 = MurmurHash3.fmix64(h1);
        h2 = MurmurHash3.fmix64(h2);
        h1 += h2;
        return new long[]{h1, h2 += h1};
    }

    @Deprecated
    public static int hash32(byte[] data2) {
        return MurmurHash3.hash32(data2, 0, data2.length, 104729);
    }

    @Deprecated
    public static int hash32(byte[] data2, int length2) {
        return MurmurHash3.hash32(data2, length2, 104729);
    }

    @Deprecated
    public static int hash32(byte[] data2, int length2, int seed2) {
        return MurmurHash3.hash32(data2, 0, length2, seed2);
    }

    @Deprecated
    public static int hash32(byte[] data2, int offset2, int length2, int seed2) {
        int hash2 = seed2;
        int nblocks = length2 >> 2;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            int index2 = offset2 + (i2 << 2);
            int k = MurmurHash3.getLittleEndianInt(data2, index2);
            hash2 = MurmurHash3.mix32(k, hash2);
        }
        int index3 = offset2 + (nblocks << 2);
        int k1 = 0;
        switch (offset2 + length2 - index3) {
            case 3: {
                k1 ^= data2[index3 + 2] << 16;
            }
            case 2: {
                k1 ^= data2[index3 + 1] << 8;
            }
            case 1: {
                k1 ^= data2[index3];
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                hash2 ^= (k1 *= 461845907);
            }
        }
        return MurmurHash3.fmix32(hash2 ^= length2);
    }

    public static int hash32(long data2) {
        return MurmurHash3.hash32(data2, 104729);
    }

    public static int hash32(long data2, int seed2) {
        int hash2 = seed2;
        long r0 = Long.reverseBytes(data2);
        hash2 = MurmurHash3.mix32((int)r0, hash2);
        hash2 = MurmurHash3.mix32((int)(r0 >>> 32), hash2);
        return MurmurHash3.fmix32(hash2 ^= 8);
    }

    public static int hash32(long data1, long data2) {
        return MurmurHash3.hash32(data1, data2, 104729);
    }

    public static int hash32(long data1, long data2, int seed2) {
        int hash2 = seed2;
        long r0 = Long.reverseBytes(data1);
        long r1 = Long.reverseBytes(data2);
        hash2 = MurmurHash3.mix32((int)r0, hash2);
        hash2 = MurmurHash3.mix32((int)(r0 >>> 32), hash2);
        hash2 = MurmurHash3.mix32((int)r1, hash2);
        hash2 = MurmurHash3.mix32((int)(r1 >>> 32), hash2);
        return MurmurHash3.fmix32(hash2 ^= 0x10);
    }

    @Deprecated
    public static int hash32(String data2) {
        byte[] bytes2 = StringUtils.getBytesUtf8(data2);
        return MurmurHash3.hash32(bytes2, 0, bytes2.length, 104729);
    }

    public static int hash32x86(byte[] data2) {
        return MurmurHash3.hash32x86(data2, 0, data2.length, 0);
    }

    public static int hash32x86(byte[] data2, int offset2, int length2, int seed2) {
        int hash2 = seed2;
        int nblocks = length2 >> 2;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            int index2 = offset2 + (i2 << 2);
            int k = MurmurHash3.getLittleEndianInt(data2, index2);
            hash2 = MurmurHash3.mix32(k, hash2);
        }
        int index3 = offset2 + (nblocks << 2);
        int k1 = 0;
        switch (offset2 + length2 - index3) {
            case 3: {
                k1 ^= (data2[index3 + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 ^= (data2[index3 + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 ^= data2[index3] & 0xFF;
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                hash2 ^= (k1 *= 461845907);
            }
        }
        return MurmurHash3.fmix32(hash2 ^= length2);
    }

    @Deprecated
    public static long hash64(byte[] data2) {
        return MurmurHash3.hash64(data2, 0, data2.length, 104729);
    }

    @Deprecated
    public static long hash64(byte[] data2, int offset2, int length2) {
        return MurmurHash3.hash64(data2, offset2, length2, 104729);
    }

    @Deprecated
    public static long hash64(byte[] data2, int offset2, int length2, int seed2) {
        long hash2 = seed2;
        int nblocks = length2 >> 3;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            int index2 = offset2 + (i2 << 3);
            long k = MurmurHash3.getLittleEndianLong(data2, index2);
            k *= -8663945395140668459L;
            k = Long.rotateLeft(k, 31);
            hash2 ^= (k *= 5545529020109919103L);
            hash2 = Long.rotateLeft(hash2, 27) * 5L + 1390208809L;
        }
        long k1 = 0L;
        int index3 = offset2 + (nblocks << 3);
        switch (offset2 + length2 - index3) {
            case 7: {
                k1 ^= ((long)data2[index3 + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)data2[index3 + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)data2[index3 + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)data2[index3 + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)data2[index3 + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)data2[index3 + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)data2[index3] & 0xFFL;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                hash2 ^= (k1 *= 5545529020109919103L);
            }
        }
        return MurmurHash3.fmix64(hash2 ^= (long)length2);
    }

    @Deprecated
    public static long hash64(int data2) {
        long k1 = (long)Integer.reverseBytes(data2) & 0xFFFFFFFFL;
        long hash2 = 104729L;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        hash2 ^= (k1 *= 5545529020109919103L);
        return MurmurHash3.fmix64(hash2 ^= 4L);
    }

    @Deprecated
    public static long hash64(long data2) {
        long hash2 = 104729L;
        long k = Long.reverseBytes(data2);
        k *= -8663945395140668459L;
        k = Long.rotateLeft(k, 31);
        hash2 ^= (k *= 5545529020109919103L);
        hash2 = Long.rotateLeft(hash2, 27) * 5L + 1390208809L;
        return MurmurHash3.fmix64(hash2 ^= 8L);
    }

    @Deprecated
    public static long hash64(short data2) {
        long hash2 = 104729L;
        long k1 = 0L;
        k1 ^= ((long)data2 & 0xFFL) << 8;
        k1 ^= (long)((data2 & 0xFF00) >> 8) & 0xFFL;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        hash2 ^= (k1 *= 5545529020109919103L);
        return MurmurHash3.fmix64(hash2 ^= 2L);
    }

    private static int mix32(int k, int hash2) {
        k *= -862048943;
        k = Integer.rotateLeft(k, 15);
        return Integer.rotateLeft(hash2 ^= (k *= 461845907), 13) * 5 + -430675100;
    }

    private MurmurHash3() {
    }

    public static class IncrementalHash32x86 {
        private static final int BLOCK_SIZE = 4;
        private final byte[] unprocessed = new byte[3];
        private int unprocessedLength;
        private int totalLen;
        private int hash;

        private static int orBytes(byte b1, byte b2, byte b3, byte b4) {
            return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
        }

        public final void add(byte[] data2, int offset2, int length2) {
            int newLength;
            int newOffset;
            int consumed;
            if (length2 <= 0) {
                return;
            }
            this.totalLen += length2;
            if (this.unprocessedLength + length2 - 4 < 0) {
                System.arraycopy(data2, offset2, this.unprocessed, this.unprocessedLength, length2);
                this.unprocessedLength += length2;
                return;
            }
            if (this.unprocessedLength > 0) {
                int k = -1;
                switch (this.unprocessedLength) {
                    case 1: {
                        k = IncrementalHash32x86.orBytes(this.unprocessed[0], data2[offset2], data2[offset2 + 1], data2[offset2 + 2]);
                        break;
                    }
                    case 2: {
                        k = IncrementalHash32x86.orBytes(this.unprocessed[0], this.unprocessed[1], data2[offset2], data2[offset2 + 1]);
                        break;
                    }
                    case 3: {
                        k = IncrementalHash32x86.orBytes(this.unprocessed[0], this.unprocessed[1], this.unprocessed[2], data2[offset2]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unprocessed length should be 1, 2, or 3: " + this.unprocessedLength);
                    }
                }
                this.hash = MurmurHash3.mix32(k, this.hash);
                consumed = 4 - this.unprocessedLength;
                newOffset = offset2 + consumed;
                newLength = length2 - consumed;
            } else {
                newOffset = offset2;
                newLength = length2;
            }
            int nblocks = newLength >> 2;
            for (int i2 = 0; i2 < nblocks; ++i2) {
                int index2 = newOffset + (i2 << 2);
                int k = MurmurHash3.getLittleEndianInt(data2, index2);
                this.hash = MurmurHash3.mix32(k, this.hash);
            }
            consumed = nblocks << 2;
            this.unprocessedLength = newLength - consumed;
            if (this.unprocessedLength != 0) {
                System.arraycopy(data2, newOffset + consumed, this.unprocessed, 0, this.unprocessedLength);
            }
        }

        public final int end() {
            return this.finalise(this.hash, this.unprocessedLength, this.unprocessed, this.totalLen);
        }

        int finalise(int hash2, int unprocessedLength, byte[] unprocessed, int totalLen) {
            int result2 = hash2;
            int k1 = 0;
            switch (unprocessedLength) {
                case 3: {
                    k1 ^= (unprocessed[2] & 0xFF) << 16;
                }
                case 2: {
                    k1 ^= (unprocessed[1] & 0xFF) << 8;
                }
                case 1: {
                    k1 ^= unprocessed[0] & 0xFF;
                    k1 *= -862048943;
                    k1 = Integer.rotateLeft(k1, 15);
                    result2 ^= (k1 *= 461845907);
                }
            }
            return MurmurHash3.fmix32(result2 ^= totalLen);
        }

        public final void start(int seed2) {
            this.totalLen = 0;
            this.unprocessedLength = 0;
            this.hash = seed2;
        }
    }

    @Deprecated
    public static class IncrementalHash32
    extends IncrementalHash32x86 {
        @Override
        @Deprecated
        int finalise(int hash2, int unprocessedLength, byte[] unprocessed, int totalLen) {
            int result2 = hash2;
            int k1 = 0;
            switch (unprocessedLength) {
                case 3: {
                    k1 ^= unprocessed[2] << 16;
                }
                case 2: {
                    k1 ^= unprocessed[1] << 8;
                }
                case 1: {
                    k1 ^= unprocessed[0];
                    k1 *= -862048943;
                    k1 = Integer.rotateLeft(k1, 15);
                    result2 ^= (k1 *= 461845907);
                }
            }
            return MurmurHash3.fmix32(result2 ^= totalLen);
        }
    }
}

