/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.util.Arrays;
import java.util.Objects;

public final class Blake3 {
    private static final int BLOCK_LEN = 64;
    private static final int BLOCK_INTS = 16;
    private static final int KEY_LEN = 32;
    private static final int KEY_INTS = 8;
    private static final int OUT_LEN = 32;
    private static final int CHUNK_LEN = 1024;
    private static final int CHAINING_VALUE_INTS = 8;
    private static final int[] IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int CHUNK_START = 1;
    private static final int CHUNK_END = 2;
    private static final int PARENT = 4;
    private static final int ROOT = 8;
    private static final int KEYED_HASH = 16;
    private static final int DERIVE_KEY_CONTEXT = 32;
    private static final int DERIVE_KEY_MATERIAL = 64;
    private static final byte[][] MSG_SCHEDULE = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {2, 6, 3, 10, 7, 0, 4, 13, 1, 11, 12, 5, 9, 14, 15, 8}, {3, 4, 10, 12, 13, 2, 7, 14, 6, 5, 9, 0, 11, 15, 8, 1}, {10, 7, 12, 9, 14, 3, 13, 15, 4, 0, 11, 2, 5, 8, 1, 6}, {12, 13, 9, 11, 15, 10, 14, 8, 7, 2, 5, 3, 0, 1, 6, 4}, {9, 14, 11, 5, 8, 12, 15, 1, 13, 3, 0, 10, 2, 6, 4, 7}, {11, 15, 5, 0, 1, 9, 8, 6, 14, 10, 2, 12, 3, 4, 7, 13}};
    private final EngineState engineState;

    private static void checkBufferArgs(byte[] buffer, int offset2, int length2) {
        Objects.requireNonNull(buffer);
        if (offset2 < 0) {
            throw new IndexOutOfBoundsException("Offset must be non-negative");
        }
        if (length2 < 0) {
            throw new IndexOutOfBoundsException("Length must be non-negative");
        }
        int bufferLength = buffer.length;
        if (offset2 > bufferLength - length2) {
            throw new IndexOutOfBoundsException("Offset " + offset2 + " and length " + length2 + " out of bounds with buffer length " + bufferLength);
        }
    }

    private static int[] compress(int[] chainingValue, int[] blockWords, int blockLength, long counter, int flags2) {
        int i2;
        int[] state2 = Arrays.copyOf(chainingValue, 16);
        System.arraycopy(IV, 0, state2, 8, 4);
        state2[12] = (int)counter;
        state2[13] = (int)(counter >> 32);
        state2[14] = blockLength;
        state2[15] = flags2;
        for (i2 = 0; i2 < 7; ++i2) {
            byte[] schedule2 = MSG_SCHEDULE[i2];
            Blake3.round(state2, blockWords, schedule2);
        }
        for (i2 = 0; i2 < state2.length / 2; ++i2) {
            int n = i2;
            state2[n] = state2[n] ^ state2[i2 + 8];
            int n2 = i2 + 8;
            state2[n2] = state2[n2] ^ chainingValue[i2];
        }
        return state2;
    }

    private static void g(int[] state2, int a, int b2, int c, int d, int mx, int my) {
        int n = a;
        state2[n] = state2[n] + (state2[b2] + mx);
        state2[d] = Integer.rotateRight(state2[d] ^ state2[a], 16);
        int n2 = c;
        state2[n2] = state2[n2] + state2[d];
        state2[b2] = Integer.rotateRight(state2[b2] ^ state2[c], 12);
        int n3 = a;
        state2[n3] = state2[n3] + (state2[b2] + my);
        state2[d] = Integer.rotateRight(state2[d] ^ state2[a], 8);
        int n4 = c;
        state2[n4] = state2[n4] + state2[d];
        state2[b2] = Integer.rotateRight(state2[b2] ^ state2[c], 7);
    }

    public static byte[] hash(byte[] data2) {
        return Blake3.initHash().update(data2).doFinalize(32);
    }

    public static Blake3 initHash() {
        return new Blake3(IV, 0);
    }

    public static Blake3 initKeyDerivationFunction(byte[] kdfContext) {
        Objects.requireNonNull(kdfContext);
        EngineState kdf = new EngineState(IV, 32);
        kdf.inputData(kdfContext, 0, kdfContext.length);
        byte[] key2 = new byte[32];
        kdf.outputHash(key2, 0, key2.length);
        return new Blake3(Blake3.unpackInts(key2, 8), 64);
    }

    public static Blake3 initKeyedHash(byte[] key2) {
        Objects.requireNonNull(key2);
        if (key2.length != 32) {
            throw new IllegalArgumentException("Blake3 keys must be 32 bytes");
        }
        return new Blake3(Blake3.unpackInts(key2, 8), 16);
    }

    public static byte[] keyedHash(byte[] key2, byte[] data2) {
        return Blake3.initKeyedHash(key2).update(data2).doFinalize(32);
    }

    private static void packInt(int value2, byte[] dst, int off, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = (byte)(value2 >>> i2 * 8);
        }
    }

    private static int[] parentChainingValue(int[] leftChildCV, int[] rightChildCV, int[] key2, int flags2) {
        return Blake3.parentOutput(leftChildCV, rightChildCV, key2, flags2).chainingValue();
    }

    private static Output parentOutput(int[] leftChildCV, int[] rightChildCV, int[] key2, int flags2) {
        int[] blockWords = Arrays.copyOf(leftChildCV, 16);
        System.arraycopy(rightChildCV, 0, blockWords, 8, 8);
        return new Output((int[])key2.clone(), blockWords, 0L, 64, flags2 | 4);
    }

    private static void round(int[] state2, int[] msg, byte[] schedule2) {
        Blake3.g(state2, 0, 4, 8, 12, msg[schedule2[0]], msg[schedule2[1]]);
        Blake3.g(state2, 1, 5, 9, 13, msg[schedule2[2]], msg[schedule2[3]]);
        Blake3.g(state2, 2, 6, 10, 14, msg[schedule2[4]], msg[schedule2[5]]);
        Blake3.g(state2, 3, 7, 11, 15, msg[schedule2[6]], msg[schedule2[7]]);
        Blake3.g(state2, 0, 5, 10, 15, msg[schedule2[8]], msg[schedule2[9]]);
        Blake3.g(state2, 1, 6, 11, 12, msg[schedule2[10]], msg[schedule2[11]]);
        Blake3.g(state2, 2, 7, 8, 13, msg[schedule2[12]], msg[schedule2[13]]);
        Blake3.g(state2, 3, 4, 9, 14, msg[schedule2[14]], msg[schedule2[15]]);
    }

    private static int unpackInt(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 3] & 0xFF) << 24;
    }

    private static int[] unpackInts(byte[] buf, int nrInts) {
        int[] values2 = new int[nrInts];
        int i2 = 0;
        int off = 0;
        while (i2 < nrInts) {
            values2[i2] = Blake3.unpackInt(buf, off);
            ++i2;
            off += 4;
        }
        return values2;
    }

    private Blake3(int[] key2, int flags2) {
        this.engineState = new EngineState(key2, flags2);
    }

    public Blake3 doFinalize(byte[] out) {
        return this.doFinalize(out, 0, out.length);
    }

    public Blake3 doFinalize(byte[] out, int offset2, int length2) {
        Blake3.checkBufferArgs(out, offset2, length2);
        this.engineState.outputHash(out, offset2, length2);
        return this;
    }

    public byte[] doFinalize(int nrBytes) {
        if (nrBytes < 0) {
            throw new IllegalArgumentException("Requested bytes must be non-negative");
        }
        byte[] hash2 = new byte[nrBytes];
        this.doFinalize(hash2);
        return hash2;
    }

    public Blake3 reset() {
        this.engineState.reset();
        return this;
    }

    public Blake3 update(byte[] in) {
        return this.update(in, 0, in.length);
    }

    public Blake3 update(byte[] in, int offset2, int length2) {
        Blake3.checkBufferArgs(in, offset2, length2);
        this.engineState.inputData(in, offset2, length2);
        return this;
    }

    private static final class Output {
        private final int[] inputChainingValue;
        private final int[] blockWords;
        private final long counter;
        private final int blockLength;
        private final int flags;

        private Output(int[] inputChainingValue, int[] blockWords, long counter, int blockLength, int flags2) {
            this.inputChainingValue = inputChainingValue;
            this.blockWords = blockWords;
            this.counter = counter;
            this.blockLength = blockLength;
            this.flags = flags2;
        }

        private int[] chainingValue() {
            return Arrays.copyOf(Blake3.compress(this.inputChainingValue, this.blockWords, this.blockLength, this.counter, this.flags), 8);
        }

        private void rootOutputBytes(byte[] out, int offset2, int length2) {
            int outputBlockCounter = 0;
            while (length2 > 0) {
                int chunkLength = Math.min(64, length2);
                length2 -= chunkLength;
                int[] words = Blake3.compress(this.inputChainingValue, this.blockWords, this.blockLength, outputBlockCounter++, this.flags | 8);
                int wordCounter = 0;
                while (chunkLength > 0) {
                    int wordLength = Math.min(4, chunkLength);
                    Blake3.packInt(words[wordCounter++], out, offset2, wordLength);
                    offset2 += wordLength;
                    chunkLength -= wordLength;
                }
            }
        }
    }

    private static final class EngineState {
        private final int[] key;
        private final int flags;
        private final int[][] cvStack = new int[54][];
        private int stackLen;
        private ChunkState state;

        private EngineState(int[] key2, int flags2) {
            this.key = key2;
            this.flags = flags2;
            this.state = new ChunkState(key2, 0L, flags2);
        }

        private void addChunkCV(int[] firstCV, long totalChunks) {
            int[] newCV = firstCV;
            long chunkCounter = totalChunks;
            while ((chunkCounter & 1L) == 0L) {
                newCV = Blake3.parentChainingValue(this.popCV(), newCV, this.key, this.flags);
                chunkCounter >>= 1;
            }
            this.pushCV(newCV);
        }

        private void inputData(byte[] in, int offset2, int length2) {
            while (length2 > 0) {
                if (this.state.length() == 1024) {
                    int[] chunkCV = this.state.output().chainingValue();
                    long totalChunks = this.state.chunkCounter + 1L;
                    this.addChunkCV(chunkCV, totalChunks);
                    this.state = new ChunkState(this.key, totalChunks, this.flags);
                }
                int want = 1024 - this.state.length();
                int take2 = Math.min(want, length2);
                this.state.update(in, offset2, take2);
                offset2 += take2;
                length2 -= take2;
            }
        }

        private void outputHash(byte[] out, int offset2, int length2) {
            Output output = this.state.output();
            int parentNodesRemaining = this.stackLen;
            while (parentNodesRemaining-- > 0) {
                int[] parentCV = this.cvStack[parentNodesRemaining];
                output = Blake3.parentOutput(parentCV, output.chainingValue(), this.key, this.flags);
            }
            output.rootOutputBytes(out, offset2, length2);
        }

        private int[] popCV() {
            return this.cvStack[--this.stackLen];
        }

        private void pushCV(int[] cv) {
            this.cvStack[this.stackLen++] = cv;
        }

        private void reset() {
            this.stackLen = 0;
            Arrays.fill((Object[])this.cvStack, null);
            this.state = new ChunkState(this.key, 0L, this.flags);
        }
    }

    private static final class ChunkState {
        private int[] chainingValue;
        private final long chunkCounter;
        private final int flags;
        private final byte[] block = new byte[64];
        private int blockLength;
        private int blocksCompressed;

        private ChunkState(int[] key2, long chunkCounter, int flags2) {
            this.chainingValue = key2;
            this.chunkCounter = chunkCounter;
            this.flags = flags2;
        }

        private int length() {
            return 64 * this.blocksCompressed + this.blockLength;
        }

        private Output output() {
            int[] blockWords = Blake3.unpackInts(this.block, 16);
            int outputFlags = this.flags | this.startFlag() | 2;
            return new Output(this.chainingValue, blockWords, this.chunkCounter, this.blockLength, outputFlags);
        }

        private int startFlag() {
            return this.blocksCompressed == 0 ? 1 : 0;
        }

        private void update(byte[] input, int offset2, int length2) {
            while (length2 > 0) {
                if (this.blockLength == 64) {
                    int[] blockWords = Blake3.unpackInts(this.block, 16);
                    this.chainingValue = Arrays.copyOf(Blake3.compress(this.chainingValue, blockWords, 64, this.chunkCounter, this.flags | this.startFlag()), 8);
                    ++this.blocksCompressed;
                    this.blockLength = 0;
                    Arrays.fill(this.block, (byte)0);
                }
                int want = 64 - this.blockLength;
                int take2 = Math.min(want, length2);
                System.arraycopy(input, offset2, this.block, this.blockLength, take2);
                this.blockLength += take2;
                offset2 += take2;
                length2 -= take2;
            }
        }
    }
}

