/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.json;

import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.JsonWriter;
import java.io.IOException;

class JsonNumber
extends JsonValue {
    private final String string;

    JsonNumber(String string2) {
        if (string2 == null) {
            throw new NullPointerException("string is null");
        }
        this.string = string2;
    }

    public String toString() {
        return this.string;
    }

    void write(JsonWriter writer) throws IOException {
        writer.writeNumber(this.string);
    }

    public boolean isNumber() {
        return true;
    }

    public int asInt() {
        return Integer.parseInt(this.string, 10);
    }

    public long asLong() {
        return Long.parseLong(this.string, 10);
    }

    public float asFloat() {
        return Float.parseFloat(this.string);
    }

    public double asDouble() {
        return Double.parseDouble(this.string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonNumber other = (JsonNumber)object;
        return this.string.equals(other.string);
    }
}

