/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.semantic.Type;

public class HappyPathYield
extends MethodYield {
    private int resultIndex = -1;
    @Nullable
    private ConstraintsByDomain resultConstraint = null;

    public HappyPathYield(MethodBehavior behavior) {
        super(behavior);
    }

    public HappyPathYield(ExplodedGraph.Node node, MethodBehavior behavior) {
        super(node, behavior);
    }

    @Override
    public Stream<ProgramState> statesAfterInvocation(List<SymbolicValue> invocationArguments, List<Type> invocationTypes, ProgramState programState, Supplier<SymbolicValue> svSupplier) {
        Stream<ProgramState> results = this.parametersAfterInvocation(invocationArguments, invocationTypes, programState);
        SymbolicValue sv = this.resultIndex < 0 || this.resultIndex == invocationArguments.size() ? svSupplier.get() : invocationArguments.get(this.resultIndex);
        if (sv != null) {
            results = results.map(s -> s.stackValue(sv));
            if (this.resultConstraint != null) {
                results = results.map(s -> s.addConstraints(sv, this.resultConstraint));
            }
        }
        return results.distinct();
    }

    public void setResult(int resultIndex, @Nullable ConstraintsByDomain resultConstraint) {
        this.resultIndex = resultIndex;
        this.resultConstraint = resultConstraint;
    }

    @CheckForNull
    public ConstraintsByDomain resultConstraint() {
        return this.resultConstraint;
    }

    public int resultIndex() {
        return this.resultIndex;
    }

    @Override
    public String toString() {
        return String.format("{params: %s, result: %s (%d)}", this.parametersConstraints.stream().map(constraints -> constraints.stream().map((Function<Constraint, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/sonar/java/se/constraint/Constraint;)Ljava/lang/String;)()).toList()).toList(), this.resultConstraint, this.resultIndex);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(5, 1293).appendSuper(super.hashCode()).append(this.resultIndex).append(this.resultConstraint).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HappyPathYield other = (HappyPathYield)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.resultIndex, other.resultIndex).append(this.resultConstraint, other.resultConstraint).isEquals();
    }
}

