/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.plugin.JavaSECheckList;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

@ServerSide
@ScannerSide
@ComputeEngineSide
public class JavaSECheckRegistrar
implements CheckRegistrar {
    private static final String RESOURCE_BASE_PATH = "org/sonar/l10n/java/rules/javase";
    static final String SONAR_WAY_PATH = "org/sonar/l10n/java/rules/javase/Sonar_way_profile.json";
    public static final String REPOSITORY_KEY = "java";
    private static final Set<String> RULE_TEMPLATES_KEY = Set.of("S3546");
    private final SonarRuntime runtime;

    public JavaSECheckRegistrar(SonarRuntime runtime) {
        this.runtime = runtime;
    }

    public void register(CheckRegistrar.RegistrarContext registrarContext) {
    }

    public void register(CheckRegistrar.RegistrarContext registrarContext, CheckFactory checkFactory) {
        Checks checks = checkFactory.create(REPOSITORY_KEY).addAnnotatedChecks(JavaSECheckList.getChecks());
        List<SECheck> seChecks = checks.all().stream().filter(SECheck.class::isInstance).map(c -> (SECheck)c).toList();
        List<RuleKey> ruleKeys = seChecks.stream().map(arg_0 -> ((Checks)checks).ruleKey(arg_0)).toList();
        registrarContext.registerMainSharedCheck((JavaCheck)new SymbolicExecutionVisitor(seChecks), ruleKeys);
        registrarContext.registerMainChecks(checks, seChecks);
    }

    public void customRulesDefinition(RulesDefinition.Context context, RulesDefinition.NewRepository javaRepository) {
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(RESOURCE_BASE_PATH, SONAR_WAY_PATH, this.runtime);
        ruleMetadataLoader.addRulesByAnnotatedClass(javaRepository, new ArrayList(JavaSECheckList.getChecks()));
        JavaSECheckRegistrar.setTemplates(javaRepository);
    }

    private static void setTemplates(RulesDefinition.NewRepository repository) {
        RULE_TEMPLATES_KEY.forEach(ruleKey -> repository.rule(ruleKey).setTemplate(true));
    }
}

