/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import org.sonar.java.model.SEExpressionUtils;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SyntaxTreeNameFinder
extends BaseTreeVisitor {
    private String name;

    public static String getName(Tree syntaxNode) {
        SyntaxTreeNameFinder finder = new SyntaxTreeNameFinder();
        syntaxNode.accept((TreeVisitor)finder);
        return finder.getName();
    }

    private String getName() {
        return this.name;
    }

    public void visitIdentifier(IdentifierTree tree) {
        this.name = tree.name();
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        String identifierName;
        ExpressionTree expression = SEExpressionUtils.skipParentheses(tree.expression());
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ("this".equals(identifierName = ((IdentifierTree)expression).name()) || "super".equals(identifierName))) {
            tree.identifier().accept((TreeVisitor)this);
            return;
        }
        expression.accept((TreeVisitor)this);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        tree.expression().accept((TreeVisitor)this);
    }

    public void visitParenthesized(ParenthesizedTree tree) {
        tree.expression().accept((TreeVisitor)this);
    }

    public void visitTypeCast(TypeCastTree tree) {
        tree.expression().accept((TreeVisitor)this);
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.name = ((MemberSelectExpressionTree)methodSelect).identifier().name();
        } else {
            methodSelect.accept((TreeVisitor)this);
        }
    }

    public void visitVariable(VariableTree tree) {
        if (tree.initializer() == null) {
            this.name = tree.simpleName().name();
        } else {
            super.visitVariable(tree);
        }
    }
}

