/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.Flow;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.cfg.ControlFlowGraph;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class SECheck
implements JavaFileScanner {
    protected Set<SEIssue> issues = new HashSet<SEIssue>();

    public void init(MethodTree methodTree, ControlFlowGraph cfg) {
    }

    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        return context.getState();
    }

    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        return context.getState();
    }

    public void checkEndOfExecution(CheckerContext context) {
    }

    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
    }

    public void scanFile(JavaFileScannerContext context) {
        for (SEIssue seIssue : this.issues) {
            context.reportIssueWithFlow((JavaCheck)this, seIssue.getTree(), seIssue.getMessage(), seIssue.getFlows(), null);
        }
        this.issues.clear();
    }

    public void reportIssue(Tree tree, String message) {
        this.reportIssue(tree, message, Collections.emptySet());
    }

    public void reportIssue(Tree tree, String message, Set<Flow> flows) {
        this.issues.add(this.issues.stream().filter(seIssue -> seIssue.tree.equals((Object)tree)).findFirst().map(seIssue -> {
            seIssue.flows.addAll(flows);
            return seIssue;
        }).orElse(new SEIssue(tree, message, flows)));
    }

    public void interruptedExecution(CheckerContext context) {
    }

    protected static class SEIssue {
        private final Tree tree;
        private final String message;
        private final Set<Flow> flows;

        public SEIssue(Tree tree, String message, Set<Flow> flows) {
            this.tree = tree;
            this.message = message;
            this.flows = new HashSet<Flow>(flows);
        }

        public Tree getTree() {
            return this.tree;
        }

        public String getMessage() {
            return this.message;
        }

        public Set<List<JavaFileScannerContext.Location>> getFlows() {
            Set<List<JavaFileScannerContext.Location>> nonExceptionalFlows = this.flows.stream().filter(Flow::isNonExceptional).map(Flow::elements).collect(Collectors.toSet());
            if (!nonExceptionalFlows.isEmpty()) {
                return nonExceptionalFlows;
            }
            return this.flows.stream().map(Flow::elements).collect(Collectors.toSet());
        }
    }
}

