/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.cfg.ControlFlowGraph;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S4165")
public class RedundantAssignmentsCheck
extends SECheck {
    private static final Set<String> STREAM_TYPES = SetUtils.immutableSetOf("java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream");
    private final Deque<Map<AssignmentExpressionTree, List<AssignmentDataHolder>>> assignmentsByMethod = new LinkedList<Map<AssignmentExpressionTree, List<AssignmentDataHolder>>>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.assignmentsByMethod.clear();
        super.scanFile(context);
    }

    @Override
    public void init(MethodTree methodTree, ControlFlowGraph cfg) {
        this.assignmentsByMethod.push(new HashMap());
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.handleAssignment(context, (AssignmentExpressionTree)syntaxNode);
        }
        return super.checkPostStatement(context, syntaxNode);
    }

    private void handleAssignment(CheckerContext context, AssignmentExpressionTree assignmentExpressionTree) {
        Symbol assignedSymbol;
        ProgramState.SymbolicValueSymbol assignedVariable;
        block3: {
            block2: {
                assignedVariable = context.getState().peekValueSymbol();
                assignedSymbol = assignedVariable.symbol();
                if (assignedSymbol == null) break block2;
                if (!STREAM_TYPES.stream().anyMatch(arg_0 -> ((Type)assignedSymbol.type()).is(arg_0))) break block3;
            }
            return;
        }
        ExplodedGraph.Node node = context.getNode();
        ProgramState previousState = node.programState;
        SymbolicValue oldValue = previousState.getValue(assignedSymbol);
        SymbolicValue newValue = assignedVariable.symbolicValue();
        Symbol fromSymbol = previousState.peekValueSymbol().symbol();
        this.assignmentsByMethod.peek().computeIfAbsent(assignmentExpressionTree, k -> new ArrayList()).add(new AssignmentDataHolder(assignedSymbol, oldValue, newValue, fromSymbol, node));
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.assignmentsByMethod.pop();
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        for (Map.Entry<AssignmentExpressionTree, List<AssignmentDataHolder>> assignmentForTree : this.assignmentsByMethod.pop().entrySet()) {
            Collection allAssignments = assignmentForTree.getValue();
            if (!allAssignments.stream().allMatch(AssignmentDataHolder::isRedundant)) continue;
            Set<Flow> flows = allAssignments.stream().map(AssignmentDataHolder::flows).flatMap(Collection::stream).collect(Collectors.toSet());
            this.reportIssue((Tree)assignmentForTree.getKey(), String.format("Remove this useless assignment; \"%s\" already holds the assigned value along all execution paths.", ((AssignmentDataHolder)RedundantAssignmentsCheck.getFirst(allAssignments, null)).assignedSymbol.name()), flows);
        }
    }

    @Nullable
    public static <T> T getFirst(Iterable<T> iterable, @Nullable T defaultValue) {
        Iterator<T> iterator = iterable.iterator();
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    private static class AssignmentDataHolder {
        private final Symbol assignedSymbol;
        @Nullable
        private final Symbol fromSymbol;
        private final SymbolicValue oldValue;
        private final SymbolicValue newValue;
        private final ExplodedGraph.Node node;

        public AssignmentDataHolder(Symbol assignedSymbol, @Nullable SymbolicValue oldValue, SymbolicValue newValue, @Nullable Symbol fromSymbol, ExplodedGraph.Node node) {
            this.assignedSymbol = assignedSymbol;
            this.fromSymbol = fromSymbol;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.node = node;
        }

        public boolean isRedundant() {
            return this.oldValue == this.newValue;
        }

        public Set<Flow> flows() {
            return FlowComputation.flow(this.node, this.newValue, Collections.emptyList(), this.fromSymbol, 20);
        }
    }
}

