/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.Flow;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.cfg.ControlFlowGraph;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S3516")
public class InvariantReturnCheck
extends SECheck {
    private Deque<MethodInvariantContext> methodInvariantContexts = new LinkedList<MethodInvariantContext>();

    @Override
    public void init(MethodTree methodTree, ControlFlowGraph cfg) {
        this.methodInvariantContexts.push(new MethodInvariantContext(methodTree));
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        for (SECheck.SEIssue seIssue : this.issues) {
            context.reportIssueWithFlow((JavaCheck)this, seIssue.getTree(), seIssue.getMessage(), seIssue.getFlows(), Integer.valueOf(seIssue.getFlows().iterator().next().size()));
        }
        this.issues.clear();
        this.methodInvariantContexts.clear();
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        if (context.getState().exitingOnRuntimeException()) {
            return;
        }
        MethodInvariantContext methodInvariantContext = this.methodInvariantContexts.peek();
        if (!methodInvariantContext.methodToCheck) {
            return;
        }
        SymbolicValue exitValue = context.getState().exitValue();
        if (exitValue != null) {
            ++methodInvariantContext.endPaths;
            methodInvariantContext.symbolicValues.add(exitValue);
            ConstraintsByDomain constraints = context.getState().getConstraints(exitValue);
            if (constraints != null) {
                constraints.forEach((clazz, constraint) -> methodInvariantContext.methodConstraints.computeIfAbsent((Class<? extends Constraint>)clazz, k -> new ArrayList()).add(constraint));
            } else {
                methodInvariantContext.avoidRaisingConstraintIssue = true;
            }
        }
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        this.reportIssues();
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.methodInvariantContexts.pop();
    }

    private void reportIssues() {
        MethodInvariantContext methodInvariantContext = this.methodInvariantContexts.pop();
        if (!methodInvariantContext.methodToCheck) {
            return;
        }
        if (methodInvariantContext.returnImmutableType && methodInvariantContext.symbolicValues.size() == 1 && methodInvariantContext.endPaths > 1) {
            this.report(methodInvariantContext);
        } else if (!methodInvariantContext.avoidRaisingConstraintIssue) {
            for (Class<? extends Constraint> constraintClass : methodInvariantContext.methodConstraints.keySet()) {
                Collection constraints = methodInvariantContext.methodConstraints.get(constraintClass);
                Constraint firstConstraint = (Constraint)constraints.iterator().next();
                if (constraints.size() != methodInvariantContext.endPaths || !firstConstraint.hasPreciseValue()) continue;
                if (!constraints.stream().allMatch((Predicate<Constraint>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/sonar/java/se/constraint/Constraint;)Z)((Constraint)firstConstraint))) continue;
                this.report(methodInvariantContext);
                return;
            }
        }
    }

    private void report(MethodInvariantContext methodInvariantContext) {
        Flow.Builder flowBuilder = Flow.builder();
        methodInvariantContext.returnStatementTrees.stream().map(r -> new JavaFileScannerContext.Location("Returned value.", (Tree)r)).forEach(flowBuilder::add);
        this.reportIssue((Tree)methodInvariantContext.methodTree.simpleName(), "Refactor this method to not always return the same value.", Collections.singleton(flowBuilder.build()));
    }

    private static class MethodInvariantContext {
        private final MethodTree methodTree;
        private final Set<SymbolicValue> symbolicValues = new HashSet<SymbolicValue>();
        private final Map<Class<? extends Constraint>, List<Constraint>> methodConstraints = new HashMap<Class<? extends Constraint>, List<Constraint>>();
        private final List<ReturnStatementTree> returnStatementTrees;
        private final boolean methodToCheck;
        private final boolean returnImmutableType;
        private int endPaths = 0;
        private boolean avoidRaisingConstraintIssue;

        MethodInvariantContext(MethodTree methodTree) {
            this.methodTree = methodTree;
            TypeTree returnType = methodTree.returnType();
            this.returnStatementTrees = MethodInvariantContext.extractReturnStatements(methodTree);
            this.methodToCheck = !MethodInvariantContext.isConstructorOrVoid(methodTree, returnType) && this.returnStatementTrees.size() > 1;
            this.returnImmutableType = this.methodToCheck && (returnType.symbolType().isPrimitive() || returnType.symbolType().is("java.lang.String"));
        }

        private static boolean isConstructorOrVoid(MethodTree methodTree, @Nullable TypeTree returnType) {
            return methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) || returnType.symbolType().isVoid() || returnType.symbolType().is("java.lang.Void");
        }

        private static List<ReturnStatementTree> extractReturnStatements(MethodTree methodTree) {
            ReturnExtractor visitor = new ReturnExtractor();
            methodTree.accept((TreeVisitor)visitor);
            visitor.returns.sort(Comparator.comparing(returnStatement -> Position.startOf((SyntaxToken)returnStatement.returnKeyword())).reversed());
            return visitor.returns;
        }
    }

    private static class ReturnExtractor
    extends BaseTreeVisitor {
        List<ReturnStatementTree> returns = new ArrayList<ReturnStatementTree>();

        private ReturnExtractor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.returns.add(tree);
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }
}

