/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SymbolicExecutionVisitor
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolicExecutionVisitor.class);
    protected JavaFileScannerContext context;
    public final BehaviorCache behaviorCache;
    private final ExplodedGraphWalker.ExplodedGraphWalkerFactory egwFactory;

    public SymbolicExecutionVisitor(List<SECheck> seChecks) {
        this.egwFactory = new ExplodedGraphWalker.ExplodedGraphWalkerFactory(seChecks);
        this.behaviorCache = new BehaviorCache();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.behaviorCache.cleanup();
        this.behaviorCache.setFileContext(this);
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        this.execute(tree);
        super.visitMethod(tree);
    }

    public void execute(MethodTree methodTree) {
        block6: {
            ExplodedGraphWalker walker = this.getWalker();
            try {
                Symbol.MethodSymbol methodSymbol = methodTree.symbol();
                if (SymbolicExecutionVisitor.methodCanNotBeOverridden(methodSymbol)) {
                    MethodBehavior methodBehavior = this.behaviorCache.methodBehaviorForSymbol(methodSymbol);
                    if (!methodBehavior.isVisited()) {
                        walker.visitMethod(methodTree, methodBehavior);
                    }
                } else {
                    walker.visitMethod(methodTree);
                }
            }
            catch (ExplodedGraphWalker.ExplodedGraphTooBigException | ExplodedGraphWalker.MaximumStartingStatesException | ExplodedGraphWalker.MaximumStepsReachedException exception) {
                LOG.debug("Could not complete symbolic execution: {}", (Object)exception.getMessage());
                if (LOG.isTraceEnabled()) {
                    StringWriter sw = new StringWriter();
                    exception.printStackTrace(new PrintWriter(sw));
                    LOG.trace(sw.toString());
                }
                if (walker.methodBehavior == null) break block6;
                walker.methodBehavior.visited();
            }
        }
    }

    protected ExplodedGraphWalker getWalker() {
        return this.egwFactory.createWalker(this.behaviorCache, this.context);
    }

    public static boolean methodCanNotBeOverridden(Symbol.MethodSymbol methodSymbol) {
        if (methodSymbol.isNativeMethod()) {
            return false;
        }
        return !methodSymbol.isAbstract() && (methodSymbol.isPrivate() || methodSymbol.isFinal() || methodSymbol.isStatic() || methodSymbol.owner().isFinal());
    }
}

