/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.List;
import org.sonar.java.Preconditions;
import org.sonar.java.model.SELineUtils;
import org.sonar.plugins.java.api.cfg.ControlFlowGraph;
import org.sonar.plugins.java.api.tree.Tree;

public class ProgramPoint {
    private final int hashcode;
    public final ControlFlowGraph.Block block;
    public final int i;

    public ProgramPoint(ControlFlowGraph.Block block) {
        this(block, 0);
    }

    private ProgramPoint(ControlFlowGraph.Block block, int i) {
        int blockSize = block.elements().size();
        Preconditions.checkState(i < blockSize + 2, "CFG Block has %s elements but PP at %s was requested", blockSize, i);
        this.block = block;
        this.i = i;
        this.hashcode = block.id() * 31 + i;
    }

    public ProgramPoint next() {
        int nextPP = this.i + 1;
        return new ProgramPoint(this.block, nextPP);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgramPoint) {
            ProgramPoint other = (ProgramPoint)obj;
            return this.block.id() == other.block.id() && this.i == other.i;
        }
        return false;
    }

    public String toString() {
        Object tree = "";
        List elements = this.block.elements();
        if (this.i < elements.size()) {
            tree = String.valueOf(((Tree)elements.get(this.i)).kind()) + SELineUtils.startLine((Tree)elements.get(this.i));
        }
        return "B" + this.block.id() + "." + this.i + "  " + (String)tree;
    }

    public Tree syntaxTree() {
        if (this.block != null) {
            if (this.block.elements().isEmpty()) {
                return this.block.terminator();
            }
            return (Tree)this.block.elements().get(Math.min(this.i, this.block.elements().size() - 1));
        }
        return null;
    }
}

