/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public class SELiteralUtils {
    private SELiteralUtils() {
    }

    @CheckForNull
    public static Long longLiteralValue(ExpressionTree tree) {
        int sign;
        ExpressionTree expression = tree;
        int n = sign = tree.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) ? -1 : 1;
        if (tree.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
            expression = ((UnaryExpressionTree)tree).expression();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL})) {
            String value = SELiteralUtils.trimLongSuffix(((LiteralTree)expression).value());
            value = value.replace("_", "");
            try {
                if (value.startsWith("0b") || value.startsWith("0B")) {
                    return (long)sign * Long.valueOf(value.substring(2), 2);
                }
                return (long)sign * Long.decode(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Integer intLiteralValue(LiteralTree literal) {
        String literalValue = literal.value().replace("_", "");
        if (literalValue.startsWith("0b") || literalValue.startsWith("0B")) {
            return Integer.parseUnsignedInt(literalValue.substring(2), 2);
        }
        return Long.decode(literalValue).intValue();
    }

    @CheckForNull
    public static Integer intLiteralValue(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            return SELiteralUtils.intLiteralValue((LiteralTree)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
            UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
            Integer subExpressionIntValue = SELiteralUtils.intLiteralValue(unaryExp.expression());
            return expression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) ? SELiteralUtils.minus(subExpressionIntValue) : subExpressionIntValue;
        }
        return null;
    }

    @CheckForNull
    private static Integer minus(@Nullable Integer nullableInteger) {
        return nullableInteger == null ? null : Integer.valueOf(-nullableInteger.intValue());
    }

    public static boolean isTrue(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL}) && "true".equals(((LiteralTree)tree).value());
    }

    public static boolean isFalse(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL}) && "false".equals(((LiteralTree)tree).value());
    }

    public static String trimQuotes(String value) {
        int delimiterLength = SELiteralUtils.isTextBlock(value) ? 3 : 1;
        return value.substring(delimiterLength, value.length() - delimiterLength);
    }

    public static boolean isTextBlock(String value) {
        return value.startsWith("\"\"\"");
    }

    public static String trimLongSuffix(String longString) {
        if (StringUtils.isBlank(longString)) {
            return longString;
        }
        int lastCharPosition = longString.length() - 1;
        char lastChar = longString.charAt(lastCharPosition);
        String value = longString;
        if (lastChar == 'L' || lastChar == 'l') {
            value = longString.substring(0, lastCharPosition);
        }
        return value;
    }

    public static int indentationOfTextBlock(String[] lines) {
        return Arrays.stream(lines).skip(1L).filter(SELiteralUtils::isNonEmptyLine).mapToInt(SELiteralUtils::getIndentation).min().orElse(0);
    }

    private static String stripIndent(int indent, String s) {
        return s.isEmpty() ? s : s.substring(indent);
    }

    public static String getAsStringValue(LiteralTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.TEXT_BLOCK})) {
            return tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) ? SELiteralUtils.trimQuotes(tree.value()) : tree.value();
        }
        String[] lines = tree.value().split("\r?\n");
        int indent = SELiteralUtils.indentationOfTextBlock(lines);
        return Arrays.stream(lines).skip(1L).map(String::stripTrailing).map(s -> SELiteralUtils.stripIndent(indent, s)).collect(Collectors.joining("\n")).replaceAll("\"\"\"$", "");
    }

    private static int getIndentation(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (!SELiteralUtils.isNotWhiteSpace(line.charAt(i))) continue;
            return i;
        }
        return line.length();
    }

    private static boolean isNotWhiteSpace(int c) {
        return c != 32 && c != 9 && c != 12;
    }

    private static boolean isNonEmptyLine(String line) {
        return line.chars().anyMatch(SELiteralUtils::isNotWhiteSpace);
    }
}

