/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.model.SELiteralUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public final class SEExpressionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SEExpressionUtils.class);

    private SEExpressionUtils() {
    }

    public static boolean isSelectOnThisOrSuper(MemberSelectExpressionTree tree) {
        if (!tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return false;
        }
        String selectSourceName = ((IdentifierTree)tree.expression()).name();
        return "this".equalsIgnoreCase(selectSourceName) || "super".equalsIgnoreCase(selectSourceName);
    }

    public static boolean isSelectOnThisOrSuper(AssignmentExpressionTree tree) {
        ExpressionTree variable = SEExpressionUtils.skipParentheses(tree.variable());
        return variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && SEExpressionUtils.isSelectOnThisOrSuper((MemberSelectExpressionTree)variable);
    }

    public static ExpressionTree skipParentheses(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (result.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    private static Optional<IdentifierTree> extractIdentifier(ExpressionTree tree) {
        MemberSelectExpressionTree selectTree;
        ExpressionTree cleanedExpression = SEExpressionUtils.skipParentheses(tree);
        if (cleanedExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return Optional.of((IdentifierTree)cleanedExpression);
        }
        if (cleanedExpression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && SEExpressionUtils.isSelectOnThisOrSuper(selectTree = (MemberSelectExpressionTree)cleanedExpression)) {
            return Optional.of(selectTree.identifier());
        }
        return Optional.empty();
    }

    public static boolean isSimpleAssignment(AssignmentExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            return false;
        }
        ExpressionTree variable = SEExpressionUtils.skipParentheses(tree.variable());
        return variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || SEExpressionUtils.isSelectOnThisOrSuper(tree);
    }

    public static IdentifierTree methodName(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        IdentifierTree id = methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)methodSelect : ((MemberSelectExpressionTree)methodSelect).identifier();
        return id;
    }

    public static boolean isNullLiteral(ExpressionTree tree) {
        return SEExpressionUtils.skipParentheses(tree).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    @CheckForNull
    public static Object resolveAsConstant(ExpressionTree tree) {
        ExpressionTree expression = tree;
        while (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            expression = ((ParenthesizedTree)expression).expression();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            expression = ((MemberSelectExpressionTree)expression).identifier();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return SEExpressionUtils.resolveIdentifier((IdentifierTree)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            return Boolean.parseBoolean(((LiteralTree)expression).value());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK})) {
            return SELiteralUtils.getAsStringValue((LiteralTree)expression);
        }
        if (expression instanceof UnaryExpressionTree) {
            UnaryExpressionTree unaryExpressionTree = (UnaryExpressionTree)expression;
            return SEExpressionUtils.resolveUnaryExpression(unaryExpressionTree);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            return SELiteralUtils.intLiteralValue(expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.LONG_LITERAL})) {
            return SELiteralUtils.longLiteralValue(expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            return SEExpressionUtils.resolvePlus((BinaryExpressionTree)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.OR})) {
            return SEExpressionUtils.resolveOr((BinaryExpressionTree)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.MINUS})) {
            return SEExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a - b, (a, b) -> a - b);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.MULTIPLY})) {
            return SEExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a * b, (a, b) -> a * b);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.DIVIDE})) {
            return SEExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a / b, (a, b) -> a / b);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.REMAINDER})) {
            return SEExpressionUtils.resolveArithmeticOperation((BinaryExpressionTree)expression, (a, b) -> a % b, (a, b) -> a % b);
        }
        return null;
    }

    @CheckForNull
    private static Object resolveIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        if (!symbol.isVariableSymbol()) {
            return null;
        }
        Symbol owner = symbol.owner();
        if (owner.isTypeSymbol() && owner.type().is("java.lang.Boolean")) {
            if ("TRUE".equals(symbol.name())) {
                return Boolean.TRUE;
            }
            if ("FALSE".equals(symbol.name())) {
                return Boolean.FALSE;
            }
        }
        return ((Symbol.VariableSymbol)symbol).constantValue().orElse(null);
    }

    public static IdentifierTree extractIdentifier(AssignmentExpressionTree tree) {
        Optional<IdentifierTree> identifier = SEExpressionUtils.extractIdentifier(tree.variable());
        if (identifier.isPresent()) {
            return identifier.get();
        }
        throw new IllegalArgumentException("Can not extract identifier.");
    }

    public static boolean isThis(ExpressionTree expression) {
        ExpressionTree newExpression = SEExpressionUtils.skipParentheses(expression);
        return newExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "this".equals(((IdentifierTree)newExpression).name());
    }

    @CheckForNull
    private static Object resolveArithmeticOperation(Object left, Object right, BiFunction<Long, Long, Object> longOperation, BiFunction<Integer, Integer, Object> intOperation) {
        try {
            if (left instanceof Integer) {
                Integer leftInt = (Integer)left;
                if (right instanceof Integer) {
                    Integer rightInt = (Integer)right;
                    return intOperation.apply(leftInt, rightInt);
                }
            }
            if ((left instanceof Long || right instanceof Long) && (left instanceof Integer || right instanceof Integer)) {
                return longOperation.apply(((Number)left).longValue(), ((Number)right).longValue());
            }
        }
        catch (ArithmeticException e) {
            LOG.debug("Arithmetic exception while resolving arithmetic operation value", (Throwable)e);
        }
        return null;
    }

    @CheckForNull
    private static Object resolveUnaryExpression(UnaryExpressionTree unaryExpression) {
        Object value = SEExpressionUtils.resolveAsConstant(unaryExpression.expression());
        if (unaryExpression.is(new Tree.Kind[]{Tree.Kind.UNARY_PLUS})) {
            return value;
        }
        if (unaryExpression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS})) {
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return -longValue.longValue();
            }
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                return -intValue.intValue();
            }
        } else if (unaryExpression.is(new Tree.Kind[]{Tree.Kind.BITWISE_COMPLEMENT})) {
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return longValue ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                return ~intValue.intValue();
            }
        } else if (unaryExpression.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT}) && value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool == false;
        }
        return null;
    }

    @CheckForNull
    private static Object resolvePlus(BinaryExpressionTree binaryExpression) {
        Object left = SEExpressionUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = SEExpressionUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String) {
            String leftString = (String)left;
            return leftString + String.valueOf(right);
        }
        if (right instanceof String) {
            String rightString = (String)right;
            return String.valueOf(left) + rightString;
        }
        return SEExpressionUtils.resolveArithmeticOperation(left, right, Long::sum, Integer::sum);
    }

    @CheckForNull
    private static Object resolveArithmeticOperation(BinaryExpressionTree binaryExpression, BiFunction<Long, Long, Object> longOperation, BiFunction<Integer, Integer, Object> intOperation) {
        Object left = SEExpressionUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = SEExpressionUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        return SEExpressionUtils.resolveArithmeticOperation(left, right, longOperation, intOperation);
    }

    @CheckForNull
    private static Object resolveOr(BinaryExpressionTree binaryExpression) {
        Object left = SEExpressionUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = SEExpressionUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Long) {
            Long leftLong = (Long)left;
            if (right instanceof Long) {
                Long rightLong = (Long)right;
                return leftLong | rightLong;
            }
        }
        if (left instanceof Long) {
            Long leftLong = (Long)left;
            if (right instanceof Integer) {
                Integer rightInt = (Integer)right;
                return leftLong | (long)rightInt.intValue();
            }
        }
        if (left instanceof Integer) {
            Integer leftInt = (Integer)left;
            if (right instanceof Long) {
                Long rightLong = (Long)right;
                return (long)leftInt.intValue() | rightLong;
            }
        }
        if (left instanceof Integer) {
            Integer leftInt = (Integer)left;
            if (right instanceof Integer) {
                Integer rightInt = (Integer)right;
                return leftInt | rightInt;
            }
        }
        return null;
    }
}

