/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SEVariableReadExtractor
extends BaseTreeVisitor {
    private final Symbol.MethodSymbol methodSymbol;
    private final Set<Symbol> used;
    private final boolean includeFields;

    public SEVariableReadExtractor(Symbol.MethodSymbol methodSymbol, boolean includeFields) {
        this.methodSymbol = methodSymbol;
        this.includeFields = includeFields;
        this.used = new HashSet<Symbol>();
    }

    public Set<Symbol> usedVariables() {
        return this.used;
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (!tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !tree.variable().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.scan((Tree)tree.variable());
        }
        this.scan((Tree)tree.expression());
    }

    public void visitVariable(VariableTree tree) {
        this.scan((Tree)tree.initializer());
    }

    public void visitClass(ClassTree tree) {
        this.scan(tree.members());
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        this.scan(lambdaExpressionTree.body());
    }

    public void visitIdentifier(IdentifierTree tree) {
        Symbol owner = tree.symbol().owner();
        if (this.methodSymbol.equals((Object)owner) || this.includeFields && SEVariableReadExtractor.isField(tree.symbol(), this.methodSymbol.owner())) {
            this.used.add(tree.symbol());
        }
        super.visitIdentifier(tree);
    }

    private static boolean isField(Symbol identifierSymbol, Symbol methodOwnerSymbol) {
        return methodOwnerSymbol.equals((Object)identifierSymbol.owner()) && !"this".equals(identifierSymbol.name()) && !identifierSymbol.isMethodSymbol();
    }
}

