/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.cfg.SEVariableReadExtractor;
import org.sonar.plugins.java.api.cfg.ControlFlowGraph;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class SELiveVariables {
    private final ControlFlowGraph cfg;
    private final Map<ControlFlowGraph.Block, Set<Symbol>> out = new HashMap<ControlFlowGraph.Block, Set<Symbol>>();
    private final Map<ControlFlowGraph.Block, Set<Symbol>> in = new HashMap<ControlFlowGraph.Block, Set<Symbol>>();

    private SELiveVariables(ControlFlowGraph cfg) {
        this.cfg = cfg;
    }

    private void analyzeControlFlowGraph(Map<ControlFlowGraph.Block, Set<Symbol>> in, Map<ControlFlowGraph.Block, Set<Symbol>> kill, Map<ControlFlowGraph.Block, Set<Symbol>> gen) {
        LinkedList workList = new LinkedList();
        workList.addAll(this.cfg.reversedBlocks());
        while (!workList.isEmpty()) {
            ControlFlowGraph.Block block = (ControlFlowGraph.Block)workList.removeFirst();
            Set blockOut = this.out.computeIfAbsent(block, k -> new HashSet());
            block.successors().stream().map(in::get).filter(Objects::nonNull).forEach(blockOut::addAll);
            block.exceptions().stream().map(in::get).filter(Objects::nonNull).forEach(blockOut::addAll);
            HashSet<Symbol> newIn = new HashSet<Symbol>((Collection)gen.get(block));
            newIn.addAll(SetUtils.difference(blockOut, kill.get(block)));
            if (newIn.equals(in.get(block))) continue;
            in.put(block, newIn);
            block.predecessors().forEach(workList::addLast);
        }
    }

    public static SELiveVariables analyze(ControlFlowGraph cfg) {
        SELiveVariables liveVariables = new SELiveVariables(cfg);
        HashMap<ControlFlowGraph.Block, Set<Symbol>> kill = new HashMap<ControlFlowGraph.Block, Set<Symbol>>();
        HashMap<ControlFlowGraph.Block, Set<Symbol>> gen = new HashMap<ControlFlowGraph.Block, Set<Symbol>>();
        for (ControlFlowGraph.Block block : liveVariables.cfg.reversedBlocks()) {
            HashSet<Symbol> blockKill = new HashSet<Symbol>();
            HashSet<Symbol> blockGen = new HashSet<Symbol>();
            liveVariables.processBlockElements(block, blockKill, blockGen);
            kill.put(block, blockKill);
            gen.put(block, blockGen);
        }
        liveVariables.analyzeControlFlowGraph(liveVariables.in, kill, gen);
        if (!liveVariables.out.get(liveVariables.cfg.reversedBlocks().get(0)).isEmpty()) {
            throw new IllegalStateException("Out of exit block should be empty");
        }
        for (Map.Entry entry : liveVariables.out.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        return liveVariables;
    }

    public Set<Symbol> getOut(ControlFlowGraph.Block block) {
        return this.out.get(block);
    }

    private static void processAssignment(AssignmentExpressionTree element, Set<Symbol> blockKill, Set<Symbol> blockGen, Set<Tree> assignmentLHS) {
        Symbol symbol = null;
        ExpressionTree lhs = element.variable();
        if (lhs.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            symbol = ((IdentifierTree)lhs).symbol();
        }
        if (symbol != null && SELiveVariables.includeSymbol(symbol)) {
            assignmentLHS.add((Tree)lhs);
            blockGen.remove(symbol);
            blockKill.add(symbol);
        }
    }

    private void processBlockElements(ControlFlowGraph.Block block, Set<Symbol> blockKill, Set<Symbol> blockGen) {
        HashSet<Tree> assignmentLHS = new HashSet<Tree>();
        for (Tree element : ListUtils.reverse(block.elements())) {
            switch (element.kind()) {
                case ASSIGNMENT: {
                    SELiveVariables.processAssignment((AssignmentExpressionTree)element, blockKill, blockGen, assignmentLHS);
                    break;
                }
                case IDENTIFIER: {
                    SELiveVariables.processIdentifier((IdentifierTree)element, blockGen, assignmentLHS);
                    break;
                }
                case VARIABLE: {
                    blockKill.add(((VariableTree)element).symbol());
                    blockGen.remove(((VariableTree)element).symbol());
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    blockGen.addAll(SELiveVariables.getUsedVariables(((LambdaExpressionTree)element).body(), this.cfg.methodSymbol()));
                    break;
                }
                case METHOD_REFERENCE: {
                    blockGen.addAll(SELiveVariables.getUsedVariables(((MethodReferenceTree)element).expression(), this.cfg.methodSymbol()));
                    break;
                }
                case NEW_CLASS: {
                    blockGen.addAll(SELiveVariables.getUsedVariables((Tree)((NewClassTree)element).classBody(), this.cfg.methodSymbol()));
                    break;
                }
            }
        }
    }

    private static void processIdentifier(IdentifierTree element, Set<Symbol> blockGen, Set<Tree> assignmentLHS) {
        Symbol symbol = element.symbol();
        if (!assignmentLHS.contains(element) && SELiveVariables.includeSymbol(symbol)) {
            blockGen.add(symbol);
        }
    }

    private static boolean includeSymbol(Symbol symbol) {
        return symbol.isLocalVariable();
    }

    private static Set<Symbol> getUsedVariables(@Nullable Tree syntaxNode, Symbol.MethodSymbol owner) {
        if (syntaxNode == null) {
            return Collections.emptySet();
        }
        SEVariableReadExtractor extractorFromClass = new SEVariableReadExtractor(owner, false);
        syntaxNode.accept((TreeVisitor)extractorFromClass);
        return extractorFromClass.usedVariables();
    }
}

