/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.plugins.java.api.cfg.ControlFlowGraph;
import org.sonar.plugins.java.api.tree.Tree;

public class CFGLoop {
    private final ControlFlowGraph.Block startingBlock;
    private final Set<ControlFlowGraph.Block> blocks = new HashSet<ControlFlowGraph.Block>();
    private final Set<ControlFlowGraph.Block> successors = new HashSet<ControlFlowGraph.Block>();

    private CFGLoop(ControlFlowGraph.Block block) {
        this.startingBlock = block;
    }

    private void initialize(ControlFlowGraph.Block block, Map<Tree, CFGLoop> container) {
        ControlFlowGraph.Block loopFirstBlock = block.trueBlock();
        if (loopFirstBlock == null) {
            loopFirstBlock = (ControlFlowGraph.Block)block.successors().iterator().next();
        }
        this.collectBlocks(loopFirstBlock, container);
        this.successors.addAll(block.successors());
        this.successors.remove(block.falseBlock());
        this.collectWaysOut(container);
    }

    public boolean hasNoWayOut() {
        return this.successors.isEmpty();
    }

    Collection<ControlFlowGraph.Block> successors() {
        return new ArrayList<ControlFlowGraph.Block>(this.successors);
    }

    private boolean collectBlocks(ControlFlowGraph.Block block, Map<Tree, CFGLoop> container, Set<ControlFlowGraph.Block> visitedBlocks) {
        if (this.blocks.contains(block)) {
            return true;
        }
        if (block.id() == this.startingBlock.id() || !visitedBlocks.add(block)) {
            return false;
        }
        boolean answer = this.returnsToStart(block, container, visitedBlocks);
        if (answer || CFGLoop.isBreak(block)) {
            this.blocks.add(block);
        }
        return answer;
    }

    private void collectBlocks(ControlFlowGraph.Block block, Map<Tree, CFGLoop> container) {
        this.collectBlocks(block, container, new HashSet<ControlFlowGraph.Block>());
    }

    @CheckForNull
    private static Set<? extends ControlFlowGraph.Block> localSuccessors(ControlFlowGraph.Block block, Map<Tree, CFGLoop> container) {
        if (CFGLoop.isStarting(block)) {
            CFGLoop loop = container.get(block.terminator());
            if (loop == null) {
                loop = CFGLoop.create(block, container);
            }
            HashSet<ControlFlowGraph.Block> loopSuccessors = new HashSet<ControlFlowGraph.Block>(loop.successors);
            if (block.trueBlock() == null) {
                return null;
            }
            loopSuccessors.add(block.falseBlock());
            return loopSuccessors;
        }
        return block.successors();
    }

    private boolean returnsToStart(ControlFlowGraph.Block block, Map<Tree, CFGLoop> container, Set<ControlFlowGraph.Block> visitedBlocks) {
        Set<? extends ControlFlowGraph.Block> localSuccessors = CFGLoop.localSuccessors(block, container);
        if (localSuccessors == null) {
            return true;
        }
        boolean answer = false;
        for (ControlFlowGraph.Block block2 : localSuccessors) {
            if (this.startingBlock.id() == block2.id()) {
                answer = true;
                continue;
            }
            answer |= this.collectBlocks(block2, container, visitedBlocks);
        }
        return answer;
    }

    private void collectWaysOut(Map<Tree, CFGLoop> container) {
        for (ControlFlowGraph.Block block : this.blocks) {
            if (CFGLoop.isStarting(block)) {
                CFGLoop innerLoop = container.get(block.terminator());
                this.successors.addAll(innerLoop.successors());
                continue;
            }
            this.successors.addAll(block.successors());
        }
        this.successors.removeAll(this.blocks);
        this.successors.remove(this.startingBlock);
    }

    private static boolean isBreak(ControlFlowGraph.Block block) {
        Tree terminator = block.terminator();
        return terminator != null && terminator.is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT});
    }

    public static Map<Tree, CFGLoop> getCFGLoops(ControlFlowGraph cfg) {
        HashMap<Tree, CFGLoop> cfgLoops = new HashMap<Tree, CFGLoop>();
        for (ControlFlowGraph.Block block : cfg.blocks()) {
            Tree terminator;
            if (!CFGLoop.isStarting(block) || cfgLoops.containsKey(terminator = block.terminator())) continue;
            CFGLoop.create(block, cfgLoops);
        }
        return cfgLoops;
    }

    private static CFGLoop create(ControlFlowGraph.Block block, Map<Tree, CFGLoop> container) {
        CFGLoop loop = new CFGLoop(block);
        container.put(block.terminator(), loop);
        loop.initialize(block, container);
        return loop;
    }

    private static boolean isStarting(ControlFlowGraph.Block block) {
        Tree terminator = block.terminator();
        return terminator != null && terminator.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT});
    }
}

