/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.sarif;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.UnaryOperator;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;
import org.sonarsource.dotnet.shared.sarif.SarifParser;
import org.sonarsource.dotnet.shared.sarif.SarifParser01And04;
import org.sonarsource.dotnet.shared.sarif.SarifParser10;

public class SarifParserFactory {
    private SarifParserFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SarifParser create(RoslynReport report, UnaryOperator<String> toRealPath) {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(report.getReportPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(reader).getAsJsonObject();
            if (!root.has("version")) throw new IllegalStateException(String.format("Unable to parse the Roslyn SARIF report file: %s. Unrecognized format", report.getReportPath().toAbsolutePath()));
            String version = root.get("version").getAsString();
            Object object = switch (version) {
                case "0.4", "0.1" -> new SarifParser01And04(report.getProject(), root, toRealPath);
                default -> new SarifParser10(report.getProject(), root, toRealPath);
            };
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read the Roslyn SARIF report file: " + String.valueOf(report.getReportPath().toAbsolutePath()), e);
        }
    }
}

