/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.UnaryOperator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.scanner.fs.InputProject;
import org.sonarsource.dotnet.shared.sarif.Location;
import org.sonarsource.dotnet.shared.sarif.SarifParser;
import org.sonarsource.dotnet.shared.sarif.SarifParserCallback;

class SarifParser01And04
implements SarifParser {
    private static final String FILE_PROTOCOL = "file:///";
    private final InputProject inputProject;
    private final JsonObject root;
    private final UnaryOperator<String> toRealPath;

    SarifParser01And04(InputProject inputProject, JsonObject root, UnaryOperator<String> toRealPath) {
        this.inputProject = inputProject;
        this.root = root;
        this.toRealPath = toRealPath;
    }

    @Override
    public void accept(SarifParserCallback callback) {
        if (this.root.has("runLogs")) {
            JsonElement runLogs = this.root.get("runLogs");
            for (JsonElement runLogElement : runLogs.getAsJsonArray()) {
                JsonObject runLog = runLogElement.getAsJsonObject();
                JsonArray results = runLog.getAsJsonArray("results");
                if (results == null) continue;
                this.handleIssues(results, false, callback);
            }
        } else if (this.root.has("issues")) {
            JsonElement issues = this.root.get("issues");
            this.handleIssues(issues.getAsJsonArray(), true, callback);
        }
    }

    private void handleIssues(JsonArray issues, boolean offsetStartAtZero, SarifParserCallback callback) {
        for (JsonElement issueElement : issues) {
            JsonObject issue = issueElement.getAsJsonObject();
            this.handleIssue(issue, offsetStartAtZero, callback);
        }
    }

    private void handleIssue(JsonObject issue, boolean offsetStartAtZero, SarifParserCallback callback) {
        if (SarifParser01And04.isSuppressed(issue)) {
            return;
        }
        String ruleId = issue.get("ruleId").getAsString();
        String message = issue.get(issue.has("shortMessage") ? "shortMessage" : "fullMessage").getAsString();
        JsonArray locationsArray = issue.getAsJsonArray("locations");
        if (locationsArray.size() == 0) {
            callback.onProjectIssue(ruleId, null, this.inputProject, message);
            return;
        }
        JsonObject primaryLocationObject = SarifParser01And04.getAnalysisTargetAt(locationsArray, 0);
        if (primaryLocationObject == null) {
            callback.onProjectIssue(ruleId, null, this.inputProject, message);
            return;
        }
        String primaryLocationPath = (String)this.toRealPath.apply(SarifParser01And04.uriToAbsolutePath(primaryLocationObject.get("uri").getAsString()));
        Location primaryLocation = SarifParser01And04.getLocation(offsetStartAtZero, primaryLocationObject, primaryLocationPath, message);
        if (primaryLocation == null) {
            callback.onFileIssue(ruleId, null, primaryLocationPath, Collections.emptyList(), message);
            return;
        }
        ArrayList<Location> secondaryLocations = new ArrayList<Location>();
        for (int i = 1; i < locationsArray.size(); ++i) {
            String secondaryLocationPath;
            Location secondaryLocation;
            JsonObject secondaryLocationObject = SarifParser01And04.getAnalysisTargetAt(locationsArray, i);
            if (secondaryLocationObject == null || (secondaryLocation = SarifParser01And04.getLocation(offsetStartAtZero, secondaryLocationObject, secondaryLocationPath = (String)this.toRealPath.apply(SarifParser01And04.uriToAbsolutePath(secondaryLocationObject.get("uri").getAsString())), SarifParser01And04.getSecondaryMessage(issue, i - 1))) == null) continue;
            secondaryLocations.add(secondaryLocation);
        }
        callback.onIssue(ruleId, null, primaryLocation, secondaryLocations, false);
    }

    @CheckForNull
    private static String getSecondaryMessage(JsonObject issue, int index) {
        JsonObject properties = issue.getAsJsonObject("properties");
        if (properties == null) {
            return null;
        }
        JsonElement messageElement = properties.get("customProperties." + index);
        if (messageElement == null) {
            return null;
        }
        return messageElement.getAsString();
    }

    @CheckForNull
    private static JsonObject getAnalysisTargetAt(JsonArray locationsArray, int index) {
        JsonObject analysisTargetWrapper = locationsArray.get(index).getAsJsonObject();
        JsonArray analysisTargetArray = analysisTargetWrapper.getAsJsonArray("analysisTarget");
        if (analysisTargetArray == null || analysisTargetArray.size() == 0) {
            return null;
        }
        return analysisTargetArray.get(0).getAsJsonObject();
    }

    private static Location getLocation(boolean offsetStartAtZero, JsonObject analysisTarget, String absolutePath, @Nullable String message) {
        int endLineOffset;
        JsonObject region = analysisTarget.getAsJsonObject("region");
        int startLine = region.get("startLine").getAsInt();
        int startLineFixed = offsetStartAtZero ? startLine + 1 : startLine;
        JsonElement startColumnOrNull = region.get("startColumn");
        int startColumn = startColumnOrNull != null ? startColumnOrNull.getAsInt() : 1;
        int startLineOffset = offsetStartAtZero ? startColumn : startColumn - 1;
        JsonElement lengthOrNull = region.get("length");
        if (lengthOrNull != null) {
            return new Location(absolutePath, message, startLineFixed, startLineOffset, startLineFixed, startLineOffset + lengthOrNull.getAsInt());
        }
        JsonElement endLineOrNull = region.get("endLine");
        int endLine = endLineOrNull != null ? endLineOrNull.getAsInt() : startLine;
        int endLineFixed = offsetStartAtZero ? endLine + 1 : endLine;
        JsonElement endColumnOrNull = region.get("endColumn");
        int endColumn = endColumnOrNull != null ? endColumnOrNull.getAsInt() : (endLineOrNull != null ? (endLine == startLine ? startColumn : 1) : startColumn);
        int n = endLineOffset = offsetStartAtZero ? endColumn : endColumn - 1;
        if (startLine == endLine && startLineOffset == endLineOffset) {
            if (startLine == 1) {
                return null;
            }
            if (startLineOffset == 0) {
                ++endLineOffset;
            } else {
                --startLineOffset;
            }
        }
        return new Location(absolutePath, message, startLineFixed, startLineOffset, endLineFixed, endLineOffset);
    }

    private static boolean isSuppressed(JsonObject issue) {
        JsonElement isSuppressedInSource = issue.get("isSuppressedInSource");
        if (isSuppressedInSource != null) {
            return isSuppressedInSource.getAsBoolean();
        }
        JsonElement properties = issue.get("properties");
        if (properties != null && properties.isJsonObject() && (isSuppressedInSource = properties.getAsJsonObject().get("isSuppressedInSource")) != null) {
            return isSuppressedInSource.getAsBoolean();
        }
        return false;
    }

    private static String uriToAbsolutePath(String uri) {
        if (!uri.startsWith(FILE_PROTOCOL)) {
            return uri;
        }
        return uri.substring(FILE_PROTOCOL.length()).replace('/', '\\');
    }
}

