/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.TelemetryCollector;
import org.sonarsource.dotnet.shared.plugins.protobuf.TelemetryAggregator;

public class TelemetryProcessor
implements ProjectSensor {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryProcessor.class);
    private final PluginMetadata pluginMetadata;
    private final TelemetryCollector collector;

    public TelemetryProcessor(TelemetryCollector collector, PluginMetadata pluginMetadata) {
        this.pluginMetadata = pluginMetadata;
        this.collector = collector;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Telemetry processor", this.pluginMetadata.languageName());
        descriptor.name(name);
    }

    public void execute(@Nonnull SensorContext context) {
        if (this.collector == null) {
            LOG.debug("TelemetryCollector is null, skipping telemetry processing.");
            return;
        }
        TelemetryAggregator aggregator = new TelemetryAggregator(this.pluginMetadata.pluginKey(), this.pluginMetadata.languageKey());
        Collection<SonarAnalyzer.Telemetry> messages = this.collector.getTelemetryMessages();
        LOG.debug("Found {} telemetry messages reported by the analyzers.", (Object)messages.size());
        Collection<Map.Entry<String, String>> telemetries = aggregator.aggregate(messages);
        LOG.debug("Aggregated {} metrics.", (Object)telemetries.size());
        telemetries.forEach(telemetry -> {
            LOG.debug("Adding metric: {}={}", telemetry.getKey(), telemetry.getValue());
            context.addTelemetryProperty((String)telemetry.getKey(), (String)telemetry.getValue());
        });
        LOG.debug("Added {} metrics.", (Object)telemetries.size());
    }
}

