/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.plugins.AbstractLanguageConfiguration;
import org.sonarsource.dotnet.shared.plugins.telemetryjson.TelemetryJsonCollector;
import org.sonarsource.dotnet.shared.plugins.telemetryjson.TelemetryJsonParser;

@ScannerSide
public class TelemetryJsonProjectCollector {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryJsonProjectCollector.class);
    private static final Pattern TelemetryPattern = Pattern.compile("^Telemetry\\..*\\.json$");
    private final TelemetryJsonCollector collector;
    private final AbstractLanguageConfiguration configuration;

    public TelemetryJsonProjectCollector(TelemetryJsonCollector collector, AbstractLanguageConfiguration configuration) {
        this.collector = collector;
        this.configuration = configuration;
    }

    public void execute() {
        this.configuration.outputDir().map(TelemetryJsonProjectCollector::getFilePaths).ifPresent(this::collectTelemetry);
    }

    private void collectTelemetry(Stream<Path> pathStream) {
        TelemetryJsonParser parser = new TelemetryJsonParser();
        pathStream.forEach(file -> TelemetryJsonProjectCollector.markAsProcessed(file).ifPresent(x -> {
            try (FileInputStream input = new FileInputStream(x.toFile());
                 InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);){
                parser.parse(reader).forEach(this.collector::addTelemetry);
            }
            catch (IOException e) {
                LOG.debug("Cannot open telemetry file {}, {}", file, (Object)e.toString());
            }
        }));
    }

    private static Optional<Path> markAsProcessed(Path file) {
        Path newFile = file.resolveSibling("Processed." + String.valueOf(file.getFileName()));
        try {
            Path result = Files.move(file, newFile, new CopyOption[0]);
            return Optional.ofNullable(result);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static Stream<Path> getFilePaths(Path outputDirectory) {
        LOG.debug("Searching for telemetry json in {}", (Object)outputDirectory);
        try {
            return Files.find(outputDirectory, 1, (path, attributes) -> TelemetryPattern.matcher(path.toFile().getName()).matches(), new FileVisitOption[0]);
        }
        catch (IOException exception) {
            LOG.warn("Error occurred while loading telemetry json", (Throwable)exception);
            return Stream.empty();
        }
    }
}

