/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.sensors.TelemetryJsonProjectCollector;
import org.sonarsource.dotnet.shared.plugins.telemetryjson.TelemetryJsonAggregator;
import org.sonarsource.dotnet.shared.plugins.telemetryjson.TelemetryJsonCollector;

public class TelemetryJsonProcessor
implements ProjectSensor {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryJsonProcessor.class);
    private final TelemetryJsonProjectCollector projectSensor;
    private final PluginMetadata pluginMetadata;
    private final TelemetryJsonCollector collector;

    public TelemetryJsonProcessor(TelemetryJsonCollector collector, TelemetryJsonProjectCollector projectSensor, PluginMetadata pluginMetadata) {
        this.collector = collector;
        this.projectSensor = projectSensor;
        this.pluginMetadata = pluginMetadata;
    }

    public void describe(SensorDescriptor sensorDescriptor) {
        String name = String.format("%s Telemetry Json processor", this.pluginMetadata.languageName());
        sensorDescriptor.name(name);
    }

    public void execute(@Nonnull SensorContext sensorContext) {
        this.projectSensor.execute();
        if (this.collector == null) {
            LOG.debug("TelemetryJsonCollector is null, skipping telemetry processing.");
            return;
        }
        Collection<Map.Entry<String, String>> messages = this.collector.getTelemetry();
        LOG.debug("Found {} telemetry messages.", (Object)messages.size());
        Stream<Map.Entry<String, String>> aggregated = new TelemetryJsonAggregator().flatMapTelemetry(messages.stream());
        AtomicInteger count = new AtomicInteger();
        aggregated.forEach(telemetry -> {
            LOG.debug("Adding metric: {}={}", telemetry.getKey(), telemetry.getValue());
            sensorContext.addTelemetryProperty((String)telemetry.getKey(), (String)telemetry.getValue());
            count.getAndIncrement();
        });
        LOG.debug("Added {} metrics.", (Object)count);
    }
}

