/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarEdition;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.scanner.fs.InputProject;
import org.sonarsource.dotnet.shared.sarif.Location;
import org.sonarsource.dotnet.shared.sarif.SarifParserCallback;

public class SarifParserCallbackImpl
implements SarifParserCallback {
    private static final Logger LOG = LoggerFactory.getLogger(SarifParserCallbackImpl.class);
    private static final String EXTERNAL_ENGINE_ID = "roslyn";
    private static final List<String> OWN_REPOSITORIES = Arrays.asList("csharpsquid", "vbnet");
    private final SensorContext context;
    private final Map<String, String> repositoryKeyByRoslynRuleKey;
    private final Set<Issue> savedIssues = new HashSet<Issue>();
    private final Set<ProjectIssue> projectIssues = new HashSet<ProjectIssue>();
    private final boolean ignoreThirdPartyIssues;
    private final Set<String> bugCategories;
    private final Set<String> codeSmellCategories;
    private final Set<String> vulnerabilityCategories;
    private final Map<String, String> defaultLevelByRuleId = new HashMap<String, String>();
    private final Map<String, RuleType> ruleTypeByRuleId = new HashMap<String, RuleType>();

    public SarifParserCallbackImpl(SensorContext context, Map<String, String> repositoryKeyByRoslynRuleKey, boolean ignoreThirdPartyIssues, Set<String> bugCategories, Set<String> codeSmellCategories, Set<String> vulnerabilityCategories) {
        this.context = context;
        this.repositoryKeyByRoslynRuleKey = repositoryKeyByRoslynRuleKey;
        this.ignoreThirdPartyIssues = ignoreThirdPartyIssues;
        this.bugCategories = bugCategories;
        this.codeSmellCategories = codeSmellCategories;
        this.vulnerabilityCategories = vulnerabilityCategories;
    }

    @Override
    public void onProjectIssue(String ruleId, @Nullable String level, InputProject inputProject, String message) {
        if (!this.projectIssues.add(new ProjectIssue(ruleId, message))) {
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createProjectLevelIssue(ruleId, inputProject, message, repositoryKey);
        }
    }

    private void createProjectLevelIssue(String ruleId, InputProject inputProject, String message, String repositoryKey) {
        this.logIssue("project level", ruleId, inputProject.toString());
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputProject).message(message)).save();
    }

    @Override
    public void onFileIssue(String ruleId, @Nullable String level, String absolutePath, Collection<Location> secondaryLocations, String message) {
        Issue issue = new Issue(ruleId, absolutePath);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(absolutePath));
        if (inputFile == null) {
            this.logMissingInputFile(ruleId, absolutePath);
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createFileLevelIssue(ruleId, message, repositoryKey, inputFile, secondaryLocations);
        } else if (this.shouldCreateExternalIssue(ruleId)) {
            this.createFileLevelExternalIssue(ruleId, level, message, inputFile, secondaryLocations);
        }
    }

    private void createFileLevelIssue(String ruleId, String message, String repositoryKey, InputFile inputFile, Collection<Location> secondaryLocations) {
        this.logIssue("file level", ruleId, inputFile.toString());
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputFile).message(message));
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewIssue)newIssue).newLocation(), arg_0 -> ((NewIssue)newIssue).addLocation(arg_0), SarifParserCallbackImpl.isSonarSourceRepository(repositoryKey));
        newIssue.save();
    }

    private void createFileLevelExternalIssue(String ruleId, @Nullable String level, String message, InputFile inputFile, Collection<Location> secondaryLocations) {
        this.logIssue("file level external", ruleId, inputFile.toString());
        NewExternalIssue newIssue = this.newExternalIssue(ruleId);
        newIssue.at(newIssue.newLocation().on((InputComponent)inputFile).message(message));
        this.setExternalIssueSeverityAndType(ruleId, level, newIssue);
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewExternalIssue)newIssue).newLocation(), arg_0 -> ((NewExternalIssue)newIssue).addLocation(arg_0), true);
        newIssue.save();
    }

    @Override
    public void onIssue(String ruleId, @Nullable String level, Location primaryLocation, Collection<Location> secondaryLocations, boolean withExecutionFlow) {
        Issue issue = new Issue(ruleId, primaryLocation);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(primaryLocation.getAbsolutePath()));
        if (inputFile == null) {
            this.logMissingInputFile(ruleId, primaryLocation.getAbsolutePath());
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createIssue(inputFile, ruleId, primaryLocation, secondaryLocations, repositoryKey, withExecutionFlow);
        } else if (this.shouldCreateExternalIssue(ruleId)) {
            this.createExternalIssue(inputFile, ruleId, level, primaryLocation, secondaryLocations);
        }
    }

    private void createExternalIssue(InputFile inputFile, String ruleId, @Nullable String level, Location primaryLocation, Collection<Location> secondaryLocations) {
        this.logIssue("external", ruleId, primaryLocation.getAbsolutePath());
        NewExternalIssue newIssue = this.newExternalIssue(ruleId);
        newIssue.at(SarifParserCallbackImpl.createIssueLocation(inputFile, primaryLocation, () -> ((NewExternalIssue)newIssue).newLocation(), true));
        this.setExternalIssueSeverityAndType(ruleId, level, newIssue);
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewExternalIssue)newIssue).newLocation(), arg_0 -> ((NewExternalIssue)newIssue).addLocation(arg_0), true);
        newIssue.save();
    }

    private void setExternalIssueSeverityAndType(String ruleId, @Nullable String level, NewExternalIssue newIssue) {
        Severity severity;
        if (level != null) {
            severity = SarifParserCallbackImpl.mapSeverity(level);
        } else if (this.defaultLevelByRuleId.containsKey(ruleId)) {
            severity = SarifParserCallbackImpl.mapSeverity(this.defaultLevelByRuleId.get(ruleId));
        } else {
            LOG.warn("Rule {} was not found in the SARIF report, assuming default severity", (Object)ruleId);
            severity = Severity.MAJOR;
        }
        RuleType ruleType = Optional.ofNullable(this.ruleTypeByRuleId.get(ruleId)).orElse(RuleType.CODE_SMELL);
        newIssue.severity(severity);
        if (this.context.runtime().getEdition() != SonarEdition.SONARCLOUD) {
            newIssue.addImpact(SarifParserCallbackImpl.mapSoftwareQuality(ruleType), SarifParserCallbackImpl.mapImpactSeverity(severity));
        }
        newIssue.type(ruleType);
    }

    private NewExternalIssue newExternalIssue(String ruleId) {
        NewExternalIssue newIssue = this.context.newExternalIssue();
        newIssue.engineId(EXTERNAL_ENGINE_ID).ruleId(ruleId);
        return newIssue;
    }

    private void createIssue(InputFile inputFile, String ruleId, Location primaryLocation, Collection<Location> secondaryLocations, String repositoryKey, boolean withExecutionFlow) {
        boolean isSonarSourceRepository = SarifParserCallbackImpl.isSonarSourceRepository(repositoryKey);
        this.logIssue("normal", ruleId, primaryLocation.getAbsolutePath());
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(SarifParserCallbackImpl.createIssueLocation(inputFile, primaryLocation, () -> ((NewIssue)newIssue).newLocation(), !isSonarSourceRepository));
        if (withExecutionFlow) {
            this.populateExecutionFlow(secondaryLocations, newIssue, !isSonarSourceRepository);
        } else {
            this.populateSecondaryLocations(secondaryLocations, () -> ((NewIssue)newIssue).newLocation(), arg_0 -> ((NewIssue)newIssue).addLocation(arg_0), !isSonarSourceRepository);
        }
        newIssue.save();
    }

    private void populateExecutionFlow(Collection<Location> locations, NewIssue newIssue, boolean isLocationResilient) {
        List newIssueLocations = locations.stream().map(x -> {
            InputFile file = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(x.getAbsolutePath()));
            if (file != null) {
                return SarifParserCallbackImpl.createIssueLocation(file, x, () -> ((NewIssue)newIssue).newLocation(), isLocationResilient);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        if (!newIssueLocations.isEmpty()) {
            Collections.reverse(newIssueLocations);
            newIssue.addFlow((Iterable)newIssueLocations, NewIssue.FlowType.EXECUTION, "Execution Flow");
        }
    }

    private void populateSecondaryLocations(Collection<Location> secondaryLocations, Supplier<NewIssueLocation> newIssueLocationSupplier, Consumer<NewIssueLocation> newIssueLocationConsumer, boolean isLocationResilient) {
        for (Location secondaryLocation : secondaryLocations) {
            InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(secondaryLocation.getAbsolutePath()));
            if (inputFile == null) continue;
            NewIssueLocation newIssueLocation = SarifParserCallbackImpl.createIssueLocation(inputFile, secondaryLocation, newIssueLocationSupplier, isLocationResilient);
            newIssueLocationConsumer.accept(newIssueLocation);
        }
    }

    private static NewIssueLocation createIssueLocation(InputFile inputFile, Location location, Supplier<NewIssueLocation> newIssueLocationSupplier, boolean isLocationResilient) {
        NewIssueLocation newIssueLocation = newIssueLocationSupplier.get().on((InputComponent)inputFile);
        try {
            newIssueLocation = newIssueLocation.at(inputFile.newRange(location.getStartLine(), location.getStartColumn(), location.getEndLine(), location.getEndColumn()));
        }
        catch (IllegalArgumentException ex1) {
            LOG.debug("Precise issue location cannot be found! Location: {}", (Object)location);
            if (!isLocationResilient && !SarifParserCallbackImpl.isLocationInsideRazorFile(location)) {
                throw ex1;
            }
            try {
                newIssueLocation = newIssueLocation.at(inputFile.selectLine(location.getStartLine()));
            }
            catch (IllegalArgumentException ex2) {
                LOG.debug("Line issue location cannot be found! Location: {}", (Object)location);
            }
        }
        String message = location.getMessage();
        if (message != null) {
            newIssueLocation.message(message);
        }
        return newIssueLocation;
    }

    @Override
    public void onRule(String ruleId, @Nullable String shortDescription, @Nullable String fullDescription, String defaultLevel, @Nullable String category) {
        if (this.repositoryKeyByRoslynRuleKey.containsKey(ruleId) || !this.shouldCreateExternalIssue(ruleId)) {
            return;
        }
        this.defaultLevelByRuleId.put(ruleId, defaultLevel);
        RuleType ruleType = this.mapRuleType(category, defaultLevel);
        this.ruleTypeByRuleId.put(ruleId, ruleType);
        this.context.newAdHocRule().engineId(EXTERNAL_ENGINE_ID).ruleId(ruleId).severity(SarifParserCallbackImpl.mapSeverity(defaultLevel)).name(shortDescription != null ? shortDescription : ruleId).description(fullDescription).type(ruleType).save();
    }

    public static org.sonar.api.issue.impact.Severity mapImpactSeverity(Severity severity) {
        return switch (severity) {
            case Severity.BLOCKER -> org.sonar.api.issue.impact.Severity.BLOCKER;
            case Severity.CRITICAL -> org.sonar.api.issue.impact.Severity.HIGH;
            case Severity.MAJOR -> org.sonar.api.issue.impact.Severity.MEDIUM;
            case Severity.MINOR -> org.sonar.api.issue.impact.Severity.LOW;
            case Severity.INFO -> org.sonar.api.issue.impact.Severity.INFO;
            default -> throw new IllegalStateException("This severity value " + String.valueOf(severity) + " is illegal.");
        };
    }

    public static SoftwareQuality mapSoftwareQuality(RuleType type) {
        return switch (type) {
            case RuleType.CODE_SMELL -> SoftwareQuality.MAINTAINABILITY;
            case RuleType.BUG -> SoftwareQuality.RELIABILITY;
            case RuleType.VULNERABILITY -> SoftwareQuality.SECURITY;
            case RuleType.SECURITY_HOTSPOT -> throw new IllegalStateException("Can not map Security Hotspot to Software Quality");
            default -> throw new IllegalStateException("Unknown rule type");
        };
    }

    private boolean shouldCreateExternalIssue(String ruleId) {
        return !this.ignoreThirdPartyIssues && !ruleId.matches("^S\\d{3,4}$");
    }

    private RuleType mapRuleType(@Nullable String category, String defaultLevel) {
        if (category != null) {
            if (this.bugCategories.contains(category)) {
                return RuleType.BUG;
            }
            if (this.codeSmellCategories.contains(category)) {
                return RuleType.CODE_SMELL;
            }
            if (this.vulnerabilityCategories.contains(category)) {
                return RuleType.VULNERABILITY;
            }
        }
        return "Error".equalsIgnoreCase(defaultLevel) ? RuleType.BUG : RuleType.CODE_SMELL;
    }

    private static Severity mapSeverity(String defaultLevel) {
        return switch (defaultLevel.toLowerCase(Locale.ENGLISH)) {
            case "error" -> Severity.CRITICAL;
            case "warning" -> Severity.MAJOR;
            default -> Severity.INFO;
        };
    }

    private static boolean isSonarSourceRepository(String repositoryKey) {
        return OWN_REPOSITORIES.contains(repositoryKey);
    }

    private static boolean isLocationInsideRazorFile(Location location) {
        String absolutePath = location.getAbsolutePath();
        return absolutePath.endsWith(".razor") || absolutePath.endsWith(".cshtml");
    }

    private void logIssue(String issueType, String ruleId, String location) {
        LOG.debug("Adding {} issue {}: {}", new Object[]{issueType, ruleId, location});
    }

    private void logMissingInputFile(String ruleId, String filePath) {
        LOG.debug("Skipping issue {}, input file not found or excluded: {}", (Object)ruleId, (Object)filePath);
    }

    private record ProjectIssue(String ruleId, String message) {
    }

    private record Issue(String ruleId, String absolutePath, int startLine, int startColumn, int endLine, int endColumn) {
        Issue(String ruleId, String path) {
            this(ruleId, path, 0, 0, 0, 0);
        }

        Issue(String ruleId, Location location) {
            this(ruleId, location.getAbsolutePath(), location.getStartLine(), location.getStartColumn(), location.getEndLine(), location.getEndColumn());
        }
    }
}

