/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.CallableUtils;
import org.sonarsource.dotnet.shared.StringUtils;
import org.sonarsource.dotnet.shared.plugins.AbstractLanguageConfiguration;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;
import org.sonarsource.dotnet.shared.plugins.SarifParserCallbackImpl;
import org.sonarsource.dotnet.shared.sarif.SarifParserFactory;

@ScannerSide
public class RoslynDataImporter {
    private static final Logger LOG = LoggerFactory.getLogger(RoslynDataImporter.class);
    private static final String ROSLYN_REPOSITORY_PREFIX = "roslyn.";
    private final AbstractLanguageConfiguration config;
    private final PluginMetadata metadata;

    public RoslynDataImporter(PluginMetadata metadata, AbstractLanguageConfiguration config) {
        this.metadata = metadata;
        this.config = config;
    }

    public void importRoslynReports(List<RoslynReport> reports, SensorContext context, UnaryOperator<String> toRealPath) {
        Map<String, String> repositoryKeyByRoslynRuleKey = this.repoKeyByRoslynRuleKey(context.activeRules());
        boolean ignoreThirdPartyIssues = this.config.ignoreThirdPartyIssues();
        SarifParserCallbackImpl callback = new SarifParserCallbackImpl(context, repositoryKeyByRoslynRuleKey, ignoreThirdPartyIssues, this.config.bugCategories(), this.config.codeSmellCategories(), this.config.vulnerabilityCategories());
        LOG.info("Importing {} Roslyn {}", (Object)reports.size(), CallableUtils.lazy(() -> StringUtils.pluralize("report", reports.size())));
        for (RoslynReport report : reports) {
            LOG.debug("Processing Roslyn report: {}", (Object)report.getReportPath());
            SarifParserFactory.create(report, toRealPath).accept(callback);
        }
    }

    private Map<String, String> repoKeyByRoslynRuleKey(ActiveRules activeRules) {
        HashMap<String, String> repositoryKeyByRoslynRuleKey = new HashMap<String, String>();
        for (ActiveRule activeRule : activeRules.findAll()) {
            String previousRepositoryKey;
            if (!activeRule.ruleKey().repository().startsWith(ROSLYN_REPOSITORY_PREFIX) && !this.metadata.repositoryKey().equals(activeRule.ruleKey().repository()) || (previousRepositoryKey = repositoryKeyByRoslynRuleKey.put(activeRule.ruleKey().rule(), activeRule.ruleKey().repository())) == null) continue;
            throw new IllegalArgumentException("Rule keys must be unique, but \"" + activeRule.ruleKey().rule() + "\" is defined in both the \"" + previousRepositoryKey + "\" and \"" + activeRule.ruleKey().repository() + "\" rule repositories.");
        }
        return repositoryKeyByRoslynRuleKey;
    }
}

