/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.RoslynRules;

public class DotNetRulesDefinition
implements RulesDefinition {
    private static final String REPOSITORY_NAME = "SonarAnalyzer";
    private final PluginMetadata metadata;
    private final SonarRuntime sonarRuntime;
    private final RoslynRules roslynRules;

    public DotNetRulesDefinition(PluginMetadata metadata, SonarRuntime sonarRuntime, RoslynRules roslynRules) {
        this.metadata = metadata;
        this.sonarRuntime = sonarRuntime;
        this.roslynRules = roslynRules;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.metadata.repositoryKey(), this.metadata.languageKey()).setName(REPOSITORY_NAME);
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(this.metadata.resourcesDirectory(), this.metadata.resourcesDirectory() + "/Sonar_way_profile.json", this.sonarRuntime);
        ruleMetadataLoader.addRulesByRuleKey(repository, this.roslynRules.rules().stream().map(RoslynRules.Rule::getId).toList());
        for (RoslynRules.Rule rule : this.roslynRules.rules()) {
            RulesDefinition.NewRule currentRule = repository.rule(rule.id);
            if (currentRule == null) continue;
            for (RoslynRules.RuleParameter param : rule.parameters) {
                currentRule.createParam(param.key).setType(RuleParamType.parse((String)param.type)).setDescription(param.description).setDefaultValue(param.defaultValue);
            }
        }
        repository.done();
    }
}

