/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.RoslynRules;

public abstract class AbstractSonarWayProfile
implements BuiltInQualityProfilesDefinition {
    protected final PluginMetadata metadata;
    private final RoslynRules roslynRules;

    protected AbstractSonarWayProfile(PluginMetadata metadata, RoslynRules roslynRules) {
        this.metadata = metadata;
        this.roslynRules = roslynRules;
    }

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile sonarWay = context.createBuiltInQualityProfile("Sonar way", this.metadata.languageKey());
        String sonarWayJsonPath = this.metadata.resourcesDirectory() + "/Sonar_way_profile.json";
        Set roslynRuleIDs = this.roslynRules.rules().stream().map(RoslynRules.Rule::getId).collect(Collectors.toSet());
        for (String ruleID : BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(sonarWayJsonPath)) {
            if (!roslynRuleIDs.contains(ruleID)) continue;
            sonarWay.activateRule(this.metadata.repositoryKey(), ruleID);
        }
        this.registerRulesFromRegistrars(sonarWay);
        sonarWay.done();
    }

    protected void registerRulesFromRegistrars(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile) {
    }
}

