/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.UnitTestResultParser;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.XUnitTestResults;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;
import org.sonar.plugins.dotnet.tests.XmlTestReportParser;

@ScannerSide
public class XUnitTestResultsParser
implements UnitTestResultParser {
    private static final Logger LOG = LoggerFactory.getLogger(XUnitTestResultsParser.class);

    @Override
    public void parse(File file, Map<String, UnitTestResults> unitTestResults, Map<String, String> methodFileMap) {
        LOG.info("Parsing the XUnit Test Results file '{}'.", (Object)file.getAbsolutePath());
        Parser parser = new Parser(file, unitTestResults, methodFileMap, List.of("assembly", "assemblies"));
        Map<String, Consumer<XmlParserHelper>> tagHandlers = Map.of("assembly", parser::handleAssemblyTag, "test", parser::handleTestTag);
        parser.parse(tagHandlers);
    }

    private static class Parser
    extends XmlTestReportParser {
        private String dllName;

        Parser(File file, Map<String, UnitTestResults> unitTestResults, Map<String, String> methodFileMap, List<String> rootTags) {
            super(file, unitTestResults, methodFileMap, rootTags);
        }

        private void handleAssemblyTag(XmlParserHelper xmlParserHelper) {
            String assemblyName = xmlParserHelper.getRequiredAttribute("name");
            this.dllName = this.extractDllNameFromFilePath(assemblyName);
            LOG.debug("XUnit Assembly found, assembly name: {}, Extracted dllName: {}", (Object)assemblyName, (Object)this.dllName);
        }

        private void handleTestTag(XmlParserHelper xmlParserHelper) {
            String result = xmlParserHelper.getRequiredAttribute("result");
            Double time = xmlParserHelper.getDoubleAttribute("time");
            String type = xmlParserHelper.getRequiredAttribute("type");
            String method = xmlParserHelper.getRequiredAttribute("method");
            Long executionTime = time == null ? null : Long.valueOf((long)(time * 1000.0));
            XUnitTestResults testResults = new XUnitTestResults(result, executionTime);
            String fullName = this.getFullName(type + "." + method, this.dllName);
            this.addTestResultToFile(fullName, testResults);
        }
    }
}

