/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.telemetryjson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonStreamParser;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryJsonParser {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryJsonParser.class);

    public Stream<Map.Entry<String, String>> parse(Reader jsonReader) {
        JsonStreamParser p = new JsonStreamParser(jsonReader);
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        try {
            TelemetryJsonParser.collectTelemetry(p, result);
        }
        catch (JsonSyntaxException exception) {
            LOG.debug("Parsing of telemetry failed.");
        }
        catch (JsonIOException exception) {
            LOG.debug("Telemetry is empty.");
        }
        return result.stream();
    }

    private static void collectTelemetry(JsonStreamParser parser, ArrayList<Map.Entry<String, String>> result) {
        parser.forEachRemaining(x -> {
            if (x instanceof JsonObject) {
                JsonObject object = (JsonObject)x;
                for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
                    if (entry.getValue().isJsonPrimitive()) {
                        result.add(Map.entry(entry.getKey(), TelemetryJsonParser.getString(entry.getValue().getAsJsonPrimitive())));
                        continue;
                    }
                    LOG.debug("Could not parse telemetry property {}", x);
                }
            } else {
                LOG.debug("Could not parse telemetry entry {}", x);
            }
        });
    }

    private static String getString(JsonPrimitive entry) {
        return entry.isString() ? entry.getAsString() : entry.toString();
    }
}

