/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonarsource.dotnet.shared.plugins.ModuleConfiguration;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.telemetryjson.TelemetryJsonCollector;
import org.sonarsource.dotnet.shared.plugins.telemetryjson.TelemetryJsonParser;

public class TelemetryJsonSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryJsonSensor.class);
    private final PluginMetadata pluginMetadata;
    private final ModuleConfiguration configuration;
    private final TelemetryJsonCollector collector;

    public TelemetryJsonSensor(TelemetryJsonCollector collector, PluginMetadata pluginMetadata, ModuleConfiguration configuration) {
        this.pluginMetadata = pluginMetadata;
        this.configuration = configuration;
        this.collector = collector;
    }

    public void describe(SensorDescriptor sensorDescriptor) {
        String name = String.format("%s Telemetry Json", this.pluginMetadata.languageName());
        sensorDescriptor.name(name).onlyOnLanguage(this.pluginMetadata.languageKey());
    }

    public void execute(@Nonnull SensorContext sensorContext) {
        TelemetryJsonParser parser = new TelemetryJsonParser();
        for (Path file : this.configuration.telemetryJsonPaths()) {
            try (FileInputStream input = new FileInputStream(file.toFile());
                 InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);){
                parser.parse(reader).forEach(this.collector::addTelemetry);
            }
            catch (IOException e) {
                LOG.debug("Cannot open telemetry file {}, {}", (Object)file, (Object)e.toString());
            }
        }
    }
}

