/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.telemetryjson.TelemetryUtils;

public class TelemetryAggregator {
    public final String languageVersion;
    public final String targetFramework;

    public TelemetryAggregator(String pluginKey, String language) {
        String pluginLanguageKey = pluginKey + "." + language + ".";
        this.languageVersion = pluginLanguageKey + "language_version.%s";
        this.targetFramework = pluginLanguageKey + "target_framework.%s";
    }

    private static <V> Map.Entry<String, String> kvp(String key, V value) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value.toString());
    }

    private String key(String pattern, String ... keys) {
        String[] formattedKeys = this.sanitizeKeys(keys);
        return pattern.formatted(formattedKeys);
    }

    private String[] sanitizeKeys(String[] keys) {
        return (String[])Arrays.stream(keys).map(TelemetryUtils::sanitizeKey).toArray(String[]::new);
    }

    private Stream<Map.Entry<String, String>> languageVersion(Stream<String> languageVersions) {
        Map countBy = languageVersions.filter(x -> !x.isEmpty()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return countBy.entrySet().stream().map(x -> TelemetryAggregator.kvp(this.key(this.languageVersion, (String)x.getKey()), (Long)x.getValue()));
    }

    private Stream<Map.Entry<String, String>> targetFrameworks(Stream<Collection<String>> targetFrameworks) {
        Map countBy = targetFrameworks.flatMap(Collection::stream).filter(x -> !x.isEmpty()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return countBy.entrySet().stream().map(x -> TelemetryAggregator.kvp(this.key(this.targetFramework, (String)x.getKey()), (Long)x.getValue()));
    }

    public Collection<Map.Entry<String, String>> aggregate(Collection<SonarAnalyzer.Telemetry> telemetries) {
        return Stream.of(this.languageVersion(telemetries.stream().map(SonarAnalyzer.Telemetry::getLanguageVersion)), this.targetFrameworks(telemetries.stream().map(SonarAnalyzer.Telemetry::getTargetFrameworkList))).flatMap(Function.identity()).toList();
    }
}

